/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jline.Completor;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.Token;
import org.apache.accumulo.core.util.shell.commands.QuotedStringTokenizer;

public class ShellCompletor
implements Completor {
    Map<Shell.Command.CompletionSet, Set<String>> options;
    Token root = null;

    public ShellCompletor() {
    }

    public ShellCompletor(Token root) {
        this.root = root;
    }

    public ShellCompletor(Token rootToken, Map<Shell.Command.CompletionSet, Set<String>> options) {
        this.root = rootToken;
        this.options = options;
    }

    public int complete(String buffer, int cursor, List candidates) {
        try {
            return this._complete(buffer, cursor, candidates);
        }
        catch (Exception e) {
            candidates.add("");
            candidates.add(e.getMessage());
            return cursor;
        }
    }

    private int _complete(String fullBuffer, int cursor, List<String> candidates) {
        boolean inTableFlag = false;
        boolean inUserFlag = false;
        String buffer = fullBuffer.substring(0, cursor);
        Token current_command_token = this.root;
        String current_string_token = null;
        boolean end_space = buffer.endsWith(" ");
        if (buffer.length() == 0) {
            candidates.addAll(this.root.getSubcommandNames());
            return 0;
        }
        String prefix = "";
        QuotedStringTokenizer qst = new QuotedStringTokenizer(buffer);
        Iterator<String> iter = qst.iterator();
        while (iter.hasNext()) {
            current_string_token = iter.next();
            current_string_token = current_string_token.replaceAll("([\\s'\"])", "\\\\$1");
            if (!iter.hasNext()) {
                if (end_space && !current_string_token.endsWith(" ") || buffer.endsWith("\"")) {
                    Token next;
                    if (current_string_token.trim().equals("-t")) {
                        candidates.addAll((Collection<String>)this.options.get((Object)Shell.Command.CompletionSet.TABLENAMES));
                        prefix = prefix + "-t ";
                    } else if (current_string_token.trim().equals("-u")) {
                        candidates.addAll((Collection<String>)this.options.get((Object)Shell.Command.CompletionSet.USERNAMES));
                        prefix = prefix + "-u ";
                    } else if (current_command_token != null && (next = current_command_token.getSubcommand(current_string_token)) != null) {
                        current_command_token = next;
                        prefix = current_command_token.getCaseSensitive() ? prefix + current_string_token + " " : prefix + current_string_token.toUpperCase() + " ";
                        candidates.addAll(current_command_token.getSubcommandNames());
                    }
                    Collections.sort(candidates);
                    return prefix.length();
                }
                if (inTableFlag) {
                    for (String a : this.options.get((Object)Shell.Command.CompletionSet.TABLENAMES)) {
                        if (!a.startsWith(current_string_token)) continue;
                        candidates.add(a);
                    }
                } else if (inUserFlag) {
                    for (String a : this.options.get((Object)Shell.Command.CompletionSet.USERNAMES)) {
                        if (!a.startsWith(current_string_token)) continue;
                        candidates.add(a);
                    }
                } else if (current_command_token != null) {
                    candidates.addAll(current_command_token.getSubcommandNames(current_string_token));
                }
                Collections.sort(candidates);
                return prefix.length();
            }
            if (current_string_token.trim().equals("-t")) {
                inTableFlag = true;
            } else if (current_string_token.trim().equals("-u")) {
                inUserFlag = true;
            } else {
                inTableFlag = false;
                inUserFlag = false;
            }
            prefix = current_command_token != null && current_command_token.getCaseSensitive() ? prefix + current_string_token + " " : prefix + current_string_token.toUpperCase() + " ";
            if (current_command_token == null || !current_command_token.getSubcommandNames().contains(current_string_token)) continue;
            current_command_token = current_command_token.getSubcommand(current_string_token);
        }
        return 0;
    }
}

