/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.io.Text;

public class GetGroupsCommand
extends Shell.Command {
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        Map<String, Set<Text>> groups = shellState.getConnector().tableOperations().getLocalityGroups(tableName);
        for (Map.Entry<String, Set<Text>> entry : groups.entrySet()) {
            shellState.getReader().printString(entry.getKey() + "=" + LocalityGroupUtil.encodeColumnFamilies(entry.getValue()) + "\n");
        }
        return 0;
    }

    @Override
    public String description() {
        return "gets the locality groups for a given table";
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public Options getOptions() {
        Options opts = new Options();
        opts.addOption(OptUtil.tableOpt("table to fetch locality groups from"));
        return opts;
    }
}

