/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.Token;
import org.apache.accumulo.core.util.shell.commands.TableOperation;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class GrantCommand
extends TableOperation {
    private Option systemOpt;
    private Option userOpt;
    private String user;
    private String[] permission;

    public GrantCommand() {
        this.disableUnflaggedTableOptions();
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        this.user = cl.hasOption(this.userOpt.getOpt()) ? cl.getOptionValue(this.userOpt.getOpt()) : shellState.getConnector().whoami();
        this.permission = cl.getArgs()[0].split("\\.", 2);
        if (cl.hasOption(this.systemOpt.getOpt()) && this.permission[0].equalsIgnoreCase("System")) {
            try {
                shellState.getConnector().securityOperations().grantSystemPermission(this.user, SystemPermission.valueOf(this.permission[1]));
                Shell.log.debug((Object)("Granted " + this.user + " the " + this.permission[1] + " permission"));
            }
            catch (IllegalArgumentException e) {
                throw new BadArgumentException("No such system permission", fullCommand, fullCommand.indexOf(cl.getArgs()[0]));
            }
        } else if (this.permission[0].equalsIgnoreCase("Table")) {
            super.execute(fullCommand, cl, shellState);
        } else {
            throw new BadArgumentException("Unrecognized permission", fullCommand, fullCommand.indexOf(cl.getArgs()[0]));
        }
        return 0;
    }

    @Override
    protected void doTableOp(Shell shellState, String tableName) throws Exception {
        try {
            shellState.getConnector().securityOperations().grantTablePermission(this.user, tableName, TablePermission.valueOf(this.permission[1]));
            Shell.log.debug((Object)("Granted " + this.user + " the " + this.permission[1] + " permission on table " + tableName));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("No such table permission", e);
        }
    }

    @Override
    public String description() {
        return "grants system or table permissions for a user";
    }

    @Override
    public String usage() {
        return this.getName() + " <permission>";
    }

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> completionSet) {
        Token cmd = new Token(this.getName());
        cmd.addSubcommand(new Token(TablePermission.printableValues()));
        cmd.addSubcommand(new Token(SystemPermission.printableValues()));
        root.addSubcommand(cmd);
    }

    @Override
    public Options getOptions() {
        super.getOptions();
        Options o = new Options();
        OptionGroup group = new OptionGroup();
        this.systemOpt = new Option("s", "system", false, "grant a system permission");
        group.addOption(this.systemOpt);
        group.addOption(this.optTableName);
        group.addOption(this.optTablePattern);
        o.addOptionGroup(group);
        this.userOpt = new Option("u", "user", true, "user to operate on");
        this.userOpt.setArgName("username");
        this.userOpt.setRequired(true);
        o.addOption(this.userOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return 1;
    }
}

