/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.data.SchemaTupleBackend;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.util.HashOutputStream;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.newplan.BaseOperatorPlan;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.DotLOPrinter;
import org.apache.pig.newplan.logical.optimizer.LogicalPlanOptimizer;
import org.apache.pig.newplan.logical.optimizer.LogicalPlanPrinter;
import org.apache.pig.newplan.logical.optimizer.SchemaResetter;
import org.apache.pig.newplan.logical.optimizer.UidResetter;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.visitor.CastLineageSetter;
import org.apache.pig.newplan.logical.visitor.ColumnAliasConversionVisitor;
import org.apache.pig.newplan.logical.visitor.DanglingNestedNodeRemover;
import org.apache.pig.newplan.logical.visitor.DuplicateForEachColumnRewriteVisitor;
import org.apache.pig.newplan.logical.visitor.ImplicitSplitInsertVisitor;
import org.apache.pig.newplan.logical.visitor.InputOutputFileValidatorVisitor;
import org.apache.pig.newplan.logical.visitor.ScalarVariableValidator;
import org.apache.pig.newplan.logical.visitor.ScalarVisitor;
import org.apache.pig.newplan.logical.visitor.SchemaAliasVisitor;
import org.apache.pig.newplan.logical.visitor.SortInfoSetter;
import org.apache.pig.newplan.logical.visitor.StoreAliasSetter;
import org.apache.pig.newplan.logical.visitor.TypeCheckingRelVisitor;
import org.apache.pig.newplan.logical.visitor.UnionOnSchemaSetter;
import org.apache.pig.pen.POOptimizeDisabler;
import org.apache.pig.validator.BlackAndWhitelistValidator;

public class LogicalPlan
extends BaseOperatorPlan {
    public LogicalPlan(LogicalPlan other) {
        super(other);
    }

    public LogicalPlan() {
    }

    @Override
    public boolean isEqual(OperatorPlan other) throws FrontendException {
        if (other == null || !(other instanceof LogicalPlan)) {
            return false;
        }
        return super.isEqual(other);
    }

    @Override
    public void explain(PrintStream ps, String format, boolean verbose) throws FrontendException {
        if (format.equals("xml")) {
            ps.println("<logicalPlan>XML Not Supported</logicalPlan>");
            return;
        }
        ps.println("#-----------------------------------------------");
        ps.println("# New Logical Plan:");
        ps.println("#-----------------------------------------------");
        if (this.size() == 0) {
            ps.println("Logical plan is empty.");
        } else if (format.equals("dot")) {
            DotLOPrinter lpp = new DotLOPrinter(this, ps);
            lpp.dump();
        } else {
            LogicalPlanPrinter npp = new LogicalPlanPrinter((OperatorPlan)this, ps);
            npp.visit();
        }
    }

    public Operator findByAlias(String alias) {
        Iterator<Operator> it = this.getOperators();
        ArrayList<LogicalRelationalOperator> ops = new ArrayList<LogicalRelationalOperator>();
        while (it.hasNext()) {
            LogicalRelationalOperator op = (LogicalRelationalOperator)it.next();
            if (op.getAlias() == null || !op.getAlias().equals(alias)) continue;
            ops.add(op);
        }
        if (ops.isEmpty()) {
            return null;
        }
        return (Operator)ops.get(ops.size() - 1);
    }

    public String getSignature() throws FrontendException {
        HashFunction hf = Hashing.murmur3_32((int)0);
        HashOutputStream hos = new HashOutputStream(hf);
        PrintStream ps = new PrintStream(hos);
        LogicalPlanPrinter printer = new LogicalPlanPrinter((OperatorPlan)this, ps);
        printer.visit();
        return Integer.toString(hos.getHashCode().asInt());
    }

    public void validate(PigContext pigContext, String scope, boolean skipInputOutputValidation) throws FrontendException {
        new DanglingNestedNodeRemover(this).visit();
        new ColumnAliasConversionVisitor(this).visit();
        new SchemaAliasVisitor(this).visit();
        new ScalarVisitor(this, pigContext, scope).visit();
        new ImplicitSplitInsertVisitor(this).visit();
        new DuplicateForEachColumnRewriteVisitor(this).visit();
        CompilationMessageCollector collector = new CompilationMessageCollector();
        new TypeCheckingRelVisitor((OperatorPlan)this, collector).visit();
        boolean aggregateWarning = "true".equalsIgnoreCase(pigContext.getProperties().getProperty("aggregate.warning"));
        if (aggregateWarning) {
            CompilationMessageCollector.logMessages(collector, CompilationMessageCollector.MessageType.Warning, aggregateWarning, log);
        } else {
            for (CompilationMessageCollector.MessageType type : CompilationMessageCollector.MessageType.values()) {
                CompilationMessageCollector.logAllMessages(collector, log);
            }
        }
        new UnionOnSchemaSetter(this).visit();
        new CastLineageSetter(this, collector).visit();
        new ScalarVariableValidator(this).visit();
        new StoreAliasSetter(this).visit();
        new SortInfoSetter(this).visit();
        if (!(skipInputOutputValidation || pigContext.inExplain || pigContext.inDumpSchema)) {
            new InputOutputFileValidatorVisitor((OperatorPlan)this, pigContext).visit();
        }
        BlackAndWhitelistValidator validator = new BlackAndWhitelistValidator(pigContext, this);
        validator.validate();
        UidResetter uidResetter = new UidResetter(this);
        uidResetter.visit();
        SchemaResetter schemaResetter = new SchemaResetter((OperatorPlan)this, true);
        schemaResetter.visit();
    }

    public void optimize(PigContext pigContext) throws FrontendException {
        String pigOptimizerRulesDisabled;
        HashSet<String> disabledOptimizerRules;
        if (pigContext.inIllustrator) {
            POOptimizeDisabler pod = new POOptimizeDisabler(this);
            pod.visit();
        }
        try {
            disabledOptimizerRules = (HashSet<String>)ObjectSerializer.deserialize(pigContext.getProperties().getProperty("pig.optimizer.rules"));
        }
        catch (IOException ioe) {
            int errCode = 2110;
            String msg = "Unable to deserialize optimizer rules.";
            throw new FrontendException(msg, errCode, 4, (Throwable)ioe);
        }
        if (disabledOptimizerRules == null) {
            disabledOptimizerRules = new HashSet<String>();
        }
        if ((pigOptimizerRulesDisabled = pigContext.getProperties().getProperty("pig.optimizer.rules.disabled")) != null) {
            disabledOptimizerRules.addAll(Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)pigOptimizerRulesDisabled)));
        }
        if (pigContext.inIllustrator) {
            disabledOptimizerRules.add("MergeForEach");
            disabledOptimizerRules.add("PartitionFilterOptimizer");
            disabledOptimizerRules.add("LimitOptimizer");
            disabledOptimizerRules.add("SplitFilter");
            disabledOptimizerRules.add("PushUpFilter");
            disabledOptimizerRules.add("MergeFilter");
            disabledOptimizerRules.add("PushDownForEachFlatten");
            disabledOptimizerRules.add("ColumnMapKeyPrune");
            disabledOptimizerRules.add("AddForEach");
            disabledOptimizerRules.add("GroupByConstParallelSetter");
        }
        try {
            SchemaTupleBackend.initialize(ConfigurationUtil.toConfiguration(pigContext.getProperties(), true), pigContext);
        }
        catch (IOException e) {
            throw new FrontendException(e);
        }
        LogicalPlanOptimizer optimizer = new LogicalPlanOptimizer(this, 100, disabledOptimizerRules, pigContext);
        optimizer.optimize();
    }
}

