/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobClient;
import org.apache.pig.PigException;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.BaseOperatorPlan;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.tools.pigstats.InputStats;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.OutputStats;
import org.apache.pig.tools.pigstats.ScriptState;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class PigStats {
    private static final Log LOG = LogFactory.getLog(PigStats.class);
    private static ThreadLocal<PigStats> tps = new ThreadLocal();
    protected static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    protected long startTime = -1L;
    protected long endTime = -1L;
    protected String userId;
    protected JobGraph jobPlan;
    protected PigContext pigContext;
    protected Map<String, OutputStats> aliasOuputMap;
    protected int errorCode = -1;
    protected String errorMessage = null;
    protected Throwable errorThrowable = null;
    protected int returnCode = -1;

    public static PigStats get() {
        return tps.get();
    }

    public static PigStats start(PigStats stats) {
        tps.set(stats);
        return tps.get();
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Throwable getErrorThrowable() {
        return this.errorThrowable;
    }

    @Deprecated
    public abstract JobClient getJobClient();

    public abstract boolean isEmbedded();

    public boolean isSuccessful() {
        return this.getNumberJobs() == 0 && this.returnCode == -1 || this.returnCode == 0;
    }

    public abstract Map<String, List<PigStats>> getAllStats();

    public abstract List<String> getAllErrorMessages();

    public Properties getPigProperties() {
        if (this.pigContext == null) {
            return null;
        }
        return this.pigContext.getProperties();
    }

    public JobGraph getJobGraph() {
        return this.jobPlan;
    }

    public List<String> getOutputLocations() {
        ArrayList<String> locations = new ArrayList<String>();
        for (OutputStats output : this.getOutputStats()) {
            locations.add(output.getLocation());
        }
        return Collections.unmodifiableList(locations);
    }

    public List<String> getOutputNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (OutputStats output : this.getOutputStats()) {
            names.add(output.getName());
        }
        return Collections.unmodifiableList(names);
    }

    public long getNumberBytes(String location) {
        if (location == null) {
            return -1L;
        }
        String name = new Path(location).getName();
        long count = -1L;
        for (OutputStats output : this.getOutputStats()) {
            if (!name.equals(output.getName())) continue;
            count = output.getBytes();
            break;
        }
        return count;
    }

    public long getNumberRecords(String location) {
        if (location == null) {
            return -1L;
        }
        String name = new Path(location).getName();
        long count = -1L;
        for (OutputStats output : this.getOutputStats()) {
            if (!name.equals(output.getName())) continue;
            count = output.getNumberRecords();
            break;
        }
        return count;
    }

    public String getOutputAlias(String location) {
        if (location == null) {
            return null;
        }
        String name = new Path(location).getName();
        String alias = null;
        for (OutputStats output : this.getOutputStats()) {
            if (!name.equals(output.getName())) continue;
            alias = output.getAlias();
            break;
        }
        return alias;
    }

    public abstract long getSMMSpillCount();

    public abstract long getProactiveSpillCountObjects();

    public abstract long getProactiveSpillCountRecords();

    public long getBytesWritten() {
        Iterator<JobStats> it = this.jobPlan.iterator();
        long ret = 0L;
        while (it.hasNext()) {
            long n = it.next().getBytesWritten();
            if (n <= 0L) continue;
            ret += n;
        }
        return ret;
    }

    public long getRecordWritten() {
        Iterator<JobStats> it = this.jobPlan.iterator();
        long ret = 0L;
        while (it.hasNext()) {
            long n = it.next().getRecordWrittern();
            if (n <= 0L) continue;
            ret += n;
        }
        return ret;
    }

    public String getHadoopVersion() {
        return ScriptState.get().getHadoopVersion();
    }

    public String getPigVersion() {
        return ScriptState.get().getPigVersion();
    }

    public String getScriptId() {
        return ScriptState.get().getId();
    }

    public String getFileName() {
        return ScriptState.get().getFileName();
    }

    public String getFeatures() {
        return ScriptState.get().getScriptFeatures();
    }

    public long getDuration() {
        return this.startTime > 0L && this.endTime > 0L ? this.endTime - this.startTime : -1L;
    }

    public int getNumberJobs() {
        return this.jobPlan.size();
    }

    public List<OutputStats> getOutputStats() {
        ArrayList<OutputStats> outputs = new ArrayList<OutputStats>();
        Iterator<JobStats> iter = this.jobPlan.iterator();
        while (iter.hasNext()) {
            for (OutputStats os : iter.next().getOutputs()) {
                outputs.add(os);
            }
        }
        return Collections.unmodifiableList(outputs);
    }

    public OutputStats result(String alias) {
        if (this.aliasOuputMap == null) {
            this.aliasOuputMap = Maps.newHashMap();
            Iterator<JobStats> iter = this.jobPlan.iterator();
            while (iter.hasNext()) {
                for (OutputStats os : iter.next().getOutputs()) {
                    String a = os.getAlias();
                    if (a == null || a.length() == 0) {
                        LOG.warn((Object)("Output alias isn't avalable for " + os.getLocation()));
                        continue;
                    }
                    this.aliasOuputMap.put(a, os);
                }
            }
        }
        return this.aliasOuputMap.get(alias);
    }

    public List<InputStats> getInputStats() {
        ArrayList<InputStats> inputs = new ArrayList<InputStats>();
        Iterator<JobStats> iter = this.jobPlan.iterator();
        while (iter.hasNext()) {
            for (InputStats is : iter.next().getInputs()) {
                inputs.add(is);
            }
        }
        return Collections.unmodifiableList(inputs);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorThrowable(Throwable t) {
        this.errorThrowable = t;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    @InterfaceAudience.Private
    public void setBackendException(String jobId, Exception e) {
        if (e instanceof PigException) {
            LOG.error((Object)("ERROR " + ((PigException)e).getErrorCode() + ": " + e.getLocalizedMessage()));
        } else if (e != null) {
            LOG.error((Object)("ERROR: " + e.getLocalizedMessage()));
        }
        if (jobId == null || e == null) {
            LOG.debug((Object)"unable to set backend exception");
            return;
        }
        for (JobStats js : this.jobPlan) {
            if (!jobId.equals(js.getJobId())) continue;
            js.setBackendException(e);
            break;
        }
    }

    @InterfaceAudience.Private
    public PigContext getPigContext() {
        return this.pigContext;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.userId = System.getProperty("user.name");
    }

    public void stop() {
        this.endTime = System.currentTimeMillis();
        int failed = this.getNumberFailedJobs();
        int succeeded = this.getNumberSuccessfulJobs();
        this.returnCode = failed == 0 && succeeded > 0 && succeeded == this.jobPlan.size() ? 0 : (succeeded > 0 && succeeded < this.jobPlan.size() ? 3 : 2);
    }

    public int getNumberSuccessfulJobs() {
        Iterator<JobStats> iter = this.jobPlan.iterator();
        int count = 0;
        while (iter.hasNext()) {
            if (iter.next().getState() != JobStats.JobState.SUCCESS) continue;
            ++count;
        }
        return count;
    }

    public int getNumberFailedJobs() {
        Iterator<JobStats> iter = this.jobPlan.iterator();
        int count = 0;
        while (iter.hasNext()) {
            if (iter.next().getState() != JobStats.JobState.FAILED) continue;
            ++count;
        }
        return count;
    }

    private static class JobComparator
    implements Comparator<JobStats> {
        private JobComparator() {
        }

        @Override
        public int compare(JobStats o1, JobStats o2) {
            return o1.getJobId().compareTo(o2.getJobId());
        }
    }

    public static class JobGraph
    extends BaseOperatorPlan
    implements Iterable<JobStats> {
        @Override
        public String toString() {
            JobGraphPrinter jp = new JobGraphPrinter(this);
            try {
                jp.visit();
            }
            catch (FrontendException e) {
                LOG.warn((Object)"unable to print job plan", (Throwable)e);
            }
            return jp.toString();
        }

        public List<JobStats> getJobList() {
            return IteratorUtils.toList(this.iterator());
        }

        @Override
        public Iterator<JobStats> iterator() {
            return new Iterator<JobStats>(){
                private Iterator<Operator> iter;
                {
                    this.iter = JobGraph.this.getOperators();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public JobStats next() {
                    return (JobStats)this.iter.next();
                }

                @Override
                public void remove() {
                }
            };
        }

        @Override
        public boolean isConnected(Operator from, Operator to) {
            List<Operator> succs = null;
            succs = this.getSuccessors(from);
            if (succs != null) {
                for (Operator succ : succs) {
                    if (!succ.getName().equals(to.getName()) && !this.isConnected(succ, to)) continue;
                    return true;
                }
            }
            return false;
        }

        public List<JobStats> getSuccessfulJobs() {
            ArrayList<JobStats> lst = new ArrayList<JobStats>();
            for (JobStats js : this) {
                if (js.getState() != JobStats.JobState.SUCCESS) continue;
                lst.add(js);
            }
            Collections.sort(lst, new JobComparator());
            return lst;
        }

        public List<JobStats> getFailedJobs() {
            ArrayList<JobStats> lst = new ArrayList<JobStats>();
            for (JobStats js : this) {
                if (js.getState() != JobStats.JobState.FAILED) continue;
                lst.add(js);
            }
            return lst;
        }
    }

    public static class JobGraphPrinter
    extends PlanVisitor {
        StringBuffer buf = new StringBuffer();

        protected JobGraphPrinter(OperatorPlan plan) {
            super(plan, new DependencyOrderWalker(plan));
        }

        public void visit(JobStats op) throws FrontendException {
            this.buf.append(op.getJobId());
            List<Operator> succs = this.plan.getSuccessors(op);
            if (succs != null) {
                this.buf.append("\t->\t");
                for (Operator p : succs) {
                    this.buf.append(((JobStats)p).getJobId()).append(",");
                }
            }
            this.buf.append("\n");
        }

        public String toString() {
            this.buf.append("\n");
            return this.buf.toString();
        }
    }
}

