/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.ml.inference.trainedmodel.InferenceStats;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class TrainedModelStats
implements ToXContentObject {
    public static final ParseField MODEL_ID = new ParseField("model_id", new String[0]);
    public static final ParseField PIPELINE_COUNT = new ParseField("pipeline_count", new String[0]);
    public static final ParseField INGEST_STATS = new ParseField("ingest", new String[0]);
    public static final ParseField INFERENCE_STATS = new ParseField("inference_stats", new String[0]);
    private final String modelId;
    private final Map<String, Object> ingestStats;
    private final int pipelineCount;
    private final InferenceStats inferenceStats;
    static final ConstructingObjectParser<TrainedModelStats, Void> PARSER = new ConstructingObjectParser("trained_model_stats", true, args -> new TrainedModelStats((String)args[0], (Map)args[1], (Integer)args[2], (InferenceStats)args[3]));

    public static TrainedModelStats fromXContent(XContentParser parser) {
        return (TrainedModelStats)PARSER.apply(parser, null);
    }

    public TrainedModelStats(String modelId, Map<String, Object> ingestStats, int pipelineCount, InferenceStats inferenceStats) {
        this.modelId = modelId;
        this.ingestStats = ingestStats;
        this.pipelineCount = pipelineCount;
        this.inferenceStats = inferenceStats;
    }

    public String getModelId() {
        return this.modelId;
    }

    @Nullable
    public Map<String, Object> getIngestStats() {
        return this.ingestStats;
    }

    public int getPipelineCount() {
        return this.pipelineCount;
    }

    public InferenceStats getInferenceStats() {
        return this.inferenceStats;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_ID.getPreferredName(), this.modelId);
        builder.field(PIPELINE_COUNT.getPreferredName(), this.pipelineCount);
        if (this.ingestStats != null) {
            builder.field(INGEST_STATS.getPreferredName(), this.ingestStats);
        }
        if (this.inferenceStats != null) {
            builder.field(INFERENCE_STATS.getPreferredName(), (ToXContent)this.inferenceStats);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.ingestStats, this.pipelineCount, this.inferenceStats);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrainedModelStats other = (TrainedModelStats)obj;
        return Objects.equals(this.modelId, other.modelId) && Objects.equals(this.ingestStats, other.ingestStats) && Objects.equals(this.pipelineCount, other.pipelineCount) && Objects.equals(this.inferenceStats, other.inferenceStats);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), MODEL_ID);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapOrdered(), INGEST_STATS);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), PIPELINE_COUNT);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), InferenceStats.PARSER, INFERENCE_STATS);
    }
}

