/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.SpatialQuery;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.Line;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.NumericUtils;

final class LatLonShapeQuery
extends SpatialQuery {
    private final LatLonGeometry[] geometries;
    private final Component2D component2D;

    LatLonShapeQuery(String field, ShapeField.QueryRelation queryRelation, LatLonGeometry ... geometries) {
        super(field, queryRelation);
        if (queryRelation == ShapeField.QueryRelation.WITHIN) {
            for (LatLonGeometry geometry : geometries) {
                if (!(geometry instanceof Line)) continue;
                throw new IllegalArgumentException("LatLonShapeQuery does not support " + (Object)((Object)ShapeField.QueryRelation.WITHIN) + " queries with line geometries");
            }
        }
        this.component2D = LatLonGeometry.create(geometries);
        this.geometries = (LatLonGeometry[])geometries.clone();
    }

    @Override
    protected SpatialQuery.SpatialVisitor getSpatialVisitor() {
        return new SpatialQuery.SpatialVisitor(){

            @Override
            protected PointValues.Relation relate(byte[] minTriangle, byte[] maxTriangle) {
                double minLat = GeoEncodingUtils.decodeLatitude(NumericUtils.sortableBytesToInt(minTriangle, 0));
                double minLon = GeoEncodingUtils.decodeLongitude(NumericUtils.sortableBytesToInt(minTriangle, 4));
                double maxLat = GeoEncodingUtils.decodeLatitude(NumericUtils.sortableBytesToInt(maxTriangle, 8));
                double maxLon = GeoEncodingUtils.decodeLongitude(NumericUtils.sortableBytesToInt(maxTriangle, 12));
                return LatLonShapeQuery.this.component2D.relate(minLon, maxLon, minLat, maxLat);
            }

            @Override
            protected Predicate<byte[]> intersects() {
                ShapeField.DecodedTriangle scratchTriangle = new ShapeField.DecodedTriangle();
                return triangle -> {
                    ShapeField.decodeTriangle(triangle, scratchTriangle);
                    switch (scratchTriangle.type) {
                        case POINT: {
                            double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
                            double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
                            return LatLonShapeQuery.this.component2D.contains(alon, alat);
                        }
                        case LINE: {
                            double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
                            double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
                            double blat = GeoEncodingUtils.decodeLatitude(scratchTriangle.bY);
                            double blon = GeoEncodingUtils.decodeLongitude(scratchTriangle.bX);
                            return LatLonShapeQuery.this.component2D.intersectsLine(alon, alat, blon, blat);
                        }
                        case TRIANGLE: {
                            double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
                            double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
                            double blat = GeoEncodingUtils.decodeLatitude(scratchTriangle.bY);
                            double blon = GeoEncodingUtils.decodeLongitude(scratchTriangle.bX);
                            double clat = GeoEncodingUtils.decodeLatitude(scratchTriangle.cY);
                            double clon = GeoEncodingUtils.decodeLongitude(scratchTriangle.cX);
                            return LatLonShapeQuery.this.component2D.intersectsTriangle(alon, alat, blon, blat, clon, clat);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported triangle type :[" + (Object)((Object)scratchTriangle.type) + "]");
                };
            }

            @Override
            protected Predicate<byte[]> within() {
                ShapeField.DecodedTriangle scratchTriangle = new ShapeField.DecodedTriangle();
                return triangle -> {
                    ShapeField.decodeTriangle(triangle, scratchTriangle);
                    switch (scratchTriangle.type) {
                        case POINT: {
                            double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
                            double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
                            return LatLonShapeQuery.this.component2D.contains(alon, alat);
                        }
                        case LINE: {
                            double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
                            double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
                            double blat = GeoEncodingUtils.decodeLatitude(scratchTriangle.bY);
                            double blon = GeoEncodingUtils.decodeLongitude(scratchTriangle.bX);
                            return LatLonShapeQuery.this.component2D.containsLine(alon, alat, blon, blat);
                        }
                        case TRIANGLE: {
                            double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
                            double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
                            double blat = GeoEncodingUtils.decodeLatitude(scratchTriangle.bY);
                            double blon = GeoEncodingUtils.decodeLongitude(scratchTriangle.bX);
                            double clat = GeoEncodingUtils.decodeLatitude(scratchTriangle.cY);
                            double clon = GeoEncodingUtils.decodeLongitude(scratchTriangle.cX);
                            return LatLonShapeQuery.this.component2D.containsTriangle(alon, alat, blon, blat, clon, clat);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported triangle type :[" + (Object)((Object)scratchTriangle.type) + "]");
                };
            }

            @Override
            protected Function<byte[], Component2D.WithinRelation> contains() {
                ShapeField.DecodedTriangle scratchTriangle = new ShapeField.DecodedTriangle();
                return triangle -> {
                    ShapeField.decodeTriangle(triangle, scratchTriangle);
                    switch (scratchTriangle.type) {
                        case POINT: {
                            double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
                            double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
                            return LatLonShapeQuery.this.component2D.withinPoint(alon, alat);
                        }
                        case LINE: {
                            double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
                            double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
                            double blat = GeoEncodingUtils.decodeLatitude(scratchTriangle.bY);
                            double blon = GeoEncodingUtils.decodeLongitude(scratchTriangle.bX);
                            return LatLonShapeQuery.this.component2D.withinLine(alon, alat, scratchTriangle.ab, blon, blat);
                        }
                        case TRIANGLE: {
                            double alat = GeoEncodingUtils.decodeLatitude(scratchTriangle.aY);
                            double alon = GeoEncodingUtils.decodeLongitude(scratchTriangle.aX);
                            double blat = GeoEncodingUtils.decodeLatitude(scratchTriangle.bY);
                            double blon = GeoEncodingUtils.decodeLongitude(scratchTriangle.bX);
                            double clat = GeoEncodingUtils.decodeLatitude(scratchTriangle.cY);
                            double clon = GeoEncodingUtils.decodeLongitude(scratchTriangle.cX);
                            return LatLonShapeQuery.this.component2D.withinTriangle(alon, alat, scratchTriangle.ab, blon, blat, scratchTriangle.bc, clon, clat, scratchTriangle.ca);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported triangle type :[" + (Object)((Object)scratchTriangle.type) + "]");
                };
            }
        };
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("[");
        for (int i = 0; i < this.geometries.length; ++i) {
            sb.append(this.geometries[i].toString());
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && Arrays.equals(this.geometries, ((LatLonShapeQuery)o).geometries);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.geometries);
        return hash;
    }
}

