/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IntroSelector;
import org.apache.lucene.util.Selector;

public abstract class RadixSelector
extends Selector {
    private static final int LEVEL_THRESHOLD = 8;
    private static final int HISTOGRAM_SIZE = 257;
    private static final int LENGTH_THRESHOLD = 100;
    private final int[] histogram = new int[257];
    private final int[] commonPrefix;
    private final int maxLength;

    protected RadixSelector(int maxLength) {
        this.maxLength = maxLength;
        this.commonPrefix = new int[Math.min(24, maxLength)];
    }

    protected abstract int byteAt(int var1, int var2);

    protected Selector getFallbackSelector(final int d) {
        return new IntroSelector(){
            private final BytesRefBuilder pivot = new BytesRefBuilder();

            @Override
            protected void swap(int i, int j) {
                RadixSelector.this.swap(i, j);
            }

            @Override
            protected int compare(int i, int j) {
                for (int o = d; o < RadixSelector.this.maxLength; ++o) {
                    int b2;
                    int b1 = RadixSelector.this.byteAt(i, o);
                    if (b1 != (b2 = RadixSelector.this.byteAt(j, o))) {
                        return b1 - b2;
                    }
                    if (b1 == -1) break;
                }
                return 0;
            }

            @Override
            protected void setPivot(int i) {
                int b;
                this.pivot.setLength(0);
                for (int o = d; o < RadixSelector.this.maxLength && (b = RadixSelector.this.byteAt(i, o)) != -1; ++o) {
                    this.pivot.append((byte)b);
                }
            }

            @Override
            protected int comparePivot(int j) {
                for (int o = 0; o < this.pivot.length(); ++o) {
                    int b2;
                    int b1 = this.pivot.byteAt(o) & 0xFF;
                    if (b1 == (b2 = RadixSelector.this.byteAt(j, d + o))) continue;
                    return b1 - b2;
                }
                if (d + this.pivot.length() == RadixSelector.this.maxLength) {
                    return 0;
                }
                return -1 - RadixSelector.this.byteAt(j, d + this.pivot.length());
            }
        };
    }

    @Override
    public void select(int from, int to, int k) {
        this.checkArgs(from, to, k);
        this.select(from, to, k, 0, 0);
    }

    private void select(int from, int to, int k, int d, int l) {
        if (to - from <= 100 || l >= 8) {
            this.getFallbackSelector(d).select(from, to, k);
        } else {
            this.radixSelect(from, to, k, d, l);
        }
    }

    private void radixSelect(int from, int to, int k, int d, int l) {
        int[] histogram = this.histogram;
        Arrays.fill(histogram, 0);
        int commonPrefixLength = this.computeCommonPrefixLengthAndBuildHistogram(from, to, d, histogram);
        if (commonPrefixLength > 0) {
            if (d + commonPrefixLength < this.maxLength && histogram[0] < to - from) {
                this.radixSelect(from, to, k, d + commonPrefixLength, l);
            }
            return;
        }
        assert (this.assertHistogram(commonPrefixLength, histogram));
        int bucketFrom = from;
        for (int bucket = 0; bucket < 257; ++bucket) {
            int bucketTo = bucketFrom + histogram[bucket];
            if (bucketTo > k) {
                this.partition(from, to, bucket, bucketFrom, bucketTo, d);
                if (bucket != 0 && d + 1 < this.maxLength) {
                    this.select(bucketFrom, bucketTo, k, d + 1, l + 1);
                }
                return;
            }
            bucketFrom = bucketTo;
        }
        throw new AssertionError((Object)"Unreachable code");
    }

    private boolean assertHistogram(int commonPrefixLength, int[] histogram) {
        int numberOfUniqueBytes = 0;
        for (int freq : histogram) {
            if (freq <= 0) continue;
            ++numberOfUniqueBytes;
        }
        if (numberOfUniqueBytes == 1 ? !$assertionsDisabled && commonPrefixLength < 1 : !$assertionsDisabled && commonPrefixLength != 0) {
            throw new AssertionError();
        }
        return true;
    }

    private int getBucket(int i, int k) {
        return this.byteAt(i, k) + 1;
    }

    private int computeCommonPrefixLengthAndBuildHistogram(int from, int to, int k, int[] histogram) {
        int i;
        int[] commonPrefix = this.commonPrefix;
        int commonPrefixLength = Math.min(commonPrefix.length, this.maxLength - k);
        for (int j = 0; j < commonPrefixLength; ++j) {
            int b;
            commonPrefix[j] = b = this.byteAt(from, k + j);
            if (b != -1) continue;
            commonPrefixLength = j + 1;
            break;
        }
        block1: for (i = from + 1; i < to; ++i) {
            for (int j = 0; j < commonPrefixLength; ++j) {
                int b = this.byteAt(i, k + j);
                if (b == commonPrefix[j]) continue;
                commonPrefixLength = j;
                if (commonPrefixLength != 0) continue block1;
                histogram[commonPrefix[0] + 1] = i - from;
                histogram[b + 1] = 1;
                break block1;
            }
        }
        if (i < to) {
            assert (commonPrefixLength == 0);
            this.buildHistogram(i + 1, to, k, histogram);
        } else {
            assert (commonPrefixLength > 0);
            histogram[commonPrefix[0] + 1] = to - from;
        }
        return commonPrefixLength;
    }

    private void buildHistogram(int from, int to, int k, int[] histogram) {
        for (int i = from; i < to; ++i) {
            int n = this.getBucket(i, k);
            histogram[n] = histogram[n] + 1;
        }
    }

    private void partition(int from, int to, int bucket, int bucketFrom, int bucketTo, int d) {
        int left = from;
        int right = to - 1;
        int slot = bucketFrom;
        while (true) {
            int leftBucket = this.getBucket(left, d);
            int rightBucket = this.getBucket(right, d);
            while (leftBucket <= bucket && left < bucketFrom) {
                if (leftBucket == bucket) {
                    this.swap(left, slot++);
                } else {
                    ++left;
                }
                leftBucket = this.getBucket(left, d);
            }
            while (rightBucket >= bucket && right >= bucketTo) {
                if (rightBucket == bucket) {
                    this.swap(right, slot++);
                } else {
                    --right;
                }
                rightBucket = this.getBucket(right, d);
            }
            if (left >= bucketFrom || right < bucketTo) break;
            this.swap(left++, right--);
        }
        assert (left == bucketFrom);
        assert (right == bucketTo - 1);
    }
}

