/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.lookup.DocLookup;
import org.elasticsearch.search.lookup.FieldsLookup;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;

public class SearchLookup {
    private static final int MAX_FIELD_CHAIN_DEPTH = 5;
    private final Set<String> fieldChain;
    private final DocLookup docMap;
    private final SourceLookup sourceLookup;
    private final FieldsLookup fieldsLookup;
    private final BiFunction<MappedFieldType, Supplier<SearchLookup>, IndexFieldData<?>> fieldDataLookup;

    public SearchLookup(MapperService mapperService, BiFunction<MappedFieldType, Supplier<SearchLookup>, IndexFieldData<?>> fieldDataLookup, @Nullable String[] types) {
        this.fieldChain = Collections.emptySet();
        this.docMap = new DocLookup(mapperService, fieldType -> (IndexFieldData)fieldDataLookup.apply((MappedFieldType)fieldType, () -> this.forkAndTrackFieldReferences(fieldType.name())), types);
        this.sourceLookup = new SourceLookup();
        this.fieldsLookup = new FieldsLookup(mapperService, types);
        this.fieldDataLookup = fieldDataLookup;
    }

    private SearchLookup(SearchLookup searchLookup, Set<String> fieldChain) {
        this.fieldChain = Collections.unmodifiableSet(fieldChain);
        this.docMap = new DocLookup(searchLookup.docMap.mapperService(), fieldType -> searchLookup.fieldDataLookup.apply((MappedFieldType)fieldType, () -> this.forkAndTrackFieldReferences(fieldType.name())), searchLookup.docMap.getTypes());
        this.sourceLookup = searchLookup.sourceLookup;
        this.fieldsLookup = searchLookup.fieldsLookup;
        this.fieldDataLookup = searchLookup.fieldDataLookup;
    }

    public final SearchLookup forkAndTrackFieldReferences(String field) {
        Objects.requireNonNull(field, "field cannot be null");
        LinkedHashSet<String> newFieldChain = new LinkedHashSet<String>(this.fieldChain);
        if (!newFieldChain.add(field)) {
            String message = String.join((CharSequence)" -> ", newFieldChain) + " -> " + field;
            throw new IllegalArgumentException("Cyclic dependency detected while resolving runtime fields: " + message);
        }
        if (newFieldChain.size() > 5) {
            throw new IllegalArgumentException("Field requires resolving too many dependent fields: " + String.join((CharSequence)" -> ", newFieldChain));
        }
        return new SearchLookup(this, newFieldChain);
    }

    public LeafSearchLookup getLeafSearchLookup(LeafReaderContext context) {
        return new LeafSearchLookup(context, this.docMap.getLeafDocLookup(context), this.sourceLookup, this.fieldsLookup.getLeafFieldsLookup(context));
    }

    public DocLookup doc() {
        return this.docMap;
    }

    public SourceLookup source() {
        return this.sourceLookup;
    }
}

