/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.solr.client.solrj.io.eval.OneValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class SumSqEvaluator
extends RecursiveObjectEvaluator
implements OneValueWorker {
    private static final long serialVersionUID = 1L;

    public SumSqEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object value) throws IOException {
        if (null == value) {
            return value;
        }
        if (!(value instanceof List)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for value, expecting a List", this.toExpression(this.constructingFactory), value.getClass().getSimpleName()));
        }
        List list = (List)value;
        if (0 == list.size()) {
            return list;
        }
        double[] vec = new double[list.size()];
        for (int i = 0; i < vec.length; ++i) {
            vec[i] = ((Number)list.get(i)).doubleValue();
        }
        return StatUtils.sumSq((double[])vec);
    }
}

