/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerregistry.Argument;
import com.microsoft.azure.management.containerregistry.DockerBuildStepUpdateParameters;
import com.microsoft.azure.management.containerregistry.DockerTaskStep;
import com.microsoft.azure.management.containerregistry.OverridingArgument;
import com.microsoft.azure.management.containerregistry.RegistryDockerTaskStep;
import com.microsoft.azure.management.containerregistry.RegistryTask;
import com.microsoft.azure.management.containerregistry.implementation.RegistryTaskImpl;
import com.microsoft.azure.management.containerregistry.implementation.RegistryTaskStepImpl;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@LangDefinition
class RegistryDockerTaskStepImpl
extends RegistryTaskStepImpl
implements RegistryDockerTaskStep,
RegistryDockerTaskStep.Definition,
RegistryDockerTaskStep.Update,
HasInner<DockerTaskStep> {
    private DockerTaskStep inner = new DockerTaskStep();
    private DockerBuildStepUpdateParameters dockerTaskStepUpdateParameters;
    private RegistryTaskImpl taskImpl;

    RegistryDockerTaskStepImpl(RegistryTaskImpl taskImpl) {
        super(taskImpl.inner().step());
        if (taskImpl.inner().step() != null && !(taskImpl.inner().step() instanceof DockerTaskStep)) {
            throw new IllegalArgumentException("Constructor for RegistryDockerTaskStepImpl invoked for class that is not DockerTaskStep");
        }
        this.taskImpl = taskImpl;
        this.dockerTaskStepUpdateParameters = new DockerBuildStepUpdateParameters();
    }

    @Override
    public List<String> imageNames() {
        DockerTaskStep dockerTaskStep = (DockerTaskStep)this.taskImpl.inner().step();
        if (dockerTaskStep.imageNames() == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        return Collections.unmodifiableList(dockerTaskStep.imageNames());
    }

    @Override
    public boolean isPushEnabled() {
        DockerTaskStep dockerTaskStep = (DockerTaskStep)this.taskImpl.inner().step();
        return Utils.toPrimitiveBoolean((Boolean)dockerTaskStep.isPushEnabled());
    }

    @Override
    public boolean noCache() {
        DockerTaskStep dockerTaskStep = (DockerTaskStep)this.taskImpl.inner().step();
        return Utils.toPrimitiveBoolean((Boolean)dockerTaskStep.noCache());
    }

    @Override
    public String dockerFilePath() {
        DockerTaskStep dockerTaskStep = (DockerTaskStep)this.taskImpl.inner().step();
        return dockerTaskStep.dockerFilePath();
    }

    @Override
    public List<Argument> arguments() {
        DockerTaskStep dockerTaskStep = (DockerTaskStep)this.taskImpl.inner().step();
        if (dockerTaskStep.arguments() == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        return Collections.unmodifiableList(dockerTaskStep.arguments());
    }

    @Override
    public RegistryDockerTaskStepImpl withDockerFilePath(String path) {
        if (this.isInCreateMode()) {
            this.inner.withDockerFilePath(path);
        } else {
            this.dockerTaskStepUpdateParameters.withDockerFilePath(path);
        }
        return this;
    }

    @Override
    public RegistryDockerTaskStepImpl withImageNames(List<String> imageNames) {
        if (this.isInCreateMode()) {
            this.inner.withImageNames(imageNames);
        } else {
            this.dockerTaskStepUpdateParameters.withImageNames(imageNames);
        }
        return this;
    }

    @Override
    public RegistryDockerTaskStepImpl withPushEnabled(boolean enabled) {
        if (this.isInCreateMode()) {
            this.inner.withIsPushEnabled(enabled);
        } else {
            this.dockerTaskStepUpdateParameters.withIsPushEnabled(enabled);
        }
        return this;
    }

    @Override
    public RegistryDockerTaskStepImpl withCacheEnabled(boolean enabled) {
        if (this.isInCreateMode()) {
            this.inner.withNoCache(!enabled);
        } else {
            this.dockerTaskStepUpdateParameters.withNoCache(!enabled);
        }
        return this;
    }

    @Override
    public RegistryDockerTaskStepImpl withOverridingArguments(Map<String, OverridingArgument> overridingArguments) {
        if (overridingArguments.size() == 0) {
            return this;
        }
        ArrayList<Argument> overridingValuesList = new ArrayList<Argument>();
        for (Map.Entry<String, OverridingArgument> entry : overridingArguments.entrySet()) {
            Argument value = new Argument();
            value.withName(entry.getKey());
            value.withValue(entry.getValue().value());
            value.withIsSecret(entry.getValue().isSecret());
            overridingValuesList.add(value);
        }
        if (this.isInCreateMode()) {
            this.inner.withArguments(overridingValuesList);
        } else {
            this.dockerTaskStepUpdateParameters.withArguments(overridingValuesList);
        }
        return this;
    }

    @Override
    public RegistryDockerTaskStepImpl withOverridingArgument(String name, OverridingArgument overridingArgument) {
        if (this.inner.arguments() == null) {
            this.inner.withArguments(new ArrayList<Argument>());
        }
        Argument value = new Argument();
        value.withName(name);
        value.withValue(overridingArgument.value());
        value.withIsSecret(overridingArgument.isSecret());
        if (this.isInCreateMode()) {
            this.inner.arguments().add(value);
        } else {
            this.dockerTaskStepUpdateParameters.arguments().add(value);
        }
        return this;
    }

    public RegistryTask.DefinitionStages.SourceTriggerDefinition attach() {
        this.taskImpl.withDockerTaskStepCreateParameters(this.inner);
        return this.taskImpl;
    }

    public RegistryTask.Update parent() {
        this.taskImpl.withDockerTaskStepUpdateParameters(this.dockerTaskStepUpdateParameters);
        return this.taskImpl;
    }

    public DockerTaskStep inner() {
        return this.inner;
    }

    private boolean isInCreateMode() {
        return this.taskImpl.inner().id() == null;
    }
}

