/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.implementation.DatabaseVulnerabilityAssessmentInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class DatabaseVulnerabilityAssessmentsInner {
    private DatabaseVulnerabilityAssessmentsService service;
    private SqlManagementClientImpl client;

    public DatabaseVulnerabilityAssessmentsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (DatabaseVulnerabilityAssessmentsService)retrofit.create(DatabaseVulnerabilityAssessmentsService.class);
        this.client = client;
    }

    public DatabaseVulnerabilityAssessmentInner get(String resourceGroupName, String serverName, String databaseName) {
        return (DatabaseVulnerabilityAssessmentInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<DatabaseVulnerabilityAssessmentInner> getAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<DatabaseVulnerabilityAssessmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<DatabaseVulnerabilityAssessmentInner> getAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<DatabaseVulnerabilityAssessmentInner>, DatabaseVulnerabilityAssessmentInner>(){

            public DatabaseVulnerabilityAssessmentInner call(ServiceResponse<DatabaseVulnerabilityAssessmentInner> response) {
                return (DatabaseVulnerabilityAssessmentInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, serverName, databaseName, "default", this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>>>(){

            public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseVulnerabilityAssessmentsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseVulnerabilityAssessmentInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseVulnerabilityAssessmentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DatabaseVulnerabilityAssessmentInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, DatabaseVulnerabilityAssessmentInner parameters) {
        return (DatabaseVulnerabilityAssessmentInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<DatabaseVulnerabilityAssessmentInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, DatabaseVulnerabilityAssessmentInner parameters, ServiceCallback<DatabaseVulnerabilityAssessmentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters), serviceCallback);
    }

    public Observable<DatabaseVulnerabilityAssessmentInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, DatabaseVulnerabilityAssessmentInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, parameters).map((Func1)new Func1<ServiceResponse<DatabaseVulnerabilityAssessmentInner>, DatabaseVulnerabilityAssessmentInner>(){

            public DatabaseVulnerabilityAssessmentInner call(ServiceResponse<DatabaseVulnerabilityAssessmentInner> response) {
                return (DatabaseVulnerabilityAssessmentInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, DatabaseVulnerabilityAssessmentInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2017-03-01-preview";
        return this.service.createOrUpdate(resourceGroupName, serverName, databaseName, "default", this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>>>(){

            public Observable<ServiceResponse<DatabaseVulnerabilityAssessmentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseVulnerabilityAssessmentsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DatabaseVulnerabilityAssessmentInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DatabaseVulnerabilityAssessmentInner>(){}.getType()).register(201, new TypeToken<DatabaseVulnerabilityAssessmentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String serverName, String databaseName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String vulnerabilityAssessmentName = "default";
        String apiVersion = "2017-03-01-preview";
        return this.service.delete(resourceGroupName, serverName, databaseName, "default", this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = DatabaseVulnerabilityAssessmentsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface DatabaseVulnerabilityAssessmentsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessments get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="vulnerabilityAssessmentName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessments createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="vulnerabilityAssessmentName") String var4, @Path(value="subscriptionId") String var5, @Body DatabaseVulnerabilityAssessmentInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.DatabaseVulnerabilityAssessments delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="vulnerabilityAssessmentName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);
    }
}

