/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batchai.AzureBlobFileSystem;
import com.microsoft.azure.management.batchai.AzureBlobFileSystemReference;
import com.microsoft.azure.management.batchai.AzureStorageCredentialsInfo;
import com.microsoft.azure.management.batchai.KeyVaultSecretReference;
import com.microsoft.azure.management.batchai.model.HasMountVolumes;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableWrapperImpl;

@LangDefinition
class AzureBlobFileSystemImpl<ParentT>
extends IndexableWrapperImpl<AzureBlobFileSystemReference>
implements AzureBlobFileSystem,
AzureBlobFileSystem.Definition<ParentT> {
    private HasMountVolumes parent;

    AzureBlobFileSystemImpl(AzureBlobFileSystemReference inner, HasMountVolumes parent) {
        super((Object)inner);
        this.parent = parent;
    }

    @Override
    public AzureBlobFileSystem.Definition<ParentT> withStorageAccountName(String storageAccountName) {
        ((AzureBlobFileSystemReference)this.inner()).withAccountName(storageAccountName);
        return this;
    }

    @Override
    public AzureBlobFileSystem.Definition<ParentT> withRelativeMountPath(String mountPath) {
        ((AzureBlobFileSystemReference)this.inner()).withRelativeMountPath(mountPath);
        return this;
    }

    public ParentT attach() {
        this.parent.attachAzureBlobFileSystem(this);
        return (ParentT)this.parent;
    }

    public AzureBlobFileSystemImpl withAccountKey(String accountKey) {
        this.ensureCredentials().withAccountKey(accountKey);
        return this;
    }

    private AzureStorageCredentialsInfo ensureCredentials() {
        if (((AzureBlobFileSystemReference)this.inner()).credentials() == null) {
            ((AzureBlobFileSystemReference)this.inner()).withCredentials(new AzureStorageCredentialsInfo());
        }
        return ((AzureBlobFileSystemReference)this.inner()).credentials();
    }

    public AzureBlobFileSystemImpl withKeyVaultSecretReference(KeyVaultSecretReference keyVaultSecretReference) {
        this.ensureCredentials().withAccountKeySecretReference(keyVaultSecretReference);
        return this;
    }

    public AzureBlobFileSystemImpl withContainerName(String containerName) {
        ((AzureBlobFileSystemReference)this.inner()).withContainerName(containerName);
        return this;
    }

    public AzureBlobFileSystemImpl withMountOptions(String mountOptions) {
        ((AzureBlobFileSystemReference)this.inner()).withMountOptions(mountOptions);
        return this;
    }
}

