/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.dns.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.dns.CaaRecordSet;
import com.microsoft.azure.management.dns.CaaRecordSets;
import com.microsoft.azure.management.dns.RecordType;
import com.microsoft.azure.management.dns.implementation.CaaRecordSetImpl;
import com.microsoft.azure.management.dns.implementation.DnsManagementClientImpl;
import com.microsoft.azure.management.dns.implementation.DnsRecordSetsBaseImpl;
import com.microsoft.azure.management.dns.implementation.DnsZoneImpl;
import com.microsoft.azure.management.dns.implementation.DnsZoneManager;
import com.microsoft.azure.management.dns.implementation.RecordSetInner;
import rx.Observable;

@LangDefinition
class CaaRecordSetsImpl
extends DnsRecordSetsBaseImpl<CaaRecordSet, CaaRecordSetImpl>
implements CaaRecordSets {
    CaaRecordSetsImpl(DnsZoneImpl dnsZone) {
        super(dnsZone, RecordType.CAA);
    }

    public CaaRecordSetImpl getByName(String name) {
        RecordSetInner inner = ((DnsManagementClientImpl)((Object)((DnsZoneManager)this.parent().manager()).inner())).recordSets().get(this.dnsZone.resourceGroupName(), this.dnsZone.name(), name, this.recordType);
        if (inner == null) {
            return null;
        }
        return new CaaRecordSetImpl(inner.name(), this.dnsZone, inner);
    }

    @Override
    protected PagedList<CaaRecordSet> listIntern(String recordSetNameSuffix, Integer pageSize) {
        return super.wrapList(((DnsManagementClientImpl)((Object)((DnsZoneManager)this.parent().manager()).inner())).recordSets().listByType(this.dnsZone.resourceGroupName(), this.dnsZone.name(), this.recordType, pageSize, recordSetNameSuffix));
    }

    @Override
    protected Observable<CaaRecordSet> listInternAsync(String recordSetNameSuffix, Integer pageSize) {
        return this.wrapPageAsync(((DnsManagementClientImpl)((Object)((DnsZoneManager)this.parent().manager()).inner())).recordSets().listByTypeAsync(this.dnsZone.resourceGroupName(), this.dnsZone.name(), this.recordType));
    }

    protected CaaRecordSetImpl wrapModel(RecordSetInner inner) {
        if (inner == null) {
            return null;
        }
        return new CaaRecordSetImpl(inner.name(), this.dnsZone, inner);
    }
}

