/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.appservice.CheckNameResourceTypes;
import com.microsoft.azure.management.appservice.CsmMoveResourceEnvelope;
import com.microsoft.azure.management.appservice.DefaultErrorResponseException;
import com.microsoft.azure.management.appservice.ResourceNameAvailabilityRequest;
import com.microsoft.azure.management.appservice.SkuName;
import com.microsoft.azure.management.appservice.ValidateContainerSettingsRequest;
import com.microsoft.azure.management.appservice.ValidateRequest;
import com.microsoft.azure.management.appservice.VnetParameters;
import com.microsoft.azure.management.appservice.implementation.AppServiceCertificateOrdersInner;
import com.microsoft.azure.management.appservice.implementation.AppServiceEnvironmentsInner;
import com.microsoft.azure.management.appservice.implementation.AppServicePlansInner;
import com.microsoft.azure.management.appservice.implementation.BillingMeterInner;
import com.microsoft.azure.management.appservice.implementation.CertificateRegistrationProvidersInner;
import com.microsoft.azure.management.appservice.implementation.CertificatesInner;
import com.microsoft.azure.management.appservice.implementation.DeletedWebAppsInner;
import com.microsoft.azure.management.appservice.implementation.DeploymentLocationsInner;
import com.microsoft.azure.management.appservice.implementation.DiagnosticsInner;
import com.microsoft.azure.management.appservice.implementation.DomainRegistrationProvidersInner;
import com.microsoft.azure.management.appservice.implementation.DomainsInner;
import com.microsoft.azure.management.appservice.implementation.GeoRegionInner;
import com.microsoft.azure.management.appservice.implementation.IdentifierInner;
import com.microsoft.azure.management.appservice.implementation.NameIdentifierInner;
import com.microsoft.azure.management.appservice.implementation.PageImpl;
import com.microsoft.azure.management.appservice.implementation.PremierAddOnOfferInner;
import com.microsoft.azure.management.appservice.implementation.ProvidersInner;
import com.microsoft.azure.management.appservice.implementation.RecommendationsInner;
import com.microsoft.azure.management.appservice.implementation.ResourceHealthMetadatasInner;
import com.microsoft.azure.management.appservice.implementation.ResourceNameAvailabilityInner;
import com.microsoft.azure.management.appservice.implementation.SkuInfosInner;
import com.microsoft.azure.management.appservice.implementation.SourceControlInner;
import com.microsoft.azure.management.appservice.implementation.TopLevelDomainsInner;
import com.microsoft.azure.management.appservice.implementation.UserInner;
import com.microsoft.azure.management.appservice.implementation.ValidateResponseInner;
import com.microsoft.azure.management.appservice.implementation.VnetValidationFailureDetailsInner;
import com.microsoft.azure.management.appservice.implementation.WebAppsInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class WebSiteManagementClientImpl
extends AzureServiceClient {
    private WebSiteManagementClientService service;
    private AzureClient azureClient;
    private String subscriptionId;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private AppServiceCertificateOrdersInner appServiceCertificateOrders;
    private CertificateRegistrationProvidersInner certificateRegistrationProviders;
    private DomainsInner domains;
    private TopLevelDomainsInner topLevelDomains;
    private DomainRegistrationProvidersInner domainRegistrationProviders;
    private CertificatesInner certificates;
    private DeletedWebAppsInner deletedWebApps;
    private DiagnosticsInner diagnostics;
    private ProvidersInner providers;
    private RecommendationsInner recommendations;
    private WebAppsInner webApps;
    private AppServiceEnvironmentsInner appServiceEnvironments;
    private AppServicePlansInner appServicePlans;
    private ResourceHealthMetadatasInner resourceHealthMetadatas;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public WebSiteManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public WebSiteManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public WebSiteManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public WebSiteManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public AppServiceCertificateOrdersInner appServiceCertificateOrders() {
        return this.appServiceCertificateOrders;
    }

    public CertificateRegistrationProvidersInner certificateRegistrationProviders() {
        return this.certificateRegistrationProviders;
    }

    public DomainsInner domains() {
        return this.domains;
    }

    public TopLevelDomainsInner topLevelDomains() {
        return this.topLevelDomains;
    }

    public DomainRegistrationProvidersInner domainRegistrationProviders() {
        return this.domainRegistrationProviders;
    }

    public CertificatesInner certificates() {
        return this.certificates;
    }

    public DeletedWebAppsInner deletedWebApps() {
        return this.deletedWebApps;
    }

    public DiagnosticsInner diagnostics() {
        return this.diagnostics;
    }

    public ProvidersInner providers() {
        return this.providers;
    }

    public RecommendationsInner recommendations() {
        return this.recommendations;
    }

    public WebAppsInner webApps() {
        return this.webApps;
    }

    public AppServiceEnvironmentsInner appServiceEnvironments() {
        return this.appServiceEnvironments;
    }

    public AppServicePlansInner appServicePlans() {
        return this.appServicePlans;
    }

    public ResourceHealthMetadatasInner resourceHealthMetadatas() {
        return this.resourceHealthMetadatas;
    }

    public WebSiteManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public WebSiteManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public WebSiteManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2018-02-01";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.appServiceCertificateOrders = new AppServiceCertificateOrdersInner(this.restClient().retrofit(), this);
        this.certificateRegistrationProviders = new CertificateRegistrationProvidersInner(this.restClient().retrofit(), this);
        this.domains = new DomainsInner(this.restClient().retrofit(), this);
        this.topLevelDomains = new TopLevelDomainsInner(this.restClient().retrofit(), this);
        this.domainRegistrationProviders = new DomainRegistrationProvidersInner(this.restClient().retrofit(), this);
        this.certificates = new CertificatesInner(this.restClient().retrofit(), this);
        this.deletedWebApps = new DeletedWebAppsInner(this.restClient().retrofit(), this);
        this.diagnostics = new DiagnosticsInner(this.restClient().retrofit(), this);
        this.providers = new ProvidersInner(this.restClient().retrofit(), this);
        this.recommendations = new RecommendationsInner(this.restClient().retrofit(), this);
        this.webApps = new WebAppsInner(this.restClient().retrofit(), this);
        this.appServiceEnvironments = new AppServiceEnvironmentsInner(this.restClient().retrofit(), this);
        this.appServicePlans = new AppServicePlansInner(this.restClient().retrofit(), this);
        this.resourceHealthMetadatas = new ResourceHealthMetadatasInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
        this.initializeService();
    }

    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "WebSiteManagementClient", "2018-02-01");
    }

    private void initializeService() {
        this.service = (WebSiteManagementClientService)this.restClient().retrofit().create(WebSiteManagementClientService.class);
    }

    public UserInner getPublishingUser() {
        return (UserInner)((Object)((ServiceResponse)this.getPublishingUserWithServiceResponseAsync().toBlocking().single()).body());
    }

    public ServiceFuture<UserInner> getPublishingUserAsync(ServiceCallback<UserInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getPublishingUserWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<UserInner> getPublishingUserAsync() {
        return this.getPublishingUserWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<UserInner>, UserInner>(){

            public UserInner call(ServiceResponse<UserInner> response) {
                return (UserInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<UserInner>> getPublishingUserWithServiceResponseAsync() {
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return this.service.getPublishingUser(this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<UserInner>>>(){

            public Observable<ServiceResponse<UserInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebSiteManagementClientImpl.this.getPublishingUserDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<UserInner> getPublishingUserDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<UserInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public UserInner updatePublishingUser(UserInner userDetails) {
        return (UserInner)((Object)((ServiceResponse)this.updatePublishingUserWithServiceResponseAsync(userDetails).toBlocking().single()).body());
    }

    public ServiceFuture<UserInner> updatePublishingUserAsync(UserInner userDetails, ServiceCallback<UserInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updatePublishingUserWithServiceResponseAsync(userDetails), serviceCallback);
    }

    public Observable<UserInner> updatePublishingUserAsync(UserInner userDetails) {
        return this.updatePublishingUserWithServiceResponseAsync(userDetails).map((Func1)new Func1<ServiceResponse<UserInner>, UserInner>(){

            public UserInner call(ServiceResponse<UserInner> response) {
                return (UserInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<UserInner>> updatePublishingUserWithServiceResponseAsync(UserInner userDetails) {
        if (userDetails == null) {
            throw new IllegalArgumentException("Parameter userDetails is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)userDetails));
        return this.service.updatePublishingUser(userDetails, this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<UserInner>>>(){

            public Observable<ServiceResponse<UserInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebSiteManagementClientImpl.this.updatePublishingUserDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<UserInner> updatePublishingUserDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<UserInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<SourceControlInner> listSourceControls() {
        ServiceResponse response = (ServiceResponse)this.listSourceControlsSinglePageAsync().toBlocking().single();
        return new PagedList<SourceControlInner>((Page)response.body()){

            public Page<SourceControlInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebSiteManagementClientImpl.this.listSourceControlsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SourceControlInner>> listSourceControlsAsync(ListOperationCallback<SourceControlInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSourceControlsSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<SourceControlInner>>>>(){

            public Observable<ServiceResponse<Page<SourceControlInner>>> call(String nextPageLink) {
                return WebSiteManagementClientImpl.this.listSourceControlsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SourceControlInner>> listSourceControlsAsync() {
        return this.listSourceControlsWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<SourceControlInner>>, Page<SourceControlInner>>(){

            public Page<SourceControlInner> call(ServiceResponse<Page<SourceControlInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SourceControlInner>>> listSourceControlsWithServiceResponseAsync() {
        return this.listSourceControlsSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<SourceControlInner>>, Observable<ServiceResponse<Page<SourceControlInner>>>>(){

            public Observable<ServiceResponse<Page<SourceControlInner>>> call(ServiceResponse<Page<SourceControlInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebSiteManagementClientImpl.this.listSourceControlsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SourceControlInner>>> listSourceControlsSinglePageAsync() {
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return this.service.listSourceControls(this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SourceControlInner>>>>(){

            public Observable<ServiceResponse<Page<SourceControlInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebSiteManagementClientImpl.this.listSourceControlsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SourceControlInner>> listSourceControlsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<SourceControlInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public SourceControlInner getSourceControl(String sourceControlType) {
        return (SourceControlInner)((Object)((ServiceResponse)this.getSourceControlWithServiceResponseAsync(sourceControlType).toBlocking().single()).body());
    }

    public ServiceFuture<SourceControlInner> getSourceControlAsync(String sourceControlType, ServiceCallback<SourceControlInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSourceControlWithServiceResponseAsync(sourceControlType), serviceCallback);
    }

    public Observable<SourceControlInner> getSourceControlAsync(String sourceControlType) {
        return this.getSourceControlWithServiceResponseAsync(sourceControlType).map((Func1)new Func1<ServiceResponse<SourceControlInner>, SourceControlInner>(){

            public SourceControlInner call(ServiceResponse<SourceControlInner> response) {
                return (SourceControlInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SourceControlInner>> getSourceControlWithServiceResponseAsync(String sourceControlType) {
        if (sourceControlType == null) {
            throw new IllegalArgumentException("Parameter sourceControlType is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return this.service.getSourceControl(sourceControlType, this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SourceControlInner>>>(){

            public Observable<ServiceResponse<SourceControlInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebSiteManagementClientImpl.this.getSourceControlDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SourceControlInner> getSourceControlDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<SourceControlInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public SourceControlInner updateSourceControl(String sourceControlType, SourceControlInner requestMessage) {
        return (SourceControlInner)((Object)((ServiceResponse)this.updateSourceControlWithServiceResponseAsync(sourceControlType, requestMessage).toBlocking().single()).body());
    }

    public ServiceFuture<SourceControlInner> updateSourceControlAsync(String sourceControlType, SourceControlInner requestMessage, ServiceCallback<SourceControlInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateSourceControlWithServiceResponseAsync(sourceControlType, requestMessage), serviceCallback);
    }

    public Observable<SourceControlInner> updateSourceControlAsync(String sourceControlType, SourceControlInner requestMessage) {
        return this.updateSourceControlWithServiceResponseAsync(sourceControlType, requestMessage).map((Func1)new Func1<ServiceResponse<SourceControlInner>, SourceControlInner>(){

            public SourceControlInner call(ServiceResponse<SourceControlInner> response) {
                return (SourceControlInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SourceControlInner>> updateSourceControlWithServiceResponseAsync(String sourceControlType, SourceControlInner requestMessage) {
        if (sourceControlType == null) {
            throw new IllegalArgumentException("Parameter sourceControlType is required and cannot be null.");
        }
        if (requestMessage == null) {
            throw new IllegalArgumentException("Parameter requestMessage is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)requestMessage));
        return this.service.updateSourceControl(sourceControlType, requestMessage, this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SourceControlInner>>>(){

            public Observable<ServiceResponse<SourceControlInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebSiteManagementClientImpl.this.updateSourceControlDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SourceControlInner> updateSourceControlDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<SourceControlInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<BillingMeterInner> listBillingMeters() {
        ServiceResponse response = (ServiceResponse)this.listBillingMetersSinglePageAsync().toBlocking().single();
        return new PagedList<BillingMeterInner>((Page)response.body()){

            public Page<BillingMeterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebSiteManagementClientImpl.this.listBillingMetersNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BillingMeterInner>> listBillingMetersAsync(ListOperationCallback<BillingMeterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBillingMetersSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<BillingMeterInner>>>>(){

            public Observable<ServiceResponse<Page<BillingMeterInner>>> call(String nextPageLink) {
                return WebSiteManagementClientImpl.this.listBillingMetersNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BillingMeterInner>> listBillingMetersAsync() {
        return this.listBillingMetersWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<BillingMeterInner>>, Page<BillingMeterInner>>(){

            public Page<BillingMeterInner> call(ServiceResponse<Page<BillingMeterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BillingMeterInner>>> listBillingMetersWithServiceResponseAsync() {
        return this.listBillingMetersSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<BillingMeterInner>>, Observable<ServiceResponse<Page<BillingMeterInner>>>>(){

            public Observable<ServiceResponse<Page<BillingMeterInner>>> call(ServiceResponse<Page<BillingMeterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebSiteManagementClientImpl.this.listBillingMetersNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BillingMeterInner>>> listBillingMetersSinglePageAsync() {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String billingLocation = null;
        String osType = null;
        return this.service.listBillingMeters(this.subscriptionId(), billingLocation, osType, this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BillingMeterInner>>>>(){

            public Observable<ServiceResponse<Page<BillingMeterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebSiteManagementClientImpl.this.listBillingMetersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<BillingMeterInner> listBillingMeters(String billingLocation, String osType) {
        ServiceResponse response = (ServiceResponse)this.listBillingMetersSinglePageAsync(billingLocation, osType).toBlocking().single();
        return new PagedList<BillingMeterInner>((Page)response.body()){

            public Page<BillingMeterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebSiteManagementClientImpl.this.listBillingMetersNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BillingMeterInner>> listBillingMetersAsync(String billingLocation, String osType, ListOperationCallback<BillingMeterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBillingMetersSinglePageAsync(billingLocation, osType), (Func1)new Func1<String, Observable<ServiceResponse<Page<BillingMeterInner>>>>(){

            public Observable<ServiceResponse<Page<BillingMeterInner>>> call(String nextPageLink) {
                return WebSiteManagementClientImpl.this.listBillingMetersNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BillingMeterInner>> listBillingMetersAsync(String billingLocation, String osType) {
        return this.listBillingMetersWithServiceResponseAsync(billingLocation, osType).map((Func1)new Func1<ServiceResponse<Page<BillingMeterInner>>, Page<BillingMeterInner>>(){

            public Page<BillingMeterInner> call(ServiceResponse<Page<BillingMeterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BillingMeterInner>>> listBillingMetersWithServiceResponseAsync(String billingLocation, String osType) {
        return this.listBillingMetersSinglePageAsync(billingLocation, osType).concatMap((Func1)new Func1<ServiceResponse<Page<BillingMeterInner>>, Observable<ServiceResponse<Page<BillingMeterInner>>>>(){

            public Observable<ServiceResponse<Page<BillingMeterInner>>> call(ServiceResponse<Page<BillingMeterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebSiteManagementClientImpl.this.listBillingMetersNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BillingMeterInner>>> listBillingMetersSinglePageAsync(String billingLocation, String osType) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return this.service.listBillingMeters(this.subscriptionId(), billingLocation, osType, this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BillingMeterInner>>>>(){

            public Observable<ServiceResponse<Page<BillingMeterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebSiteManagementClientImpl.this.listBillingMetersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BillingMeterInner>> listBillingMetersDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<BillingMeterInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public ResourceNameAvailabilityInner checkNameAvailability(String name, CheckNameResourceTypes type) {
        return (ResourceNameAvailabilityInner)((ServiceResponse)this.checkNameAvailabilityWithServiceResponseAsync(name, type).toBlocking().single()).body();
    }

    public ServiceFuture<ResourceNameAvailabilityInner> checkNameAvailabilityAsync(String name, CheckNameResourceTypes type, ServiceCallback<ResourceNameAvailabilityInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameAvailabilityWithServiceResponseAsync(name, type), serviceCallback);
    }

    public Observable<ResourceNameAvailabilityInner> checkNameAvailabilityAsync(String name, CheckNameResourceTypes type) {
        return this.checkNameAvailabilityWithServiceResponseAsync(name, type).map((Func1)new Func1<ServiceResponse<ResourceNameAvailabilityInner>, ResourceNameAvailabilityInner>(){

            public ResourceNameAvailabilityInner call(ServiceResponse<ResourceNameAvailabilityInner> response) {
                return (ResourceNameAvailabilityInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ResourceNameAvailabilityInner>> checkNameAvailabilityWithServiceResponseAsync(String name, CheckNameResourceTypes type) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Parameter type is required and cannot be null.");
        }
        Object isFqdn = null;
        ResourceNameAvailabilityRequest request = new ResourceNameAvailabilityRequest();
        request.withName(name);
        request.withType(type);
        request.withIsFqdn(null);
        return this.service.checkNameAvailability(this.subscriptionId(), this.apiVersion(), this.acceptLanguage(), request, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceNameAvailabilityInner>>>(){

            public Observable<ServiceResponse<ResourceNameAvailabilityInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebSiteManagementClientImpl.this.checkNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ResourceNameAvailabilityInner checkNameAvailability(String name, CheckNameResourceTypes type, Boolean isFqdn) {
        return (ResourceNameAvailabilityInner)((ServiceResponse)this.checkNameAvailabilityWithServiceResponseAsync(name, type, isFqdn).toBlocking().single()).body();
    }

    public ServiceFuture<ResourceNameAvailabilityInner> checkNameAvailabilityAsync(String name, CheckNameResourceTypes type, Boolean isFqdn, ServiceCallback<ResourceNameAvailabilityInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameAvailabilityWithServiceResponseAsync(name, type, isFqdn), serviceCallback);
    }

    public Observable<ResourceNameAvailabilityInner> checkNameAvailabilityAsync(String name, CheckNameResourceTypes type, Boolean isFqdn) {
        return this.checkNameAvailabilityWithServiceResponseAsync(name, type, isFqdn).map((Func1)new Func1<ServiceResponse<ResourceNameAvailabilityInner>, ResourceNameAvailabilityInner>(){

            public ResourceNameAvailabilityInner call(ServiceResponse<ResourceNameAvailabilityInner> response) {
                return (ResourceNameAvailabilityInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ResourceNameAvailabilityInner>> checkNameAvailabilityWithServiceResponseAsync(String name, CheckNameResourceTypes type, Boolean isFqdn) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Parameter type is required and cannot be null.");
        }
        ResourceNameAvailabilityRequest request = new ResourceNameAvailabilityRequest();
        request.withName(name);
        request.withType(type);
        request.withIsFqdn(isFqdn);
        return this.service.checkNameAvailability(this.subscriptionId(), this.apiVersion(), this.acceptLanguage(), request, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceNameAvailabilityInner>>>(){

            public Observable<ServiceResponse<ResourceNameAvailabilityInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebSiteManagementClientImpl.this.checkNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ResourceNameAvailabilityInner> checkNameAvailabilityDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<ResourceNameAvailabilityInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public DeploymentLocationsInner getSubscriptionDeploymentLocations() {
        return (DeploymentLocationsInner)((ServiceResponse)this.getSubscriptionDeploymentLocationsWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<DeploymentLocationsInner> getSubscriptionDeploymentLocationsAsync(ServiceCallback<DeploymentLocationsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSubscriptionDeploymentLocationsWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<DeploymentLocationsInner> getSubscriptionDeploymentLocationsAsync() {
        return this.getSubscriptionDeploymentLocationsWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<DeploymentLocationsInner>, DeploymentLocationsInner>(){

            public DeploymentLocationsInner call(ServiceResponse<DeploymentLocationsInner> response) {
                return (DeploymentLocationsInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeploymentLocationsInner>> getSubscriptionDeploymentLocationsWithServiceResponseAsync() {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return this.service.getSubscriptionDeploymentLocations(this.subscriptionId(), this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeploymentLocationsInner>>>(){

            public Observable<ServiceResponse<DeploymentLocationsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebSiteManagementClientImpl.this.getSubscriptionDeploymentLocationsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeploymentLocationsInner> getSubscriptionDeploymentLocationsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<DeploymentLocationsInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<GeoRegionInner> listGeoRegions() {
        ServiceResponse response = (ServiceResponse)this.listGeoRegionsSinglePageAsync().toBlocking().single();
        return new PagedList<GeoRegionInner>((Page)response.body()){

            public Page<GeoRegionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebSiteManagementClientImpl.this.listGeoRegionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<GeoRegionInner>> listGeoRegionsAsync(ListOperationCallback<GeoRegionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listGeoRegionsSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<GeoRegionInner>>>>(){

            public Observable<ServiceResponse<Page<GeoRegionInner>>> call(String nextPageLink) {
                return WebSiteManagementClientImpl.this.listGeoRegionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<GeoRegionInner>> listGeoRegionsAsync() {
        return this.listGeoRegionsWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<GeoRegionInner>>, Page<GeoRegionInner>>(){

            public Page<GeoRegionInner> call(ServiceResponse<Page<GeoRegionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<GeoRegionInner>>> listGeoRegionsWithServiceResponseAsync() {
        return this.listGeoRegionsSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<GeoRegionInner>>, Observable<ServiceResponse<Page<GeoRegionInner>>>>(){

            public Observable<ServiceResponse<Page<GeoRegionInner>>> call(ServiceResponse<Page<GeoRegionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebSiteManagementClientImpl.this.listGeoRegionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GeoRegionInner>>> listGeoRegionsSinglePageAsync() {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        SkuName sku = null;
        Boolean linuxWorkersEnabled = null;
        Boolean xenonWorkersEnabled = null;
        Boolean linuxDynamicWorkersEnabled = null;
        return this.service.listGeoRegions(this.subscriptionId(), sku, linuxWorkersEnabled, xenonWorkersEnabled, linuxDynamicWorkersEnabled, this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GeoRegionInner>>>>(){

            public Observable<ServiceResponse<Page<GeoRegionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebSiteManagementClientImpl.this.listGeoRegionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<GeoRegionInner> listGeoRegions(SkuName sku, Boolean linuxWorkersEnabled, Boolean xenonWorkersEnabled, Boolean linuxDynamicWorkersEnabled) {
        ServiceResponse response = (ServiceResponse)this.listGeoRegionsSinglePageAsync(sku, linuxWorkersEnabled, xenonWorkersEnabled, linuxDynamicWorkersEnabled).toBlocking().single();
        return new PagedList<GeoRegionInner>((Page)response.body()){

            public Page<GeoRegionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebSiteManagementClientImpl.this.listGeoRegionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<GeoRegionInner>> listGeoRegionsAsync(SkuName sku, Boolean linuxWorkersEnabled, Boolean xenonWorkersEnabled, Boolean linuxDynamicWorkersEnabled, ListOperationCallback<GeoRegionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listGeoRegionsSinglePageAsync(sku, linuxWorkersEnabled, xenonWorkersEnabled, linuxDynamicWorkersEnabled), (Func1)new Func1<String, Observable<ServiceResponse<Page<GeoRegionInner>>>>(){

            public Observable<ServiceResponse<Page<GeoRegionInner>>> call(String nextPageLink) {
                return WebSiteManagementClientImpl.this.listGeoRegionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<GeoRegionInner>> listGeoRegionsAsync(SkuName sku, Boolean linuxWorkersEnabled, Boolean xenonWorkersEnabled, Boolean linuxDynamicWorkersEnabled) {
        return this.listGeoRegionsWithServiceResponseAsync(sku, linuxWorkersEnabled, xenonWorkersEnabled, linuxDynamicWorkersEnabled).map((Func1)new Func1<ServiceResponse<Page<GeoRegionInner>>, Page<GeoRegionInner>>(){

            public Page<GeoRegionInner> call(ServiceResponse<Page<GeoRegionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<GeoRegionInner>>> listGeoRegionsWithServiceResponseAsync(SkuName sku, Boolean linuxWorkersEnabled, Boolean xenonWorkersEnabled, Boolean linuxDynamicWorkersEnabled) {
        return this.listGeoRegionsSinglePageAsync(sku, linuxWorkersEnabled, xenonWorkersEnabled, linuxDynamicWorkersEnabled).concatMap((Func1)new Func1<ServiceResponse<Page<GeoRegionInner>>, Observable<ServiceResponse<Page<GeoRegionInner>>>>(){

            public Observable<ServiceResponse<Page<GeoRegionInner>>> call(ServiceResponse<Page<GeoRegionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebSiteManagementClientImpl.this.listGeoRegionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GeoRegionInner>>> listGeoRegionsSinglePageAsync(SkuName sku, Boolean linuxWorkersEnabled, Boolean xenonWorkersEnabled, Boolean linuxDynamicWorkersEnabled) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return this.service.listGeoRegions(this.subscriptionId(), sku, linuxWorkersEnabled, xenonWorkersEnabled, linuxDynamicWorkersEnabled, this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GeoRegionInner>>>>(){

            public Observable<ServiceResponse<Page<GeoRegionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebSiteManagementClientImpl.this.listGeoRegionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<GeoRegionInner>> listGeoRegionsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<GeoRegionInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<IdentifierInner> listSiteIdentifiersAssignedToHostName() {
        ServiceResponse response = (ServiceResponse)this.listSiteIdentifiersAssignedToHostNameSinglePageAsync().toBlocking().single();
        return new PagedList<IdentifierInner>((Page)response.body()){

            public Page<IdentifierInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebSiteManagementClientImpl.this.listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<IdentifierInner>> listSiteIdentifiersAssignedToHostNameAsync(ListOperationCallback<IdentifierInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSiteIdentifiersAssignedToHostNameSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<IdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<IdentifierInner>>> call(String nextPageLink) {
                return WebSiteManagementClientImpl.this.listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<IdentifierInner>> listSiteIdentifiersAssignedToHostNameAsync() {
        return this.listSiteIdentifiersAssignedToHostNameWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<IdentifierInner>>, Page<IdentifierInner>>(){

            public Page<IdentifierInner> call(ServiceResponse<Page<IdentifierInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<IdentifierInner>>> listSiteIdentifiersAssignedToHostNameWithServiceResponseAsync() {
        return this.listSiteIdentifiersAssignedToHostNameSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<IdentifierInner>>, Observable<ServiceResponse<Page<IdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<IdentifierInner>>> call(ServiceResponse<Page<IdentifierInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebSiteManagementClientImpl.this.listSiteIdentifiersAssignedToHostNameNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<IdentifierInner>>> listSiteIdentifiersAssignedToHostNameSinglePageAsync() {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Object name = null;
        NameIdentifierInner nameIdentifier = new NameIdentifierInner();
        nameIdentifier.withName(null);
        return this.service.listSiteIdentifiersAssignedToHostName(this.subscriptionId(), this.apiVersion(), this.acceptLanguage(), nameIdentifier, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<IdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<IdentifierInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebSiteManagementClientImpl.this.listSiteIdentifiersAssignedToHostNameDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<IdentifierInner> listSiteIdentifiersAssignedToHostName(String name) {
        ServiceResponse response = (ServiceResponse)this.listSiteIdentifiersAssignedToHostNameSinglePageAsync(name).toBlocking().single();
        return new PagedList<IdentifierInner>((Page)response.body()){

            public Page<IdentifierInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebSiteManagementClientImpl.this.listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<IdentifierInner>> listSiteIdentifiersAssignedToHostNameAsync(String name, ListOperationCallback<IdentifierInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSiteIdentifiersAssignedToHostNameSinglePageAsync(name), (Func1)new Func1<String, Observable<ServiceResponse<Page<IdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<IdentifierInner>>> call(String nextPageLink) {
                return WebSiteManagementClientImpl.this.listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<IdentifierInner>> listSiteIdentifiersAssignedToHostNameAsync(String name) {
        return this.listSiteIdentifiersAssignedToHostNameWithServiceResponseAsync(name).map((Func1)new Func1<ServiceResponse<Page<IdentifierInner>>, Page<IdentifierInner>>(){

            public Page<IdentifierInner> call(ServiceResponse<Page<IdentifierInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<IdentifierInner>>> listSiteIdentifiersAssignedToHostNameWithServiceResponseAsync(String name) {
        return this.listSiteIdentifiersAssignedToHostNameSinglePageAsync(name).concatMap((Func1)new Func1<ServiceResponse<Page<IdentifierInner>>, Observable<ServiceResponse<Page<IdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<IdentifierInner>>> call(ServiceResponse<Page<IdentifierInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebSiteManagementClientImpl.this.listSiteIdentifiersAssignedToHostNameNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<IdentifierInner>>> listSiteIdentifiersAssignedToHostNameSinglePageAsync(String name) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        NameIdentifierInner nameIdentifier = new NameIdentifierInner();
        nameIdentifier.withName(name);
        return this.service.listSiteIdentifiersAssignedToHostName(this.subscriptionId(), this.apiVersion(), this.acceptLanguage(), nameIdentifier, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<IdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<IdentifierInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebSiteManagementClientImpl.this.listSiteIdentifiersAssignedToHostNameDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<IdentifierInner>> listSiteIdentifiersAssignedToHostNameDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<IdentifierInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<PremierAddOnOfferInner> listPremierAddOnOffers() {
        ServiceResponse response = (ServiceResponse)this.listPremierAddOnOffersSinglePageAsync().toBlocking().single();
        return new PagedList<PremierAddOnOfferInner>((Page)response.body()){

            public Page<PremierAddOnOfferInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebSiteManagementClientImpl.this.listPremierAddOnOffersNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PremierAddOnOfferInner>> listPremierAddOnOffersAsync(ListOperationCallback<PremierAddOnOfferInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listPremierAddOnOffersSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<PremierAddOnOfferInner>>>>(){

            public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> call(String nextPageLink) {
                return WebSiteManagementClientImpl.this.listPremierAddOnOffersNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PremierAddOnOfferInner>> listPremierAddOnOffersAsync() {
        return this.listPremierAddOnOffersWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<PremierAddOnOfferInner>>, Page<PremierAddOnOfferInner>>(){

            public Page<PremierAddOnOfferInner> call(ServiceResponse<Page<PremierAddOnOfferInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> listPremierAddOnOffersWithServiceResponseAsync() {
        return this.listPremierAddOnOffersSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<PremierAddOnOfferInner>>, Observable<ServiceResponse<Page<PremierAddOnOfferInner>>>>(){

            public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> call(ServiceResponse<Page<PremierAddOnOfferInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebSiteManagementClientImpl.this.listPremierAddOnOffersNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> listPremierAddOnOffersSinglePageAsync() {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return this.service.listPremierAddOnOffers(this.subscriptionId(), this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PremierAddOnOfferInner>>>>(){

            public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebSiteManagementClientImpl.this.listPremierAddOnOffersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PremierAddOnOfferInner>> listPremierAddOnOffersDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<PremierAddOnOfferInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public SkuInfosInner listSkus() {
        return (SkuInfosInner)((ServiceResponse)this.listSkusWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<SkuInfosInner> listSkusAsync(ServiceCallback<SkuInfosInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listSkusWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<SkuInfosInner> listSkusAsync() {
        return this.listSkusWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<SkuInfosInner>, SkuInfosInner>(){

            public SkuInfosInner call(ServiceResponse<SkuInfosInner> response) {
                return (SkuInfosInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<SkuInfosInner>> listSkusWithServiceResponseAsync() {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return this.service.listSkus(this.subscriptionId(), this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SkuInfosInner>>>(){

            public Observable<ServiceResponse<SkuInfosInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebSiteManagementClientImpl.this.listSkusDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SkuInfosInner> listSkusDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<SkuInfosInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public VnetValidationFailureDetailsInner verifyHostingEnvironmentVnet(VnetParameters parameters) {
        return (VnetValidationFailureDetailsInner)((Object)((ServiceResponse)this.verifyHostingEnvironmentVnetWithServiceResponseAsync(parameters).toBlocking().single()).body());
    }

    public ServiceFuture<VnetValidationFailureDetailsInner> verifyHostingEnvironmentVnetAsync(VnetParameters parameters, ServiceCallback<VnetValidationFailureDetailsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.verifyHostingEnvironmentVnetWithServiceResponseAsync(parameters), serviceCallback);
    }

    public Observable<VnetValidationFailureDetailsInner> verifyHostingEnvironmentVnetAsync(VnetParameters parameters) {
        return this.verifyHostingEnvironmentVnetWithServiceResponseAsync(parameters).map((Func1)new Func1<ServiceResponse<VnetValidationFailureDetailsInner>, VnetValidationFailureDetailsInner>(){

            public VnetValidationFailureDetailsInner call(ServiceResponse<VnetValidationFailureDetailsInner> response) {
                return (VnetValidationFailureDetailsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VnetValidationFailureDetailsInner>> verifyHostingEnvironmentVnetWithServiceResponseAsync(VnetParameters parameters) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.verifyHostingEnvironmentVnet(this.subscriptionId(), parameters, this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VnetValidationFailureDetailsInner>>>(){

            public Observable<ServiceResponse<VnetValidationFailureDetailsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebSiteManagementClientImpl.this.verifyHostingEnvironmentVnetDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VnetValidationFailureDetailsInner> verifyHostingEnvironmentVnetDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<VnetValidationFailureDetailsInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public void move(String resourceGroupName, CsmMoveResourceEnvelope moveResourceEnvelope) {
        ((ServiceResponse)this.moveWithServiceResponseAsync(resourceGroupName, moveResourceEnvelope).toBlocking().single()).body();
    }

    public ServiceFuture<Void> moveAsync(String resourceGroupName, CsmMoveResourceEnvelope moveResourceEnvelope, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.moveWithServiceResponseAsync(resourceGroupName, moveResourceEnvelope), serviceCallback);
    }

    public Observable<Void> moveAsync(String resourceGroupName, CsmMoveResourceEnvelope moveResourceEnvelope) {
        return this.moveWithServiceResponseAsync(resourceGroupName, moveResourceEnvelope).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> moveWithServiceResponseAsync(String resourceGroupName, CsmMoveResourceEnvelope moveResourceEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (moveResourceEnvelope == null) {
            throw new IllegalArgumentException("Parameter moveResourceEnvelope is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)moveResourceEnvelope);
        return this.service.move(resourceGroupName, this.subscriptionId(), moveResourceEnvelope, this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebSiteManagementClientImpl.this.moveDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> moveDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ValidateResponseInner validate(String resourceGroupName, ValidateRequest validateRequest) {
        return (ValidateResponseInner)((ServiceResponse)this.validateWithServiceResponseAsync(resourceGroupName, validateRequest).toBlocking().single()).body();
    }

    public ServiceFuture<ValidateResponseInner> validateAsync(String resourceGroupName, ValidateRequest validateRequest, ServiceCallback<ValidateResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.validateWithServiceResponseAsync(resourceGroupName, validateRequest), serviceCallback);
    }

    public Observable<ValidateResponseInner> validateAsync(String resourceGroupName, ValidateRequest validateRequest) {
        return this.validateWithServiceResponseAsync(resourceGroupName, validateRequest).map((Func1)new Func1<ServiceResponse<ValidateResponseInner>, ValidateResponseInner>(){

            public ValidateResponseInner call(ServiceResponse<ValidateResponseInner> response) {
                return (ValidateResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ValidateResponseInner>> validateWithServiceResponseAsync(String resourceGroupName, ValidateRequest validateRequest) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (validateRequest == null) {
            throw new IllegalArgumentException("Parameter validateRequest is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)validateRequest);
        return this.service.validate(resourceGroupName, this.subscriptionId(), validateRequest, this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ValidateResponseInner>>>(){

            public Observable<ServiceResponse<ValidateResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebSiteManagementClientImpl.this.validateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ValidateResponseInner> validateDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<ValidateResponseInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public Object validateContainerSettings(String resourceGroupName, ValidateContainerSettingsRequest validateContainerSettingsRequest) {
        return ((ServiceResponse)this.validateContainerSettingsWithServiceResponseAsync(resourceGroupName, validateContainerSettingsRequest).toBlocking().single()).body();
    }

    public ServiceFuture<Object> validateContainerSettingsAsync(String resourceGroupName, ValidateContainerSettingsRequest validateContainerSettingsRequest, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.validateContainerSettingsWithServiceResponseAsync(resourceGroupName, validateContainerSettingsRequest), serviceCallback);
    }

    public Observable<Object> validateContainerSettingsAsync(String resourceGroupName, ValidateContainerSettingsRequest validateContainerSettingsRequest) {
        return this.validateContainerSettingsWithServiceResponseAsync(resourceGroupName, validateContainerSettingsRequest).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    public Observable<ServiceResponse<Object>> validateContainerSettingsWithServiceResponseAsync(String resourceGroupName, ValidateContainerSettingsRequest validateContainerSettingsRequest) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (validateContainerSettingsRequest == null) {
            throw new IllegalArgumentException("Parameter validateContainerSettingsRequest is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)validateContainerSettingsRequest);
        return this.service.validateContainerSettings(resourceGroupName, this.subscriptionId(), validateContainerSettingsRequest, this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebSiteManagementClientImpl.this.validateContainerSettingsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> validateContainerSettingsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<Object>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public void validateMove(String resourceGroupName, CsmMoveResourceEnvelope moveResourceEnvelope) {
        ((ServiceResponse)this.validateMoveWithServiceResponseAsync(resourceGroupName, moveResourceEnvelope).toBlocking().single()).body();
    }

    public ServiceFuture<Void> validateMoveAsync(String resourceGroupName, CsmMoveResourceEnvelope moveResourceEnvelope, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.validateMoveWithServiceResponseAsync(resourceGroupName, moveResourceEnvelope), serviceCallback);
    }

    public Observable<Void> validateMoveAsync(String resourceGroupName, CsmMoveResourceEnvelope moveResourceEnvelope) {
        return this.validateMoveWithServiceResponseAsync(resourceGroupName, moveResourceEnvelope).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> validateMoveWithServiceResponseAsync(String resourceGroupName, CsmMoveResourceEnvelope moveResourceEnvelope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (moveResourceEnvelope == null) {
            throw new IllegalArgumentException("Parameter moveResourceEnvelope is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)moveResourceEnvelope);
        return this.service.validateMove(resourceGroupName, this.subscriptionId(), moveResourceEnvelope, this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WebSiteManagementClientImpl.this.validateMoveDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> validateMoveDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SourceControlInner> listSourceControlsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listSourceControlsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SourceControlInner>((Page)response.body()){

            public Page<SourceControlInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebSiteManagementClientImpl.this.listSourceControlsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SourceControlInner>> listSourceControlsNextAsync(String nextPageLink, ServiceFuture<List<SourceControlInner>> serviceFuture, ListOperationCallback<SourceControlInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSourceControlsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SourceControlInner>>>>(){

            public Observable<ServiceResponse<Page<SourceControlInner>>> call(String nextPageLink) {
                return WebSiteManagementClientImpl.this.listSourceControlsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SourceControlInner>> listSourceControlsNextAsync(String nextPageLink) {
        return this.listSourceControlsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SourceControlInner>>, Page<SourceControlInner>>(){

            public Page<SourceControlInner> call(ServiceResponse<Page<SourceControlInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SourceControlInner>>> listSourceControlsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listSourceControlsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SourceControlInner>>, Observable<ServiceResponse<Page<SourceControlInner>>>>(){

            public Observable<ServiceResponse<Page<SourceControlInner>>> call(ServiceResponse<Page<SourceControlInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebSiteManagementClientImpl.this.listSourceControlsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SourceControlInner>>> listSourceControlsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listSourceControlsNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SourceControlInner>>>>(){

            public Observable<ServiceResponse<Page<SourceControlInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebSiteManagementClientImpl.this.listSourceControlsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SourceControlInner>> listSourceControlsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<SourceControlInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<BillingMeterInner> listBillingMetersNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listBillingMetersNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BillingMeterInner>((Page)response.body()){

            public Page<BillingMeterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebSiteManagementClientImpl.this.listBillingMetersNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BillingMeterInner>> listBillingMetersNextAsync(String nextPageLink, ServiceFuture<List<BillingMeterInner>> serviceFuture, ListOperationCallback<BillingMeterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listBillingMetersNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<BillingMeterInner>>>>(){

            public Observable<ServiceResponse<Page<BillingMeterInner>>> call(String nextPageLink) {
                return WebSiteManagementClientImpl.this.listBillingMetersNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BillingMeterInner>> listBillingMetersNextAsync(String nextPageLink) {
        return this.listBillingMetersNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<BillingMeterInner>>, Page<BillingMeterInner>>(){

            public Page<BillingMeterInner> call(ServiceResponse<Page<BillingMeterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BillingMeterInner>>> listBillingMetersNextWithServiceResponseAsync(String nextPageLink) {
        return this.listBillingMetersNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<BillingMeterInner>>, Observable<ServiceResponse<Page<BillingMeterInner>>>>(){

            public Observable<ServiceResponse<Page<BillingMeterInner>>> call(ServiceResponse<Page<BillingMeterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebSiteManagementClientImpl.this.listBillingMetersNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BillingMeterInner>>> listBillingMetersNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listBillingMetersNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BillingMeterInner>>>>(){

            public Observable<ServiceResponse<Page<BillingMeterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebSiteManagementClientImpl.this.listBillingMetersNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BillingMeterInner>> listBillingMetersNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<BillingMeterInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<GeoRegionInner> listGeoRegionsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listGeoRegionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<GeoRegionInner>((Page)response.body()){

            public Page<GeoRegionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebSiteManagementClientImpl.this.listGeoRegionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<GeoRegionInner>> listGeoRegionsNextAsync(String nextPageLink, ServiceFuture<List<GeoRegionInner>> serviceFuture, ListOperationCallback<GeoRegionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listGeoRegionsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<GeoRegionInner>>>>(){

            public Observable<ServiceResponse<Page<GeoRegionInner>>> call(String nextPageLink) {
                return WebSiteManagementClientImpl.this.listGeoRegionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<GeoRegionInner>> listGeoRegionsNextAsync(String nextPageLink) {
        return this.listGeoRegionsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<GeoRegionInner>>, Page<GeoRegionInner>>(){

            public Page<GeoRegionInner> call(ServiceResponse<Page<GeoRegionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<GeoRegionInner>>> listGeoRegionsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listGeoRegionsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<GeoRegionInner>>, Observable<ServiceResponse<Page<GeoRegionInner>>>>(){

            public Observable<ServiceResponse<Page<GeoRegionInner>>> call(ServiceResponse<Page<GeoRegionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebSiteManagementClientImpl.this.listGeoRegionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GeoRegionInner>>> listGeoRegionsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listGeoRegionsNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GeoRegionInner>>>>(){

            public Observable<ServiceResponse<Page<GeoRegionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebSiteManagementClientImpl.this.listGeoRegionsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<GeoRegionInner>> listGeoRegionsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<GeoRegionInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<IdentifierInner> listSiteIdentifiersAssignedToHostNameNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<IdentifierInner>((Page)response.body()){

            public Page<IdentifierInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebSiteManagementClientImpl.this.listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<IdentifierInner>> listSiteIdentifiersAssignedToHostNameNextAsync(String nextPageLink, ServiceFuture<List<IdentifierInner>> serviceFuture, ListOperationCallback<IdentifierInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<IdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<IdentifierInner>>> call(String nextPageLink) {
                return WebSiteManagementClientImpl.this.listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<IdentifierInner>> listSiteIdentifiersAssignedToHostNameNextAsync(String nextPageLink) {
        return this.listSiteIdentifiersAssignedToHostNameNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<IdentifierInner>>, Page<IdentifierInner>>(){

            public Page<IdentifierInner> call(ServiceResponse<Page<IdentifierInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<IdentifierInner>>> listSiteIdentifiersAssignedToHostNameNextWithServiceResponseAsync(String nextPageLink) {
        return this.listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<IdentifierInner>>, Observable<ServiceResponse<Page<IdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<IdentifierInner>>> call(ServiceResponse<Page<IdentifierInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebSiteManagementClientImpl.this.listSiteIdentifiersAssignedToHostNameNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<IdentifierInner>>> listSiteIdentifiersAssignedToHostNameNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listSiteIdentifiersAssignedToHostNameNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<IdentifierInner>>>>(){

            public Observable<ServiceResponse<Page<IdentifierInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebSiteManagementClientImpl.this.listSiteIdentifiersAssignedToHostNameNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<IdentifierInner>> listSiteIdentifiersAssignedToHostNameNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<IdentifierInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<PremierAddOnOfferInner> listPremierAddOnOffersNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listPremierAddOnOffersNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PremierAddOnOfferInner>((Page)response.body()){

            public Page<PremierAddOnOfferInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WebSiteManagementClientImpl.this.listPremierAddOnOffersNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PremierAddOnOfferInner>> listPremierAddOnOffersNextAsync(String nextPageLink, ServiceFuture<List<PremierAddOnOfferInner>> serviceFuture, ListOperationCallback<PremierAddOnOfferInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listPremierAddOnOffersNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PremierAddOnOfferInner>>>>(){

            public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> call(String nextPageLink) {
                return WebSiteManagementClientImpl.this.listPremierAddOnOffersNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PremierAddOnOfferInner>> listPremierAddOnOffersNextAsync(String nextPageLink) {
        return this.listPremierAddOnOffersNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PremierAddOnOfferInner>>, Page<PremierAddOnOfferInner>>(){

            public Page<PremierAddOnOfferInner> call(ServiceResponse<Page<PremierAddOnOfferInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> listPremierAddOnOffersNextWithServiceResponseAsync(String nextPageLink) {
        return this.listPremierAddOnOffersNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PremierAddOnOfferInner>>, Observable<ServiceResponse<Page<PremierAddOnOfferInner>>>>(){

            public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> call(ServiceResponse<Page<PremierAddOnOfferInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WebSiteManagementClientImpl.this.listPremierAddOnOffersNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> listPremierAddOnOffersNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listPremierAddOnOffersNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PremierAddOnOfferInner>>>>(){

            public Observable<ServiceResponse<Page<PremierAddOnOfferInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WebSiteManagementClientImpl.this.listPremierAddOnOffersNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PremierAddOnOfferInner>> listPremierAddOnOffersNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<PremierAddOnOfferInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    static interface WebSiteManagementClientService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient getPublishingUser"})
        @GET(value="providers/Microsoft.Web/publishingUsers/web")
        public Observable<Response<ResponseBody>> getPublishingUser(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient updatePublishingUser"})
        @PUT(value="providers/Microsoft.Web/publishingUsers/web")
        public Observable<Response<ResponseBody>> updatePublishingUser(@Body UserInner var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listSourceControls"})
        @GET(value="providers/Microsoft.Web/sourcecontrols")
        public Observable<Response<ResponseBody>> listSourceControls(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient getSourceControl"})
        @GET(value="providers/Microsoft.Web/sourcecontrols/{sourceControlType}")
        public Observable<Response<ResponseBody>> getSourceControl(@Path(value="sourceControlType") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient updateSourceControl"})
        @PUT(value="providers/Microsoft.Web/sourcecontrols/{sourceControlType}")
        public Observable<Response<ResponseBody>> updateSourceControl(@Path(value="sourceControlType") String var1, @Body SourceControlInner var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listBillingMeters"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Web/billingMeters")
        public Observable<Response<ResponseBody>> listBillingMeters(@Path(value="subscriptionId") String var1, @Query(value="billingLocation") String var2, @Query(value="osType") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient checkNameAvailability"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Web/checknameavailability")
        public Observable<Response<ResponseBody>> checkNameAvailability(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body ResourceNameAvailabilityRequest var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient getSubscriptionDeploymentLocations"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Web/deploymentLocations")
        public Observable<Response<ResponseBody>> getSubscriptionDeploymentLocations(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listGeoRegions"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Web/geoRegions")
        public Observable<Response<ResponseBody>> listGeoRegions(@Path(value="subscriptionId") String var1, @Query(value="sku") SkuName var2, @Query(value="linuxWorkersEnabled") Boolean var3, @Query(value="xenonWorkersEnabled") Boolean var4, @Query(value="linuxDynamicWorkersEnabled") Boolean var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listSiteIdentifiersAssignedToHostName"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Web/listSitesAssignedToHostName")
        public Observable<Response<ResponseBody>> listSiteIdentifiersAssignedToHostName(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body NameIdentifierInner var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listPremierAddOnOffers"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Web/premieraddonoffers")
        public Observable<Response<ResponseBody>> listPremierAddOnOffers(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listSkus"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Web/skus")
        public Observable<Response<ResponseBody>> listSkus(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient verifyHostingEnvironmentVnet"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Web/verifyHostingEnvironmentVnet")
        public Observable<Response<ResponseBody>> verifyHostingEnvironmentVnet(@Path(value="subscriptionId") String var1, @Body VnetParameters var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient move"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/moveResources")
        public Observable<Response<ResponseBody>> move(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Body CsmMoveResourceEnvelope var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient validate"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/validate")
        public Observable<Response<ResponseBody>> validate(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Body ValidateRequest var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient validateContainerSettings"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/validateContainerSettings")
        public Observable<Response<ResponseBody>> validateContainerSettings(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Body ValidateContainerSettingsRequest var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient validateMove"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/validateMoveResources")
        public Observable<Response<ResponseBody>> validateMove(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Body CsmMoveResourceEnvelope var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listSourceControlsNext"})
        @GET
        public Observable<Response<ResponseBody>> listSourceControlsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listBillingMetersNext"})
        @GET
        public Observable<Response<ResponseBody>> listBillingMetersNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listGeoRegionsNext"})
        @GET
        public Observable<Response<ResponseBody>> listGeoRegionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listSiteIdentifiersAssignedToHostNameNext"})
        @GET
        public Observable<Response<ResponseBody>> listSiteIdentifiersAssignedToHostNameNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebSiteManagementClient listPremierAddOnOffersNext"})
        @GET
        public Observable<Response<ResponseBody>> listPremierAddOnOffersNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

