/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.metrics.sink;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricType;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerMetricsJsonSink
implements MetricsSink {
    private static final Logger LOG = LoggerFactory.getLogger(RangerMetricsJsonSink.class);
    private final Set<String> contexts;
    private final Map<String, Map<String, Object>> metricsJson = new HashMap<String, Map<String, Object>>();

    public RangerMetricsJsonSink(Set<String> contexts) {
        this.contexts = contexts;
    }

    public void init(SubsetConfiguration conf) {
    }

    public void putMetrics(MetricsRecord metricsRecord) {
        try {
            if (this.contexts.contains(metricsRecord.context())) {
                for (AbstractMetric metrics : metricsRecord.metrics()) {
                    if (metrics.type() != MetricType.COUNTER && metrics.type() != MetricType.GAUGE) continue;
                    String recordName = metricsRecord.name();
                    Map<String, Object> record = this.metricsJson.get(recordName);
                    if (Objects.isNull(record)) {
                        record = new HashMap<String, Object>();
                    }
                    record.put(metrics.name(), metrics.value());
                    this.metricsJson.put(recordName, record);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("=== RangerMetricsJsonSink:putMetrics(): skipping... " + metricsRecord.context());
            }
        }
        catch (Exception e) {
            LOG.error("Exception occured while converting metrics into json.", (Throwable)e);
        }
    }

    public void flush() {
    }

    public Map<String, Map<String, Object>> getMetrics() {
        return this.metricsJson;
    }
}

