/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.locks.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.locks.implementation.ManagementLockClientImpl;
import com.microsoft.azure.management.locks.implementation.ManagementLockObjectInner;
import com.microsoft.azure.management.locks.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ManagementLocksInner
implements InnerSupportsGet<ManagementLockObjectInner>,
InnerSupportsListing<ManagementLockObjectInner> {
    private ManagementLocksService service;
    private ManagementLockClientImpl client;

    public ManagementLocksInner(Retrofit retrofit, ManagementLockClientImpl client) {
        this.service = (ManagementLocksService)retrofit.create(ManagementLocksService.class);
        this.client = client;
    }

    public ManagementLockObjectInner createOrUpdateAtResourceGroupLevel(String resourceGroupName, String lockName, ManagementLockObjectInner parameters) {
        return (ManagementLockObjectInner)((ServiceResponse)this.createOrUpdateAtResourceGroupLevelWithServiceResponseAsync(resourceGroupName, lockName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<ManagementLockObjectInner> createOrUpdateAtResourceGroupLevelAsync(String resourceGroupName, String lockName, ManagementLockObjectInner parameters, ServiceCallback<ManagementLockObjectInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateAtResourceGroupLevelWithServiceResponseAsync(resourceGroupName, lockName, parameters), serviceCallback);
    }

    public Observable<ManagementLockObjectInner> createOrUpdateAtResourceGroupLevelAsync(String resourceGroupName, String lockName, ManagementLockObjectInner parameters) {
        return this.createOrUpdateAtResourceGroupLevelWithServiceResponseAsync(resourceGroupName, lockName, parameters).map((Func1)new Func1<ServiceResponse<ManagementLockObjectInner>, ManagementLockObjectInner>(){

            public ManagementLockObjectInner call(ServiceResponse<ManagementLockObjectInner> response) {
                return (ManagementLockObjectInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ManagementLockObjectInner>> createOrUpdateAtResourceGroupLevelWithServiceResponseAsync(String resourceGroupName, String lockName, ManagementLockObjectInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.createOrUpdateAtResourceGroupLevel(resourceGroupName, lockName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagementLockObjectInner>>>(){

            public Observable<ServiceResponse<ManagementLockObjectInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagementLocksInner.this.createOrUpdateAtResourceGroupLevelDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagementLockObjectInner> createOrUpdateAtResourceGroupLevelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagementLockObjectInner>(){}.getType()).register(201, new TypeToken<ManagementLockObjectInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteAtResourceGroupLevel(String resourceGroupName, String lockName) {
        ((ServiceResponse)this.deleteAtResourceGroupLevelWithServiceResponseAsync(resourceGroupName, lockName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAtResourceGroupLevelAsync(String resourceGroupName, String lockName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteAtResourceGroupLevelWithServiceResponseAsync(resourceGroupName, lockName), serviceCallback);
    }

    public Observable<Void> deleteAtResourceGroupLevelAsync(String resourceGroupName, String lockName) {
        return this.deleteAtResourceGroupLevelWithServiceResponseAsync(resourceGroupName, lockName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteAtResourceGroupLevelWithServiceResponseAsync(String resourceGroupName, String lockName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.deleteAtResourceGroupLevel(resourceGroupName, lockName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagementLocksInner.this.deleteAtResourceGroupLevelDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteAtResourceGroupLevelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagementLockObjectInner getByResourceGroup(String resourceGroupName, String lockName) {
        return (ManagementLockObjectInner)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, lockName).toBlocking().single()).body();
    }

    public ServiceFuture<ManagementLockObjectInner> getByResourceGroupAsync(String resourceGroupName, String lockName, ServiceCallback<ManagementLockObjectInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, lockName), serviceCallback);
    }

    public Observable<ManagementLockObjectInner> getByResourceGroupAsync(String resourceGroupName, String lockName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, lockName).map((Func1)new Func1<ServiceResponse<ManagementLockObjectInner>, ManagementLockObjectInner>(){

            public ManagementLockObjectInner call(ServiceResponse<ManagementLockObjectInner> response) {
                return (ManagementLockObjectInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ManagementLockObjectInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String lockName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(resourceGroupName, lockName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagementLockObjectInner>>>(){

            public Observable<ServiceResponse<ManagementLockObjectInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagementLocksInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagementLockObjectInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagementLockObjectInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagementLockObjectInner createOrUpdateByScope(String scope, String lockName, ManagementLockObjectInner parameters) {
        return (ManagementLockObjectInner)((ServiceResponse)this.createOrUpdateByScopeWithServiceResponseAsync(scope, lockName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<ManagementLockObjectInner> createOrUpdateByScopeAsync(String scope, String lockName, ManagementLockObjectInner parameters, ServiceCallback<ManagementLockObjectInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateByScopeWithServiceResponseAsync(scope, lockName, parameters), serviceCallback);
    }

    public Observable<ManagementLockObjectInner> createOrUpdateByScopeAsync(String scope, String lockName, ManagementLockObjectInner parameters) {
        return this.createOrUpdateByScopeWithServiceResponseAsync(scope, lockName, parameters).map((Func1)new Func1<ServiceResponse<ManagementLockObjectInner>, ManagementLockObjectInner>(){

            public ManagementLockObjectInner call(ServiceResponse<ManagementLockObjectInner> response) {
                return (ManagementLockObjectInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ManagementLockObjectInner>> createOrUpdateByScopeWithServiceResponseAsync(String scope, String lockName, ManagementLockObjectInner parameters) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.createOrUpdateByScope(scope, lockName, parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagementLockObjectInner>>>(){

            public Observable<ServiceResponse<ManagementLockObjectInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagementLocksInner.this.createOrUpdateByScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagementLockObjectInner> createOrUpdateByScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagementLockObjectInner>(){}.getType()).register(201, new TypeToken<ManagementLockObjectInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteByScope(String scope, String lockName) {
        ((ServiceResponse)this.deleteByScopeWithServiceResponseAsync(scope, lockName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteByScopeAsync(String scope, String lockName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteByScopeWithServiceResponseAsync(scope, lockName), serviceCallback);
    }

    public Observable<Void> deleteByScopeAsync(String scope, String lockName) {
        return this.deleteByScopeWithServiceResponseAsync(scope, lockName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteByScopeWithServiceResponseAsync(String scope, String lockName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.deleteByScope(scope, lockName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagementLocksInner.this.deleteByScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteByScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagementLockObjectInner getByScope(String scope, String lockName) {
        return (ManagementLockObjectInner)((ServiceResponse)this.getByScopeWithServiceResponseAsync(scope, lockName).toBlocking().single()).body();
    }

    public ServiceFuture<ManagementLockObjectInner> getByScopeAsync(String scope, String lockName, ServiceCallback<ManagementLockObjectInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByScopeWithServiceResponseAsync(scope, lockName), serviceCallback);
    }

    public Observable<ManagementLockObjectInner> getByScopeAsync(String scope, String lockName) {
        return this.getByScopeWithServiceResponseAsync(scope, lockName).map((Func1)new Func1<ServiceResponse<ManagementLockObjectInner>, ManagementLockObjectInner>(){

            public ManagementLockObjectInner call(ServiceResponse<ManagementLockObjectInner> response) {
                return (ManagementLockObjectInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ManagementLockObjectInner>> getByScopeWithServiceResponseAsync(String scope, String lockName) {
        if (scope == null) {
            throw new IllegalArgumentException("Parameter scope is required and cannot be null.");
        }
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByScope(scope, lockName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagementLockObjectInner>>>(){

            public Observable<ServiceResponse<ManagementLockObjectInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagementLocksInner.this.getByScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagementLockObjectInner> getByScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagementLockObjectInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagementLockObjectInner createOrUpdateAtResourceLevel(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName, ManagementLockObjectInner parameters) {
        return (ManagementLockObjectInner)((ServiceResponse)this.createOrUpdateAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<ManagementLockObjectInner> createOrUpdateAtResourceLevelAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName, ManagementLockObjectInner parameters, ServiceCallback<ManagementLockObjectInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName, parameters), serviceCallback);
    }

    public Observable<ManagementLockObjectInner> createOrUpdateAtResourceLevelAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName, ManagementLockObjectInner parameters) {
        return this.createOrUpdateAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName, parameters).map((Func1)new Func1<ServiceResponse<ManagementLockObjectInner>, ManagementLockObjectInner>(){

            public ManagementLockObjectInner call(ServiceResponse<ManagementLockObjectInner> response) {
                return (ManagementLockObjectInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ManagementLockObjectInner>> createOrUpdateAtResourceLevelWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName, ManagementLockObjectInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.createOrUpdateAtResourceLevel(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagementLockObjectInner>>>(){

            public Observable<ServiceResponse<ManagementLockObjectInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagementLocksInner.this.createOrUpdateAtResourceLevelDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagementLockObjectInner> createOrUpdateAtResourceLevelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagementLockObjectInner>(){}.getType()).register(201, new TypeToken<ManagementLockObjectInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteAtResourceLevel(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName) {
        ((ServiceResponse)this.deleteAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAtResourceLevelAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName), serviceCallback);
    }

    public Observable<Void> deleteAtResourceLevelAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName) {
        return this.deleteAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteAtResourceLevelWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.deleteAtResourceLevel(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagementLocksInner.this.deleteAtResourceLevelDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteAtResourceLevelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagementLockObjectInner getAtResourceLevel(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName) {
        return (ManagementLockObjectInner)((ServiceResponse)this.getAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName).toBlocking().single()).body();
    }

    public ServiceFuture<ManagementLockObjectInner> getAtResourceLevelAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName, ServiceCallback<ManagementLockObjectInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName), serviceCallback);
    }

    public Observable<ManagementLockObjectInner> getAtResourceLevelAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName) {
        return this.getAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName).map((Func1)new Func1<ServiceResponse<ManagementLockObjectInner>, ManagementLockObjectInner>(){

            public ManagementLockObjectInner call(ServiceResponse<ManagementLockObjectInner> response) {
                return (ManagementLockObjectInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ManagementLockObjectInner>> getAtResourceLevelWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String lockName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getAtResourceLevel(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagementLockObjectInner>>>(){

            public Observable<ServiceResponse<ManagementLockObjectInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagementLocksInner.this.getAtResourceLevelDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagementLockObjectInner> getAtResourceLevelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagementLockObjectInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagementLockObjectInner createOrUpdateAtSubscriptionLevel(String lockName, ManagementLockObjectInner parameters) {
        return (ManagementLockObjectInner)((ServiceResponse)this.createOrUpdateAtSubscriptionLevelWithServiceResponseAsync(lockName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<ManagementLockObjectInner> createOrUpdateAtSubscriptionLevelAsync(String lockName, ManagementLockObjectInner parameters, ServiceCallback<ManagementLockObjectInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateAtSubscriptionLevelWithServiceResponseAsync(lockName, parameters), serviceCallback);
    }

    public Observable<ManagementLockObjectInner> createOrUpdateAtSubscriptionLevelAsync(String lockName, ManagementLockObjectInner parameters) {
        return this.createOrUpdateAtSubscriptionLevelWithServiceResponseAsync(lockName, parameters).map((Func1)new Func1<ServiceResponse<ManagementLockObjectInner>, ManagementLockObjectInner>(){

            public ManagementLockObjectInner call(ServiceResponse<ManagementLockObjectInner> response) {
                return (ManagementLockObjectInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ManagementLockObjectInner>> createOrUpdateAtSubscriptionLevelWithServiceResponseAsync(String lockName, ManagementLockObjectInner parameters) {
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.createOrUpdateAtSubscriptionLevel(lockName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagementLockObjectInner>>>(){

            public Observable<ServiceResponse<ManagementLockObjectInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagementLocksInner.this.createOrUpdateAtSubscriptionLevelDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagementLockObjectInner> createOrUpdateAtSubscriptionLevelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<ManagementLockObjectInner>(){}.getType()).register(200, new TypeToken<ManagementLockObjectInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteAtSubscriptionLevel(String lockName) {
        ((ServiceResponse)this.deleteAtSubscriptionLevelWithServiceResponseAsync(lockName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAtSubscriptionLevelAsync(String lockName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteAtSubscriptionLevelWithServiceResponseAsync(lockName), serviceCallback);
    }

    public Observable<Void> deleteAtSubscriptionLevelAsync(String lockName) {
        return this.deleteAtSubscriptionLevelWithServiceResponseAsync(lockName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteAtSubscriptionLevelWithServiceResponseAsync(String lockName) {
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.deleteAtSubscriptionLevel(lockName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagementLocksInner.this.deleteAtSubscriptionLevelDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteAtSubscriptionLevelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagementLockObjectInner getAtSubscriptionLevel(String lockName) {
        return (ManagementLockObjectInner)((ServiceResponse)this.getAtSubscriptionLevelWithServiceResponseAsync(lockName).toBlocking().single()).body();
    }

    public ServiceFuture<ManagementLockObjectInner> getAtSubscriptionLevelAsync(String lockName, ServiceCallback<ManagementLockObjectInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAtSubscriptionLevelWithServiceResponseAsync(lockName), serviceCallback);
    }

    public Observable<ManagementLockObjectInner> getAtSubscriptionLevelAsync(String lockName) {
        return this.getAtSubscriptionLevelWithServiceResponseAsync(lockName).map((Func1)new Func1<ServiceResponse<ManagementLockObjectInner>, ManagementLockObjectInner>(){

            public ManagementLockObjectInner call(ServiceResponse<ManagementLockObjectInner> response) {
                return (ManagementLockObjectInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ManagementLockObjectInner>> getAtSubscriptionLevelWithServiceResponseAsync(String lockName) {
        if (lockName == null) {
            throw new IllegalArgumentException("Parameter lockName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getAtSubscriptionLevel(lockName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagementLockObjectInner>>>(){

            public Observable<ServiceResponse<ManagementLockObjectInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagementLocksInner.this.getAtSubscriptionLevelDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagementLockObjectInner> getAtSubscriptionLevelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagementLockObjectInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagementLockObjectInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ManagementLockObjectInner>((Page)response.body()){

            public Page<ManagementLockObjectInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagementLocksInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagementLockObjectInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<ManagementLockObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(String nextPageLink) {
                return ManagementLocksInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagementLockObjectInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Page<ManagementLockObjectInner>>(){

            public Page<ManagementLockObjectInner> call(ServiceResponse<Page<ManagementLockObjectInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(ServiceResponse<Page<ManagementLockObjectInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagementLocksInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagementLocksInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ManagementLockObjectInner> listByResourceGroup(String resourceGroupName, String filter) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName, filter).toBlocking().single();
        return new PagedList<ManagementLockObjectInner>((Page)response.body()){

            public Page<ManagementLockObjectInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagementLocksInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagementLockObjectInner>> listByResourceGroupAsync(String resourceGroupName, String filter, ListOperationCallback<ManagementLockObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(String nextPageLink) {
                return ManagementLocksInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagementLockObjectInner>> listByResourceGroupAsync(String resourceGroupName, String filter) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, filter).map((Func1)new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Page<ManagementLockObjectInner>>(){

            public Page<ManagementLockObjectInner> call(ServiceResponse<Page<ManagementLockObjectInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, String filter) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName, filter).concatMap((Func1)new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(ServiceResponse<Page<ManagementLockObjectInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagementLocksInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName, String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagementLocksInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ManagementLockObjectInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ManagementLockObjectInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagementLockObjectInner> listAtResourceLevel(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName) {
        ServiceResponse response = (ServiceResponse)this.listAtResourceLevelSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName).toBlocking().single();
        return new PagedList<ManagementLockObjectInner>((Page)response.body()){

            public Page<ManagementLockObjectInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagementLocksInner.this.listAtResourceLevelNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagementLockObjectInner>> listAtResourceLevelAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, ListOperationCallback<ManagementLockObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtResourceLevelSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(String nextPageLink) {
                return ManagementLocksInner.this.listAtResourceLevelNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagementLockObjectInner>> listAtResourceLevelAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName) {
        return this.listAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName).map((Func1)new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Page<ManagementLockObjectInner>>(){

            public Page<ManagementLockObjectInner> call(ServiceResponse<Page<ManagementLockObjectInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listAtResourceLevelWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName) {
        return this.listAtResourceLevelSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName).concatMap((Func1)new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(ServiceResponse<Page<ManagementLockObjectInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagementLocksInner.this.listAtResourceLevelNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listAtResourceLevelSinglePageAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        return this.service.listAtResourceLevel(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagementLocksInner.this.listAtResourceLevelDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ManagementLockObjectInner> listAtResourceLevel(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter) {
        ServiceResponse response = (ServiceResponse)this.listAtResourceLevelSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter).toBlocking().single();
        return new PagedList<ManagementLockObjectInner>((Page)response.body()){

            public Page<ManagementLockObjectInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagementLocksInner.this.listAtResourceLevelNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagementLockObjectInner>> listAtResourceLevelAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter, ListOperationCallback<ManagementLockObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtResourceLevelSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(String nextPageLink) {
                return ManagementLocksInner.this.listAtResourceLevelNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagementLockObjectInner>> listAtResourceLevelAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter) {
        return this.listAtResourceLevelWithServiceResponseAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter).map((Func1)new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Page<ManagementLockObjectInner>>(){

            public Page<ManagementLockObjectInner> call(ServiceResponse<Page<ManagementLockObjectInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listAtResourceLevelWithServiceResponseAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter) {
        return this.listAtResourceLevelSinglePageAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, filter).concatMap((Func1)new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(ServiceResponse<Page<ManagementLockObjectInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagementLocksInner.this.listAtResourceLevelNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listAtResourceLevelSinglePageAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (parentResourcePath == null) {
            throw new IllegalArgumentException("Parameter parentResourcePath is required and cannot be null.");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("Parameter resourceType is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listAtResourceLevel(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagementLocksInner.this.listAtResourceLevelDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ManagementLockObjectInner>> listAtResourceLevelDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ManagementLockObjectInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagementLockObjectInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ManagementLockObjectInner>((Page)response.body()){

            public Page<ManagementLockObjectInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagementLocksInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagementLockObjectInner>> listAsync(ListOperationCallback<ManagementLockObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(String nextPageLink) {
                return ManagementLocksInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagementLockObjectInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Page<ManagementLockObjectInner>>(){

            public Page<ManagementLockObjectInner> call(ServiceResponse<Page<ManagementLockObjectInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(ServiceResponse<Page<ManagementLockObjectInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagementLocksInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        return this.service.list(this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagementLocksInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ManagementLockObjectInner> list(String filter) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(filter).toBlocking().single();
        return new PagedList<ManagementLockObjectInner>((Page)response.body()){

            public Page<ManagementLockObjectInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagementLocksInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagementLockObjectInner>> listAsync(String filter, ListOperationCallback<ManagementLockObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(String nextPageLink) {
                return ManagementLocksInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagementLockObjectInner>> listAsync(String filter) {
        return this.listWithServiceResponseAsync(filter).map((Func1)new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Page<ManagementLockObjectInner>>(){

            public Page<ManagementLockObjectInner> call(ServiceResponse<Page<ManagementLockObjectInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listWithServiceResponseAsync(String filter) {
        return this.listSinglePageAsync(filter).concatMap((Func1)new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(ServiceResponse<Page<ManagementLockObjectInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagementLocksInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listSinglePageAsync(String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagementLocksInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ManagementLockObjectInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ManagementLockObjectInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagementLockObjectInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagementLockObjectInner>((Page)response.body()){

            public Page<ManagementLockObjectInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagementLocksInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagementLockObjectInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<ManagementLockObjectInner>> serviceFuture, ListOperationCallback<ManagementLockObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(String nextPageLink) {
                return ManagementLocksInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagementLockObjectInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Page<ManagementLockObjectInner>>(){

            public Page<ManagementLockObjectInner> call(ServiceResponse<Page<ManagementLockObjectInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(ServiceResponse<Page<ManagementLockObjectInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagementLocksInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagementLocksInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ManagementLockObjectInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ManagementLockObjectInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagementLockObjectInner> listAtResourceLevelNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAtResourceLevelNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagementLockObjectInner>((Page)response.body()){

            public Page<ManagementLockObjectInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagementLocksInner.this.listAtResourceLevelNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagementLockObjectInner>> listAtResourceLevelNextAsync(String nextPageLink, ServiceFuture<List<ManagementLockObjectInner>> serviceFuture, ListOperationCallback<ManagementLockObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtResourceLevelNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(String nextPageLink) {
                return ManagementLocksInner.this.listAtResourceLevelNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagementLockObjectInner>> listAtResourceLevelNextAsync(String nextPageLink) {
        return this.listAtResourceLevelNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Page<ManagementLockObjectInner>>(){

            public Page<ManagementLockObjectInner> call(ServiceResponse<Page<ManagementLockObjectInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listAtResourceLevelNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAtResourceLevelNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(ServiceResponse<Page<ManagementLockObjectInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagementLocksInner.this.listAtResourceLevelNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listAtResourceLevelNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAtResourceLevelNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagementLocksInner.this.listAtResourceLevelNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ManagementLockObjectInner>> listAtResourceLevelNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ManagementLockObjectInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagementLockObjectInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagementLockObjectInner>((Page)response.body()){

            public Page<ManagementLockObjectInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagementLocksInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagementLockObjectInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ManagementLockObjectInner>> serviceFuture, ListOperationCallback<ManagementLockObjectInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(String nextPageLink) {
                return ManagementLocksInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagementLockObjectInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Page<ManagementLockObjectInner>>(){

            public Page<ManagementLockObjectInner> call(ServiceResponse<Page<ManagementLockObjectInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ManagementLockObjectInner>>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(ServiceResponse<Page<ManagementLockObjectInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagementLocksInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagementLockObjectInner>>>>(){

            public Observable<ServiceResponse<Page<ManagementLockObjectInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagementLocksInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ManagementLockObjectInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ManagementLockObjectInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ManagementLocksService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks createOrUpdateAtResourceGroupLevel"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}")
        public Observable<Response<ResponseBody>> createOrUpdateAtResourceGroupLevel(@Path(value="resourceGroupName") String var1, @Path(value="lockName") String var2, @Path(value="subscriptionId") String var3, @Body ManagementLockObjectInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks deleteAtResourceGroupLevel"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteAtResourceGroupLevel(@Path(value="resourceGroupName") String var1, @Path(value="lockName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="lockName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks createOrUpdateByScope"})
        @PUT(value="{scope}/providers/Microsoft.Authorization/locks/{lockName}")
        public Observable<Response<ResponseBody>> createOrUpdateByScope(@Path(value="scope") String var1, @Path(value="lockName") String var2, @Body ManagementLockObjectInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks deleteByScope"})
        @HTTP(path="{scope}/providers/Microsoft.Authorization/locks/{lockName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteByScope(@Path(value="scope") String var1, @Path(value="lockName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks getByScope"})
        @GET(value="{scope}/providers/Microsoft.Authorization/locks/{lockName}")
        public Observable<Response<ResponseBody>> getByScope(@Path(value="scope") String var1, @Path(value="lockName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks createOrUpdateAtResourceLevel"})
        @PUT(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}")
        public Observable<Response<ResponseBody>> createOrUpdateAtResourceLevel(@Path(value="resourceGroupName") String var1, @Path(value="resourceProviderNamespace") String var2, @Path(value="parentResourcePath", encoded=true) String var3, @Path(value="resourceType", encoded=true) String var4, @Path(value="resourceName") String var5, @Path(value="lockName") String var6, @Path(value="subscriptionId") String var7, @Body ManagementLockObjectInner var8, @Query(value="api-version") String var9, @Header(value="accept-language") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks deleteAtResourceLevel"})
        @HTTP(path="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteAtResourceLevel(@Path(value="resourceGroupName") String var1, @Path(value="resourceProviderNamespace") String var2, @Path(value="parentResourcePath", encoded=true) String var3, @Path(value="resourceType", encoded=true) String var4, @Path(value="resourceName") String var5, @Path(value="lockName") String var6, @Path(value="subscriptionId") String var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks getAtResourceLevel"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}")
        public Observable<Response<ResponseBody>> getAtResourceLevel(@Path(value="resourceGroupName") String var1, @Path(value="resourceProviderNamespace") String var2, @Path(value="parentResourcePath", encoded=true) String var3, @Path(value="resourceType", encoded=true) String var4, @Path(value="resourceName") String var5, @Path(value="lockName") String var6, @Path(value="subscriptionId") String var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks createOrUpdateAtSubscriptionLevel"})
        @PUT(value="subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}")
        public Observable<Response<ResponseBody>> createOrUpdateAtSubscriptionLevel(@Path(value="lockName") String var1, @Path(value="subscriptionId") String var2, @Body ManagementLockObjectInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks deleteAtSubscriptionLevel"})
        @HTTP(path="subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteAtSubscriptionLevel(@Path(value="lockName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks getAtSubscriptionLevel"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}")
        public Observable<Response<ResponseBody>> getAtSubscriptionLevel(@Path(value="lockName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="$filter") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks listAtResourceLevel"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks")
        public Observable<Response<ResponseBody>> listAtResourceLevel(@Path(value="resourceGroupName") String var1, @Path(value="resourceProviderNamespace") String var2, @Path(value="parentResourcePath", encoded=true) String var3, @Path(value="resourceType", encoded=true) String var4, @Path(value="resourceName") String var5, @Path(value="subscriptionId") String var6, @Query(value="$filter") String var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="$filter") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks listAtResourceLevelNext"})
        @GET
        public Observable<Response<ResponseBody>> listAtResourceLevelNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.locks.ManagementLocks listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

