/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerPluginClassLoader
extends URLClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(RangerPluginClassLoader.class);
    private static final String TAG_SERVICE_TYPE = "tag";
    private static final Map<String, RangerPluginClassLoader> PLUGIN_CLASS_LOADERS = new HashMap<String, RangerPluginClassLoader>();
    private final ComponentClassLoader componentClassLoader;
    private final ThreadLocal<ClassLoader> preActivateClassLoader = new ThreadLocal();

    public RangerPluginClassLoader(String pluginType, Class<?> pluginClass) throws Exception {
        super(RangerPluginClassLoaderUtil.getInstance().getPluginFilesForServiceTypeAndPluginclass(pluginType, pluginClass), (ClassLoader)null);
        this.componentClassLoader = AccessController.doPrivileged(() -> new ComponentClassLoader(pluginClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RangerPluginClassLoader getInstance(String pluginType, Class<?> pluginClass) throws Exception {
        RangerPluginClassLoader ret = PLUGIN_CLASS_LOADERS.get(pluginType);
        if (ret != null) return ret;
        Class<RangerPluginClassLoader> clazz = RangerPluginClassLoader.class;
        synchronized (RangerPluginClassLoader.class) {
            ret = PLUGIN_CLASS_LOADERS.get(pluginType);
            if (ret != null) return ret;
            if (pluginClass != null) {
                ret = AccessController.doPrivileged(() -> new RangerPluginClassLoader(pluginType, pluginClass));
            } else if (pluginType == null && !PLUGIN_CLASS_LOADERS.isEmpty()) {
                ArrayList<String> pluginTypes = new ArrayList<String>(PLUGIN_CLASS_LOADERS.keySet());
                Collections.sort(pluginTypes);
                String pluginTypeToUse = (String)pluginTypes.get(0);
                ret = PLUGIN_CLASS_LOADERS.get(pluginTypeToUse);
                LOG.info("RangerPluginClassLoader.getInstance(pluginType=null): using classLoader for pluginType={}", (Object)pluginTypeToUse);
            }
            if (ret == null) return ret;
            PLUGIN_CLASS_LOADERS.put(pluginType, ret);
            if (pluginType == null || pluginType.equals(TAG_SERVICE_TYPE)) return ret;
            PLUGIN_CLASS_LOADERS.put(TAG_SERVICE_TYPE, ret);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return ret;
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> ret;
        block2: {
            LOG.debug("==> RangerPluginClassLoader.findClass({})", (Object)name);
            ret = null;
            try {
                LOG.debug("RangerPluginClassLoader.findClass({}): calling childClassLoader().findClass() ", (Object)name);
                ret = super.findClass(name);
            }
            catch (Throwable e) {
                LOG.debug("RangerPluginClassLoader.findClass({}): calling componentClassLoader.findClass()", (Object)name);
                ComponentClassLoader savedClassLoader = this.getComponentClassLoader();
                if (savedClassLoader == null) break block2;
                ret = savedClassLoader.findClass(name);
            }
        }
        LOG.debug("<== RangerPluginClassLoader.findClass({}): {}", (Object)name, ret);
        return ret;
    }

    @Override
    public URL findResource(String name) {
        LOG.debug("==> RangerPluginClassLoader.findResource({}) ", (Object)name);
        URL ret = super.findResource(name);
        if (ret == null) {
            LOG.debug("RangerPluginClassLoader.findResource({}): calling componentClassLoader.getResources()", (Object)name);
            ComponentClassLoader savedClassLoader = this.getComponentClassLoader();
            if (savedClassLoader != null) {
                ret = savedClassLoader.getResource(name);
            }
        }
        LOG.debug("<== RangerPluginClassLoader.findResource({}): {}", (Object)name, (Object)ret);
        return ret;
    }

    @Override
    public Enumeration<URL> findResources(String name) {
        LOG.debug("==> RangerPluginClassLoader.findResources({}) ", (Object)name);
        MergeEnumeration ret = new MergeEnumeration(this.findResourcesUsingChildClassLoader(name), this.findResourcesUsingComponentClassLoader(name));
        LOG.debug("<== RangerPluginClassLoader.findResources({}) ", (Object)name);
        return ret;
    }

    @Override
    public synchronized Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> ret;
        block2: {
            LOG.debug("==> RangerPluginClassLoader.loadClass({})", (Object)name);
            ret = null;
            try {
                LOG.debug("RangerPluginClassLoader.loadClass({}): calling childClassLoader.findClass()", (Object)name);
                ret = super.loadClass(name);
            }
            catch (Throwable e) {
                LOG.debug("RangerPluginClassLoader.loadClass({}): calling componentClassLoader.loadClass()", (Object)name);
                ComponentClassLoader savedClassLoader = this.getComponentClassLoader();
                if (savedClassLoader == null) break block2;
                ret = savedClassLoader.loadClass(name);
            }
        }
        LOG.debug("<== RangerPluginClassLoader.loadClass({}): {}", (Object)name, ret);
        return ret;
    }

    public Enumeration<URL> findResourcesUsingChildClassLoader(String name) {
        Enumeration<URL> ret = null;
        try {
            LOG.debug("RangerPluginClassLoader.findResourcesUsingChildClassLoader({}): calling childClassLoader.findResources()", (Object)name);
            ret = super.findResources(name);
        }
        catch (Throwable t) {
            LOG.debug("RangerPluginClassLoader.findResourcesUsingChildClassLoader({}): class not found in child. Falling back to componentClassLoader", (Object)name, (Object)t);
        }
        return ret;
    }

    public Enumeration<URL> findResourcesUsingComponentClassLoader(String name) {
        Enumeration<URL> ret = null;
        try {
            LOG.debug("RangerPluginClassLoader.findResourcesUsingComponentClassLoader({}): calling componentClassLoader.getResources()", (Object)name);
            ComponentClassLoader savedClassLoader = this.getComponentClassLoader();
            if (savedClassLoader != null) {
                ret = savedClassLoader.getResources(name);
            }
            LOG.debug("<== RangerPluginClassLoader.findResourcesUsingComponentClassLoader({}): {}", (Object)name, ret);
        }
        catch (Throwable t) {
            LOG.debug("RangerPluginClassLoader.findResourcesUsingComponentClassLoader({}): class not found in componentClassLoader.", (Object)name, (Object)t);
        }
        return ret;
    }

    public void activate() {
        LOG.debug("==> RangerPluginClassLoader.activate()");
        this.preActivateClassLoader.set(Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(this);
        LOG.debug("<== RangerPluginClassLoader.activate()");
    }

    public void deactivate() {
        LOG.debug("==> RangerPluginClassLoader.deactivate()");
        ClassLoader classLoader = this.preActivateClassLoader.get();
        if (classLoader != null) {
            this.preActivateClassLoader.remove();
        } else {
            ComponentClassLoader savedClassLoader = this.getComponentClassLoader();
            if (savedClassLoader != null && savedClassLoader.getParent() != null) {
                classLoader = savedClassLoader.getParent();
            }
        }
        if (classLoader != null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            LOG.warn("RangerPluginClassLoader.deactivate() was not successful. Couldn't get the saved classLoader...");
        }
        LOG.debug("<== RangerPluginClassLoader.deactivate()");
    }

    public ClassLoader getPrevActiveClassLoader() {
        ComponentClassLoader savedClassLoader;
        ClassLoader ret = this.preActivateClassLoader.get();
        if (ret == null && (savedClassLoader = this.getComponentClassLoader()) != null && savedClassLoader.getParent() != null) {
            ret = savedClassLoader.getParent();
        }
        return ret;
    }

    private ComponentClassLoader getComponentClassLoader() {
        return this.componentClassLoader;
    }

    static class MergeEnumeration
    implements Enumeration<URL> {
        final Enumeration<URL> e1;
        final Enumeration<URL> e2;

        public MergeEnumeration(Enumeration<URL> e1, Enumeration<URL> e2) {
            this.e1 = e1;
            this.e2 = e2;
        }

        @Override
        public boolean hasMoreElements() {
            return this.e1 != null && this.e1.hasMoreElements() || this.e2 != null && this.e2.hasMoreElements();
        }

        @Override
        public URL nextElement() {
            URL ret = this.e1 != null && this.e1.hasMoreElements() ? this.e1.nextElement() : (this.e2 != null && this.e2.hasMoreElements() ? this.e2.nextElement() : null);
            return ret;
        }
    }

    static class ComponentClassLoader
    extends ClassLoader {
        public ComponentClassLoader(Class<?> pluginShimClass) {
            super(ComponentClassLoader.getClassLoaderOfShimClassOrCurrentThread(pluginShimClass));
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            return super.findClass(name);
        }

        private static ClassLoader getClassLoaderOfShimClassOrCurrentThread(Class<?> pluginShimClass) {
            return pluginShimClass != null ? pluginShimClass.getClassLoader() : Thread.currentThread().getContextClassLoader();
        }
    }
}

