/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.usergroupsync;

import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;
import org.apache.ranger.usergroupsync.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUserGroupSource {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUserGroupSource.class);
    protected UserGroupSyncConfig config = UserGroupSyncConfig.getInstance();
    protected Mapper userNameRegExInst = null;
    protected Mapper groupNameRegExInst = null;

    public AbstractUserGroupSource() {
        String mappingUserNameHandler = this.config.getUserSyncMappingUserNameHandler();
        try {
            if (mappingUserNameHandler != null) {
                Class<?> regExClass = Class.forName(mappingUserNameHandler);
                this.userNameRegExInst = (Mapper)regExClass.newInstance();
                if (this.userNameRegExInst != null) {
                    this.userNameRegExInst.init("ranger.usersync.mapping.username.regex");
                } else {
                    LOG.error("RegEx handler instance for username is null!");
                }
            }
        }
        catch (ClassNotFoundException cne) {
            LOG.error("Failed to load " + mappingUserNameHandler + " " + cne);
        }
        catch (Throwable te) {
            LOG.error("Failed to instantiate " + mappingUserNameHandler + " " + te);
        }
        String mappingGroupNameHandler = this.config.getUserSyncMappingGroupNameHandler();
        try {
            if (mappingGroupNameHandler != null) {
                Class<?> regExClass = Class.forName(mappingGroupNameHandler);
                this.groupNameRegExInst = (Mapper)regExClass.newInstance();
                if (this.groupNameRegExInst != null) {
                    this.groupNameRegExInst.init("ranger.usersync.mapping.groupname.regex");
                } else {
                    LOG.error("RegEx handler instance for groupname is null!");
                }
            }
        }
        catch (ClassNotFoundException cne) {
            LOG.error("Failed to load " + mappingGroupNameHandler + " " + cne);
        }
        catch (Throwable te) {
            LOG.error("Failed to instantiate " + mappingGroupNameHandler + " " + te);
        }
    }
}

