/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model.validation;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyresourcematcher.RangerDefaultPolicyResourceMatcher;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.policyresourcematcher.RangerResourceEvaluator;
import org.apache.ranger.plugin.resourcematcher.RangerResourceMatcher;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerZoneResourceMatcher
implements RangerResourceEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerZoneResourceMatcher.class);
    private final String securityZoneName;
    private final Map<String, RangerPolicy.RangerPolicyResource> policyResource;
    private final RangerPolicyResourceMatcher policyResourceMatcher;
    private RangerServiceDef.RangerResourceDef leafResourceDef;

    public RangerZoneResourceMatcher(String securityZoneName, Map<String, RangerPolicy.RangerPolicyResource> policyResource, RangerServiceDef serviceDef, RangerPluginContext pluginContext) {
        this(securityZoneName, policyResource, new RangerServiceDefHelper(serviceDef), pluginContext);
    }

    public RangerZoneResourceMatcher(String securityZoneName, Map<String, RangerPolicy.RangerPolicyResource> policyResource, RangerServiceDefHelper serviceDefHelper, RangerPluginContext pluginContext) {
        RangerServiceDef serviceDef = serviceDefHelper.getServiceDef();
        Set<String> resourceKeys = policyResource.keySet();
        RangerDefaultPolicyResourceMatcher matcher = new RangerDefaultPolicyResourceMatcher();
        matcher.setServiceDef(serviceDef);
        matcher.setServiceDefHelper(serviceDefHelper);
        matcher.setPluginContext(pluginContext);
        boolean found = false;
        for (int policyType : RangerPolicy.POLICY_TYPES) {
            for (List<RangerServiceDef.RangerResourceDef> hierarchy : serviceDefHelper.getResourceHierarchies(policyType)) {
                if (!serviceDefHelper.hierarchyHasAllResources(hierarchy, resourceKeys)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found hierarchy for resource-keys:[" + resourceKeys + "], policy-type:[" + policyType + "]");
                }
                matcher.setPolicyResources(policyResource, policyType);
                found = true;
                break;
            }
            if (found) break;
        }
        if (found) {
            matcher.init();
        } else {
            LOG.error("Cannot initialize matcher for RangerZoneResourceMatcher");
        }
        this.securityZoneName = securityZoneName;
        this.policyResourceMatcher = matcher;
        this.policyResource = policyResource;
        this.leafResourceDef = ServiceDefUtil.getLeafResourceDef(serviceDef, this.getPolicyResource());
    }

    public String getSecurityZoneName() {
        return this.securityZoneName;
    }

    @Override
    public long getId() {
        return this.securityZoneName.hashCode();
    }

    @Override
    public RangerPolicyResourceMatcher getPolicyResourceMatcher() {
        return this.policyResourceMatcher;
    }

    @Override
    public Map<String, RangerPolicy.RangerPolicyResource> getPolicyResource() {
        return this.policyResource;
    }

    @Override
    public RangerResourceMatcher getResourceMatcher(String resourceName) {
        return this.policyResourceMatcher != null ? this.policyResourceMatcher.getResourceMatcher(resourceName) : null;
    }

    @Override
    public boolean isAncestorOf(RangerServiceDef.RangerResourceDef resourceDef) {
        return ServiceDefUtil.isAncestorOf(this.policyResourceMatcher.getServiceDef(), this.leafResourceDef, resourceDef);
    }

    @Override
    public boolean isLeaf(String resourceName) {
        return StringUtils.equals((String)resourceName, (String)this.leafResourceDef.getName());
    }

    public String toString() {
        return "{security-zone-name:[" + this.securityZoneName + "], policyResource=[" + this.policyResource + "]}";
    }
}

