/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.Slice;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import jakarta.annotation.Nullable;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

final class BlockUtil {
    private static final double BLOCK_RESET_SKEW = 1.25;
    private static final int DEFAULT_CAPACITY = 64;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF5;

    private BlockUtil() {
    }

    static void checkArrayRange(int[] array, int offset, int length) {
        Objects.requireNonNull(array, "array is null");
        if (offset < 0 || length < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException(String.format("Invalid offset %s and length %s in array with %s elements", offset, length, array.length));
        }
    }

    static void checkArrayRange(boolean[] array, int offset, int length) {
        Objects.requireNonNull(array, "array is null");
        if (offset < 0 || length < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException(String.format("Invalid offset %s and length %s in array with %s elements", offset, length, array.length));
        }
    }

    static void checkValidRegion(int positionCount, int positionOffset, int length) {
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException(String.format("Invalid position %s and length %s in block with %s positions", positionOffset, length, positionCount));
        }
    }

    static void checkValidPositions(boolean[] positions, int positionCount) {
        if (positions.length != positionCount) {
            throw new IllegalArgumentException(String.format("Invalid positions array size %d, actual position count is %d", positions.length, positionCount));
        }
    }

    static void checkValidPosition(int position, int positionCount) {
        if (position < 0 || position >= positionCount) {
            throw new IllegalArgumentException(String.format("Invalid position %s in block with %s positions", position, positionCount));
        }
    }

    static void checkReadablePosition(Block block, int position) {
        BlockUtil.checkValidPosition(position, block.getPositionCount());
    }

    static int calculateNewArraySize(int currentSize) {
        return BlockUtil.calculateNewArraySize(currentSize, 64);
    }

    static int calculateNewArraySize(int currentSize, int minimumSize) {
        if (currentSize < 0 || currentSize > 0x7FFFFFF5 || minimumSize < 0 || minimumSize > 0x7FFFFFF5) {
            throw new IllegalArgumentException("Invalid currentSize or minimumSize");
        }
        if (currentSize == 0x7FFFFFF5) {
            throw new IllegalArgumentException("Cannot grow array beyond size 2147483637");
        }
        minimumSize = Math.max(minimumSize, 64);
        long newSize = (long)currentSize + (long)(currentSize >> 1);
        newSize = Math.clamp(newSize, minimumSize, 0x7FFFFFF5);
        return (int)newSize;
    }

    static int calculateBlockResetSize(int currentSize) {
        long newSize = (long)Math.ceil((double)currentSize * 1.25);
        if (newSize < 64L) {
            newSize = 64L;
        } else if (newSize > 0x7FFFFFF5L) {
            newSize = 0x7FFFFFF5L;
        }
        return (int)newSize;
    }

    static int calculateBlockResetBytes(int currentBytes) {
        long newBytes = (long)Math.ceil((double)currentBytes * 1.25);
        if (newBytes > 0x7FFFFFF5L) {
            return 0x7FFFFFF5;
        }
        return (int)newBytes;
    }

    static int[] compactOffsets(int[] offsets, int index, int length) {
        if (index == 0 && offsets.length == length + 1) {
            return offsets;
        }
        int[] newOffsets = new int[length + 1];
        for (int i = 1; i <= length; ++i) {
            newOffsets[i] = offsets[index + i] - offsets[index];
        }
        return newOffsets;
    }

    static Slice compactSlice(Slice slice, int index, int length) {
        if (slice.isCompact() && index == 0 && length == slice.length()) {
            return slice;
        }
        return slice.copy(index, length);
    }

    static boolean[] compactArray(boolean[] array, int index, int length) {
        if (index == 0 && length == array.length) {
            return array;
        }
        return Arrays.copyOfRange(array, index, index + length);
    }

    static byte[] compactArray(byte[] array, int index, int length) {
        if (index == 0 && length == array.length) {
            return array;
        }
        return Arrays.copyOfRange(array, index, index + length);
    }

    static short[] compactArray(short[] array, int index, int length) {
        if (index == 0 && length == array.length) {
            return array;
        }
        return Arrays.copyOfRange(array, index, index + length);
    }

    static int[] compactArray(int[] array, int index, int length) {
        if (index == 0 && length == array.length) {
            return array;
        }
        return Arrays.copyOfRange(array, index, index + length);
    }

    static long[] compactArray(long[] array, int index, int length) {
        if (index == 0 && length == array.length) {
            return array;
        }
        return Arrays.copyOfRange(array, index, index + length);
    }

    static int countSelectedPositionsFromOffsets(boolean[] positions, int[] offsets, int offsetBase) {
        BlockUtil.checkArrayRange(offsets, offsetBase, positions.length);
        int used = 0;
        for (int i = 0; i < positions.length; ++i) {
            int offsetStart = offsets[offsetBase + i];
            int offsetEnd = offsets[offsetBase + i + 1];
            used += (positions[i] ? 1 : 0) * (offsetEnd - offsetStart);
        }
        return used;
    }

    static int countAndMarkSelectedPositionsFromOffsets(boolean[] positions, int[] offsets, int offsetBase, boolean[] elementPositions) {
        BlockUtil.checkArrayRange(offsets, offsetBase, positions.length);
        int used = 0;
        for (int i = 0; i < positions.length; ++i) {
            int offsetStart = offsets[offsetBase + i];
            int offsetEnd = offsets[offsetBase + i + 1];
            if (!positions[i]) continue;
            used += offsetEnd - offsetStart;
            Arrays.fill(elementPositions, offsetStart, offsetEnd, true);
        }
        return used;
    }

    static boolean arraySame(Object[] array1, Object[] array2) {
        if (array1 == null || array2 == null || array1.length != array2.length) {
            throw new IllegalArgumentException("array1 and array2 cannot be null and should have same length");
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    static Block[] ensureBlocksAreLoaded(Block[] blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            Block loaded = blocks[i].getLoadedBlock();
            if (loaded == blocks[i]) continue;
            Block[] loadedBlocks = (Block[])blocks.clone();
            loadedBlocks[i++] = loaded;
            while (i < blocks.length) {
                loadedBlocks[i] = blocks[i].getLoadedBlock();
                ++i;
            }
            return loadedBlocks;
        }
        return blocks;
    }

    static boolean[] copyIsNullAndAppendNull(@Nullable boolean[] isNull, int offsetBase, int positionCount) {
        int desiredLength = offsetBase + positionCount + 1;
        boolean[] newIsNull = new boolean[desiredLength];
        if (isNull != null) {
            BlockUtil.checkArrayRange(isNull, offsetBase, positionCount);
            System.arraycopy(isNull, 0, newIsNull, 0, desiredLength - 1);
        }
        newIsNull[desiredLength - 1] = true;
        return newIsNull;
    }

    static int[] copyOffsetsAndAppendNull(int[] offsets, int offsetBase, int positionCount) {
        int desiredLength = offsetBase + positionCount + 2;
        BlockUtil.checkArrayRange(offsets, offsetBase, positionCount + 1);
        int[] newOffsets = Arrays.copyOf(offsets, desiredLength);
        newOffsets[desiredLength - 1] = newOffsets[desiredLength - 2];
        return newOffsets;
    }

    public static byte[] ensureCapacity(@Nullable byte[] buffer, int capacity) {
        if (buffer == null) {
            buffer = new byte[capacity];
        } else if (buffer.length < capacity) {
            buffer = Arrays.copyOf(buffer, capacity);
        }
        return buffer;
    }

    public static short[] ensureCapacity(@Nullable short[] buffer, int capacity) {
        if (buffer == null) {
            buffer = new short[capacity];
        } else if (buffer.length < capacity) {
            buffer = Arrays.copyOf(buffer, capacity);
        }
        return buffer;
    }

    public static int[] ensureCapacity(@Nullable int[] buffer, int capacity) {
        if (buffer == null) {
            buffer = new int[capacity];
        } else if (buffer.length < capacity) {
            buffer = Arrays.copyOf(buffer, capacity);
        }
        return buffer;
    }

    public static long[] ensureCapacity(@Nullable long[] buffer, int capacity) {
        if (buffer == null) {
            buffer = new long[capacity];
        } else if (buffer.length < capacity) {
            buffer = Arrays.copyOf(buffer, capacity);
        }
        return buffer;
    }

    static void appendRawBlockRange(Block rawBlock, int offset, int length, BlockBuilder blockBuilder) {
        Block block = rawBlock = rawBlock.getLoadedBlock();
        Objects.requireNonNull(block);
        Block block2 = block;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RunLengthEncodedBlock.class, DictionaryBlock.class, ValueBlock.class, LazyBlock.class}, (Object)block2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)block2;
                blockBuilder.appendRepeated(rleBlock.getValue(), 0, length);
                break;
            }
            case 1: {
                DictionaryBlock dictionaryBlock = (DictionaryBlock)block2;
                blockBuilder.appendPositions(dictionaryBlock.getDictionary(), dictionaryBlock.getRawIds(), offset, length);
                break;
            }
            case 2: {
                ValueBlock valueBlock = (ValueBlock)block2;
                blockBuilder.appendRange(valueBlock, offset, length);
                break;
            }
            case 3: {
                throw new IllegalStateException("Did not expect LazyBlock after loading " + rawBlock.getClass().getSimpleName());
            }
        }
    }

    static Optional<ByteArrayBlock> getNulls(@Nullable boolean[] valueIsNull, int arrayOffset, int positionCount) {
        if (valueIsNull == null) {
            return Optional.empty();
        }
        byte[] booleansAsBytes = new byte[positionCount];
        boolean foundAnyNull = false;
        for (int i = 0; i < positionCount; ++i) {
            booleansAsBytes[i] = (byte)(valueIsNull[arrayOffset + i] ? 1 : 0);
            foundAnyNull = foundAnyNull || valueIsNull[arrayOffset + i];
        }
        if (!foundAnyNull) {
            return Optional.empty();
        }
        return Optional.of(new ByteArrayBlock(booleansAsBytes.length, Optional.empty(), booleansAsBytes));
    }
}

