/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.Block;
import io.trino.spi.block.ValueBlock;
import java.util.List;
import java.util.Objects;
import java.util.function.ObjLongConsumer;

public class SqlRow {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SqlRow.class);
    private final Block[] fieldBlocks;
    private final List<Block> fieldBlocksList;
    private final int rawIndex;

    public SqlRow(int rawIndex, Block[] fieldBlocks) {
        this.rawIndex = rawIndex;
        this.fieldBlocks = Objects.requireNonNull(fieldBlocks, "fieldBlocks is null");
        this.fieldBlocksList = List.of(fieldBlocks);
    }

    public int getFieldCount() {
        return this.fieldBlocks.length;
    }

    public int getRawIndex() {
        return this.rawIndex;
    }

    public Block getRawFieldBlock(int fieldIndex) {
        return this.fieldBlocks[fieldIndex];
    }

    public List<Block> getRawFieldBlocks() {
        return this.fieldBlocksList;
    }

    public long getSizeInBytes() {
        long sizeInBytes = 0L;
        for (Block fieldBlock : this.fieldBlocks) {
            sizeInBytes += fieldBlock.getRegionSizeInBytes(this.rawIndex, 1);
        }
        return sizeInBytes;
    }

    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = INSTANCE_SIZE;
        for (Block fieldBlock : this.fieldBlocks) {
            retainedSizeInBytes += fieldBlock.getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }

    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        for (Block fieldBlock : this.fieldBlocks) {
            consumer.accept(fieldBlock, fieldBlock.getRetainedSizeInBytes());
        }
        consumer.accept(this, INSTANCE_SIZE);
    }

    public int getUnderlyingFieldPosition(int fieldIndex) {
        return this.fieldBlocks[fieldIndex].getUnderlyingValuePosition(this.rawIndex);
    }

    public ValueBlock getUnderlyingFieldBlock(int fieldIndex) {
        return this.fieldBlocks[fieldIndex].getUnderlyingValueBlock();
    }

    public String toString() {
        return String.format("SqlRow{numFields=%d}", this.fieldBlocks.length);
    }
}

