/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.XxHash64;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.IntArrayBlockBuilder;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.FlatFixed;
import io.trino.spi.function.FlatFixedOffset;
import io.trino.spi.function.FlatVariableWidth;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractLongType;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;

public abstract class AbstractIntType
extends AbstractType
implements FixedWidthType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(AbstractIntType.class, MethodHandles.lookup(), Long.TYPE);
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);

    protected AbstractIntType(TypeSignature signature) {
        super(signature, Long.TYPE, IntArrayBlock.class);
    }

    @Override
    public final int getFixedSize() {
        return 4;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public final long getLong(Block block, int position) {
        return this.getInt(block, position);
    }

    public final int getInt(Block block, int position) {
        return AbstractIntType.readInt((IntArrayBlock)block.getUnderlyingValueBlock(), block.getUnderlyingValuePosition(position));
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        AbstractIntType.checkValueValid(value);
        this.writeInt(blockBuilder, (int)value);
    }

    public BlockBuilder writeInt(BlockBuilder blockBuilder, int value) {
        return ((IntArrayBlockBuilder)blockBuilder).writeInt(value);
    }

    protected static void checkValueValid(long value) {
        if (value > Integer.MAX_VALUE) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Value %d exceeds MAX_INT", value));
        }
        if (value < Integer.MIN_VALUE) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Value %d is less than MIN_INT", value));
        }
    }

    @Override
    public final void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            this.writeInt(blockBuilder, this.getInt(block, position));
        }
    }

    @Override
    public int getFlatFixedSize() {
        return 4;
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new IntArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / 4));
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 4);
    }

    @Override
    public final BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new IntArrayBlockBuilder(null, positionCount);
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static long read(@BlockPosition IntArrayBlock block, @BlockIndex int position) {
        return AbstractIntType.readInt(block, position);
    }

    private static int readInt(IntArrayBlock block, int position) {
        return block.getInt(position);
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static long readFlat(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] unusedVariableSizeSlice) {
        return INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void writeFlat(long value, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] unusedVariableSizeSlice, int unusedVariableSizeOffset) {
        INT_HANDLE.set(fixedSizeSlice, fixedSizeOffset, (int)value);
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(long left, long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    private static long hashCodeOperator(long value) {
        return AbstractLongType.hash((int)value);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(long value) {
        return XxHash64.hash((long)((int)value));
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(long left, long right) {
        return Integer.compare((int)left, (int)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(long left, long right) {
        return (int)left < (int)right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(long left, long right) {
        return (int)left <= (int)right;
    }
}

