/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Node;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import java.util.Set;

public interface NodeManager {
    public Set<Node> getAllNodes();

    public Set<Node> getWorkerNodes();

    public Node getCurrentNode();

    public String getEnvironment();

    default public Set<Node> getRequiredWorkerNodes() {
        Set<Node> nodes = this.getWorkerNodes();
        if (nodes.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query");
        }
        return nodes;
    }
}

