/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import io.airlift.slice.SizeOf;
import io.prestosql.spi.block.AbstractRowBlock;
import io.prestosql.spi.block.Block;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class RowBlock
extends AbstractRowBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(RowBlock.class).instanceSize();
    private final int startOffset;
    private final int positionCount;
    private final boolean[] rowIsNull;
    private final int[] fieldBlockOffsets;
    private final Block[] fieldBlocks;
    private volatile long sizeInBytes = -1L;
    private final long retainedSizeInBytes;

    public static Block fromFieldBlocks(int positionCount, Optional<boolean[]> rowIsNull, Block[] fieldBlocks) {
        int[] fieldBlockOffsets = new int[positionCount + 1];
        for (int position = 0; position < positionCount; ++position) {
            fieldBlockOffsets[position + 1] = fieldBlockOffsets[position] + (rowIsNull.isPresent() && rowIsNull.get()[position] ? 0 : 1);
        }
        RowBlock.validateConstructorArguments(0, positionCount, rowIsNull.orElse(null), fieldBlockOffsets, fieldBlocks);
        return new RowBlock(0, positionCount, rowIsNull.orElse(null), fieldBlockOffsets, fieldBlocks);
    }

    static RowBlock createRowBlockInternal(int startOffset, int positionCount, @Nullable boolean[] rowIsNull, int[] fieldBlockOffsets, Block[] fieldBlocks) {
        RowBlock.validateConstructorArguments(startOffset, positionCount, rowIsNull, fieldBlockOffsets, fieldBlocks);
        return new RowBlock(startOffset, positionCount, rowIsNull, fieldBlockOffsets, fieldBlocks);
    }

    private static void validateConstructorArguments(int startOffset, int positionCount, @Nullable boolean[] rowIsNull, int[] fieldBlockOffsets, Block[] fieldBlocks) {
        if (startOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        if (rowIsNull != null && rowIsNull.length - startOffset < positionCount) {
            throw new IllegalArgumentException("rowIsNull length is less than positionCount");
        }
        Objects.requireNonNull(fieldBlockOffsets, "fieldBlockOffsets is null");
        if (fieldBlockOffsets.length - startOffset < positionCount + 1) {
            throw new IllegalArgumentException("fieldBlockOffsets length is less than positionCount");
        }
        Objects.requireNonNull(fieldBlocks, "fieldBlocks is null");
        if (fieldBlocks.length <= 0) {
            throw new IllegalArgumentException("Number of fields in RowBlock must be positive");
        }
        int firstFieldBlockPositionCount = fieldBlocks[0].getPositionCount();
        for (int i = 1; i < fieldBlocks.length; ++i) {
            if (firstFieldBlockPositionCount == fieldBlocks[i].getPositionCount()) continue;
            throw new IllegalArgumentException(String.format("length of field blocks differ: field 0: %s, block %s: %s", firstFieldBlockPositionCount, i, fieldBlocks[i].getPositionCount()));
        }
    }

    private RowBlock(int startOffset, int positionCount, @Nullable boolean[] rowIsNull, int[] fieldBlockOffsets, Block[] fieldBlocks) {
        super(fieldBlocks.length);
        this.startOffset = startOffset;
        this.positionCount = positionCount;
        this.rowIsNull = rowIsNull;
        this.fieldBlockOffsets = fieldBlockOffsets;
        this.fieldBlocks = fieldBlocks;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])fieldBlockOffsets) + SizeOf.sizeOf((boolean[])rowIsNull);
    }

    @Override
    protected Block[] getRawFieldBlocks() {
        return this.fieldBlocks;
    }

    @Override
    protected int[] getFieldBlockOffsets() {
        return this.fieldBlockOffsets;
    }

    @Override
    protected int getOffsetBase() {
        return this.startOffset;
    }

    @Override
    @Nullable
    protected boolean[] getRowIsNull() {
        return this.rowIsNull;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        if (this.sizeInBytes >= 0L) {
            return this.sizeInBytes;
        }
        long sizeInBytes = this.getBaseSizeInBytes();
        boolean hasUnloadedBlocks = false;
        int startFieldBlockOffset = this.fieldBlockOffsets[this.startOffset];
        int endFieldBlockOffset = this.fieldBlockOffsets[this.startOffset + this.positionCount];
        int fieldBlockLength = endFieldBlockOffset - startFieldBlockOffset;
        for (Block fieldBlock : this.fieldBlocks) {
            sizeInBytes += fieldBlock.getRegionSizeInBytes(startFieldBlockOffset, fieldBlockLength);
            hasUnloadedBlocks = hasUnloadedBlocks || !fieldBlock.isLoaded();
        }
        if (!hasUnloadedBlocks) {
            this.sizeInBytes = sizeInBytes;
        }
        return sizeInBytes;
    }

    private long getBaseSizeInBytes() {
        return 5L * (long)this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = this.retainedSizeInBytes;
        for (Block fieldBlock : this.fieldBlocks) {
            retainedSizeInBytes += fieldBlock.getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        for (int i = 0; i < this.numFields; ++i) {
            consumer.accept(this.fieldBlocks[i], this.fieldBlocks[i].getRetainedSizeInBytes());
        }
        consumer.accept(this.fieldBlockOffsets, SizeOf.sizeOf((int[])this.fieldBlockOffsets));
        consumer.accept(this.rowIsNull, SizeOf.sizeOf((boolean[])this.rowIsNull));
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    public String toString() {
        return String.format("RowBlock{numFields=%d, positionCount=%d}", this.numFields, this.getPositionCount());
    }

    @Override
    public boolean isLoaded() {
        for (Block fieldBlock : this.fieldBlocks) {
            if (fieldBlock.isLoaded()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Block getLoadedBlock() {
        boolean allLoaded = true;
        Block[] loadedFieldBlocks = new Block[this.fieldBlocks.length];
        for (int i = 0; i < this.fieldBlocks.length; ++i) {
            loadedFieldBlocks[i] = this.fieldBlocks[i].getLoadedBlock();
            if (loadedFieldBlocks[i] == this.fieldBlocks[i]) continue;
            allLoaded = false;
        }
        if (allLoaded) {
            return this;
        }
        return RowBlock.createRowBlockInternal(this.startOffset, this.positionCount, this.rowIsNull, this.fieldBlockOffsets, loadedFieldBlocks);
    }
}

