/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BackgroundService {
    @VisibleForTesting
    public static final Logger LOG = LoggerFactory.getLogger(BackgroundService.class);
    private final ScheduledThreadPoolExecutor exec;
    private final ThreadGroup threadGroup;
    private final String serviceName;
    private final long interval;
    private final long serviceTimeoutInNanos;
    private final TimeUnit unit;
    private final PeriodicalTask service;

    public BackgroundService(String serviceName, long interval, TimeUnit unit, int threadPoolSize, long serviceTimeout) {
        this(serviceName, interval, unit, threadPoolSize, serviceTimeout, "");
    }

    public BackgroundService(String serviceName, long interval, TimeUnit unit, int threadPoolSize, long serviceTimeout, String threadNamePrefix) {
        this.interval = interval;
        this.unit = unit;
        this.serviceName = serviceName;
        this.serviceTimeoutInNanos = TimeDuration.valueOf((long)serviceTimeout, (TimeUnit)unit).toLong(TimeUnit.NANOSECONDS);
        this.threadGroup = new ThreadGroup(serviceName);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setThreadFactory(r -> new Thread(this.threadGroup, r)).setDaemon(true).setNameFormat(threadNamePrefix + serviceName + "#%d").build();
        this.exec = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(threadPoolSize, threadFactory);
        this.service = new PeriodicalTask();
    }

    @VisibleForTesting
    public ExecutorService getExecutorService() {
        return this.exec;
    }

    public void setPoolSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Pool size must be positive.");
        }
        this.exec.setCorePoolSize(size);
    }

    @VisibleForTesting
    public int getThreadCount() {
        return this.threadGroup.activeCount();
    }

    @VisibleForTesting
    public void runPeriodicalTaskNow() throws Exception {
        BackgroundTaskQueue tasks = this.getTasks();
        while (tasks.size() > 0) {
            tasks.poll().call();
        }
    }

    public void start() {
        this.exec.scheduleWithFixedDelay(this.service, 0L, this.interval, this.unit);
    }

    public abstract BackgroundTaskQueue getTasks();

    public void shutdown() {
        LOG.info("Shutting down service {}", (Object)this.serviceName);
        this.exec.shutdown();
        try {
            if (!this.exec.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.exec.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.exec.shutdownNow();
        }
        if (this.threadGroup.activeCount() == 0 && !this.threadGroup.isDestroyed()) {
            this.threadGroup.destroy();
        }
    }

    public class PeriodicalTask
    implements Runnable {
        @Override
        public synchronized void run() {
            BackgroundTaskQueue tasks;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running background service : {}", (Object)BackgroundService.this.serviceName);
            }
            if ((tasks = BackgroundService.this.getTasks()).isEmpty()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Number of background tasks to execute : {}", (Object)tasks.size());
            }
            while (tasks.size() > 0) {
                BackgroundTask task = tasks.poll();
                CompletableFuture.runAsync(() -> {
                    long endTime;
                    long startTime;
                    block7: {
                        startTime = System.nanoTime();
                        try {
                            BackgroundTaskResult result = task.call();
                            if (!LOG.isDebugEnabled()) break block7;
                            LOG.debug("task execution result size {}", (Object)result.getSize());
                        }
                        catch (Exception e) {
                            try {
                                LOG.warn("Background task execution failed", (Throwable)e);
                            }
                            catch (Throwable throwable) {
                                long endTime2 = System.nanoTime();
                                if (endTime2 - startTime > BackgroundService.this.serviceTimeoutInNanos) {
                                    LOG.warn("{} Background task execution took {}ns > {}ns(timeout)", new Object[]{BackgroundService.this.serviceName, endTime2 - startTime, BackgroundService.this.serviceTimeoutInNanos});
                                }
                                throw throwable;
                            }
                            long endTime3 = System.nanoTime();
                            if (endTime3 - startTime > BackgroundService.this.serviceTimeoutInNanos) {
                                LOG.warn("{} Background task execution took {}ns > {}ns(timeout)", new Object[]{BackgroundService.this.serviceName, endTime3 - startTime, BackgroundService.this.serviceTimeoutInNanos});
                            }
                        }
                    }
                    if ((endTime = System.nanoTime()) - startTime > BackgroundService.this.serviceTimeoutInNanos) {
                        LOG.warn("{} Background task execution took {}ns > {}ns(timeout)", new Object[]{BackgroundService.this.serviceName, endTime - startTime, BackgroundService.this.serviceTimeoutInNanos});
                    }
                }, BackgroundService.this.exec);
            }
        }
    }
}

