/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ReadOnlyZKClient;
import org.apache.hadoop.hbase.zookeeper.ZKMetadata;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@InterfaceAudience.LimitedPrivate(value={"Configuration"})
class ZKConnectionRegistry
implements ConnectionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ZKConnectionRegistry.class);
    private static final Object WARN_LOCK = new Object();
    private static volatile boolean NEEDS_LOG_WARN = true;
    private final ReadOnlyZKClient zk;
    private final ZNodePaths znodePaths;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ZKConnectionRegistry(Configuration conf, User ignored) {
        this.znodePaths = new ZNodePaths(conf);
        this.zk = new ReadOnlyZKClient(conf);
        if (NEEDS_LOG_WARN) {
            Object object = WARN_LOCK;
            synchronized (object) {
                if (NEEDS_LOG_WARN) {
                    LOG.warn("ZKConnectionRegistry is deprecated. See https://hbase.apache.org/book.html#client.rpcconnectionregistry");
                    NEEDS_LOG_WARN = false;
                }
            }
        }
    }

    private <T> CompletableFuture<T> getAndConvert(String path, Converter<T> converter) {
        CompletableFuture future = new CompletableFuture();
        FutureUtils.addListener(this.zk.get(path), (data, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            try {
                future.complete(converter.convert((byte[])data));
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private static String getClusterId(byte[] data) throws DeserializationException {
        if (data == null || data.length == 0) {
            return null;
        }
        data = ZKMetadata.removeMetaData(data);
        return ClusterId.parseFrom(data).toString();
    }

    @Override
    public CompletableFuture<String> getClusterId() {
        return TraceUtil.tracedFuture(() -> this.getAndConvert(this.znodePaths.clusterIdZNode, ZKConnectionRegistry::getClusterId), (String)"ZKConnectionRegistry.getClusterId");
    }

    ReadOnlyZKClient getZKClient() {
        return this.zk;
    }

    private static ZooKeeperProtos.MetaRegionServer getMetaProto(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return null;
        }
        data = ZKMetadata.removeMetaData(data);
        int prefixLen = ProtobufUtil.lengthOfPBMagic();
        return (ZooKeeperProtos.MetaRegionServer)ZooKeeperProtos.MetaRegionServer.parser().parseFrom(data, prefixLen, data.length - prefixLen);
    }

    private static void tryComplete(MutableInt remaining, Collection<HRegionLocation> locs, CompletableFuture<RegionLocations> future) {
        remaining.decrement();
        if (remaining.intValue() > 0) {
            return;
        }
        future.complete(new RegionLocations(locs));
    }

    private Pair<RegionState.State, ServerName> getStateAndServerName(ZooKeeperProtos.MetaRegionServer proto) {
        RegionState.State state = proto.hasState() ? RegionState.State.convert(proto.getState()) : RegionState.State.OPEN;
        HBaseProtos.ServerName snProto = proto.getServer();
        return Pair.newPair((Object)((Object)state), (Object)ServerName.valueOf((String)snProto.getHostName(), (int)snProto.getPort(), (long)snProto.getStartCode()));
    }

    private void getMetaRegionLocation(CompletableFuture<RegionLocations> future, List<String> metaReplicaZNodes) {
        if (metaReplicaZNodes.isEmpty()) {
            future.completeExceptionally(new IOException("No meta znode available"));
        }
        TreeMap locs = new TreeMap();
        MutableInt remaining = new MutableInt(metaReplicaZNodes.size());
        for (String metaReplicaZNode : metaReplicaZNodes) {
            int replicaId = this.znodePaths.getMetaReplicaIdFromZNode(metaReplicaZNode);
            String path = ZNodePaths.joinZNode(this.znodePaths.baseZNode, metaReplicaZNode);
            if (replicaId == 0) {
                FutureUtils.addListener(this.getAndConvert(path, ZKConnectionRegistry::getMetaProto), (proto, error) -> {
                    if (error != null) {
                        future.completeExceptionally((Throwable)error);
                        return;
                    }
                    if (proto == null) {
                        future.completeExceptionally(new IOException("Meta znode is null"));
                        return;
                    }
                    Pair<RegionState.State, ServerName> stateAndServerName = this.getStateAndServerName((ZooKeeperProtos.MetaRegionServer)proto);
                    if (stateAndServerName.getFirst() != RegionState.State.OPEN) {
                        LOG.warn("Meta region is in state " + stateAndServerName.getFirst());
                    }
                    locs.put(replicaId, new HRegionLocation(RegionReplicaUtil.getRegionInfoForDefaultReplica(RegionInfoBuilder.FIRST_META_REGIONINFO), (ServerName)stateAndServerName.getSecond()));
                    ZKConnectionRegistry.tryComplete(remaining, locs.values(), future);
                });
                continue;
            }
            FutureUtils.addListener(this.getAndConvert(path, ZKConnectionRegistry::getMetaProto), (proto, error) -> {
                if (future.isDone()) {
                    return;
                }
                if (error != null) {
                    LOG.warn("Failed to fetch " + path, error);
                    locs.put(replicaId, null);
                } else if (proto == null) {
                    LOG.warn("Meta znode for replica " + replicaId + " is null");
                    locs.put(replicaId, null);
                } else {
                    Pair<RegionState.State, ServerName> stateAndServerName = this.getStateAndServerName((ZooKeeperProtos.MetaRegionServer)proto);
                    if (stateAndServerName.getFirst() != RegionState.State.OPEN) {
                        LOG.warn("Meta region for replica " + replicaId + " is in state " + stateAndServerName.getFirst());
                        locs.put(replicaId, null);
                    } else {
                        locs.put(replicaId, new HRegionLocation(RegionReplicaUtil.getRegionInfoForReplica(RegionInfoBuilder.FIRST_META_REGIONINFO, replicaId), (ServerName)stateAndServerName.getSecond()));
                    }
                }
                ZKConnectionRegistry.tryComplete(remaining, locs.values(), future);
            });
        }
    }

    @Override
    public CompletableFuture<RegionLocations> getMetaRegionLocations() {
        return TraceUtil.tracedFuture(() -> {
            CompletableFuture future = new CompletableFuture();
            FutureUtils.addListener((CompletableFuture)this.zk.list(this.znodePaths.baseZNode).thenApply(children -> children.stream().filter(c -> this.znodePaths.isMetaZNodePrefix((String)c)).collect(Collectors.toList())), (metaReplicaZNodes, error) -> {
                if (error != null) {
                    future.completeExceptionally((Throwable)error);
                    return;
                }
                this.getMetaRegionLocation(future, (List<String>)metaReplicaZNodes);
            });
            return future;
        }, (String)"ZKConnectionRegistry.getMetaRegionLocations");
    }

    private static ZooKeeperProtos.Master getMasterProto(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return null;
        }
        data = ZKMetadata.removeMetaData(data);
        int prefixLen = ProtobufUtil.lengthOfPBMagic();
        return (ZooKeeperProtos.Master)ZooKeeperProtos.Master.parser().parseFrom(data, prefixLen, data.length - prefixLen);
    }

    @Override
    public CompletableFuture<ServerName> getActiveMaster() {
        return TraceUtil.tracedFuture(() -> this.getAndConvert(this.znodePaths.masterAddressZNode, ZKConnectionRegistry::getMasterProto).thenApply(proto -> {
            if (proto == null) {
                return null;
            }
            HBaseProtos.ServerName snProto = proto.getMaster();
            return ServerName.valueOf((String)snProto.getHostName(), (int)snProto.getPort(), (long)snProto.getStartCode());
        }), (String)"ZKConnectionRegistry.getActiveMaster");
    }

    @Override
    public String getConnectionString() {
        String serverList = this.zk.getConnectString();
        String baseZNode = this.znodePaths.baseZNode;
        return serverList + ":" + baseZNode;
    }

    @Override
    public void close() {
        this.zk.close();
    }

    private static interface Converter<T> {
        public T convert(byte[] var1) throws Exception;
    }
}

