/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.lock;

import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OMLockDetails {
    public static final OMLockDetails EMPTY_DETAILS_LOCK_ACQUIRED = new OMLockDetails(true);
    public static final OMLockDetails EMPTY_DETAILS_LOCK_NOT_ACQUIRED = new OMLockDetails(false);
    private boolean lockAcquired;
    private long waitLockNanos;
    private long readLockNanos;
    private long writeLockNanos;

    public OMLockDetails() {
    }

    public OMLockDetails(boolean lockAcquired) {
        this.lockAcquired = lockAcquired;
    }

    public void add(long timeNanos, LockOpType lockOpType) {
        switch (lockOpType) {
            case WAIT: {
                this.waitLockNanos += timeNanos;
                break;
            }
            case READ: {
                this.readLockNanos += timeNanos;
                break;
            }
            case WRITE: {
                this.writeLockNanos += timeNanos;
                break;
            }
        }
    }

    public void merge(OMLockDetails omLockDetails) {
        this.lockAcquired = omLockDetails.isLockAcquired();
        this.waitLockNanos += omLockDetails.getWaitLockNanos();
        this.readLockNanos += omLockDetails.getReadLockNanos();
        this.writeLockNanos += omLockDetails.getWriteLockNanos();
    }

    public long getWaitLockNanos() {
        return this.waitLockNanos;
    }

    public void setWaitLockNanos(long waitLockNanos) {
        this.waitLockNanos = waitLockNanos;
    }

    public long getReadLockNanos() {
        return this.readLockNanos;
    }

    public void setReadLockNanos(long readLockNanos) {
        this.readLockNanos = readLockNanos;
    }

    public long getWriteLockNanos() {
        return this.writeLockNanos;
    }

    public void setWriteLockNanos(long writeLockNanos) {
        this.writeLockNanos = writeLockNanos;
    }

    public boolean isLockAcquired() {
        return this.lockAcquired;
    }

    public void setLockAcquired(boolean lockAcquired) {
        this.lockAcquired = lockAcquired;
    }

    public OzoneManagerProtocolProtos.OMLockDetailsProto.Builder toProtobufBuilder() {
        return OzoneManagerProtocolProtos.OMLockDetailsProto.newBuilder().setIsLockAcquired(this.isLockAcquired()).setWaitLockNanos(this.getWaitLockNanos()).setReadLockNanos(this.getReadLockNanos()).setWriteLockNanos(this.getWriteLockNanos());
    }

    public String toString() {
        return "OMLockDetails{lockAcquired=" + this.lockAcquired + ", waitLockNanos=" + this.waitLockNanos + ", readLockNanos=" + this.readLockNanos + ", writeLockNanos=" + this.writeLockNanos + '}';
    }

    public void clear() {
        this.lockAcquired = false;
        this.waitLockNanos = 0L;
        this.readLockNanos = 0L;
        this.writeLockNanos = 0L;
    }

    static enum LockOpType {
        WAIT,
        READ,
        WRITE;

    }
}

