/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.CatalogReplicaMode;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseServerException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorImpl;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.CatalogReplicaLoadBalanceSelector;
import org.apache.hadoop.hbase.client.CatalogReplicaLoadBalanceSelectorFactory;
import org.apache.hadoop.hbase.client.CatalogReplicaLoadBalanceSimpleSelector;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ClusterStatusListener;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.ConnectionRegistryFactory;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HBaseHbck;
import org.apache.hadoop.hbase.client.HRegionLocator;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Hbck;
import org.apache.hadoop.hbase.client.LockTimeoutException;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.MetaCache;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.PerClientRandomNonceGenerator;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptor;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptorFactory;
import org.apache.hadoop.hbase.client.ReversedClientScanner;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.hadoop.hbase.client.TableBuilderBase;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicyFactory;
import org.apache.hadoop.hbase.client.trace.TableOperationSpanBuilder;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.BootstrapNodeProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.trace.HBaseSemanticAttributes;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hbase.thirdparty.com.google.common.base.Suppliers;
import org.apache.hbase.thirdparty.com.google.common.base.Throwables;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingRpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@SuppressWarnings(value={"AT_OPERATION_SEQUENCE_ON_CONCURRENT_ABSTRACTION"}, justification="Access to the conncurrent hash map is under a lock so should be fine.")
public class ConnectionImplementation
implements ClusterConnection,
Closeable {
    public static final String RETRIES_BY_SERVER_KEY = "hbase.client.retries.by.server";
    public static final String MASTER_STATE_CACHE_TIMEOUT_SEC = "hbase.client.master.state.cache.timeout.sec";
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionImplementation.class);
    private CatalogReplicaMode metaReplicaMode;
    private CatalogReplicaLoadBalanceSelector metaReplicaSelector;
    private final int metaReplicaCallTimeoutScanInMicroSecond;
    private final int numTries;
    final int rpcTimeout;
    private static volatile NonceGenerator nonceGenerator = null;
    private static final Object nonceGeneratorCreateLock = new Object();
    private final AsyncProcess asyncProcess;
    private final ServerStatisticTracker stats;
    private volatile boolean closed;
    private volatile boolean aborted;
    ClusterStatusListener clusterStatusListener;
    private final Object metaRegionLock = new Object();
    private final Object masterLock = new Object();
    private volatile ThreadPoolExecutor batchPool = null;
    private volatile ThreadPoolExecutor metaLookupPool = null;
    private volatile boolean cleanupPool = false;
    private final Configuration conf;
    private final ConnectionConfiguration connectionConfig;
    private final RpcClient rpcClient;
    private final MetaCache metaCache;
    private String metricsScope = null;
    private final MetricsConnection metrics;
    protected User user;
    private final RpcRetryingCallerFactory rpcCallerFactory;
    private final RpcControllerFactory rpcControllerFactory;
    private final RetryingCallerInterceptor interceptor;
    private final ConnectionRegistry registry;
    private final ClientBackoffPolicy backoffPolicy;
    private final String alternateBufferedMutatorClassName;
    private final ReentrantLock userRegionLock = new ReentrantLock();
    private final Supplier<Boolean> masterStateSupplier;
    private ChoreService choreService;
    protected String clusterId = null;
    private final ConcurrentMap<String, Object> stubs = new ConcurrentHashMap<String, Object>();
    final MasterServiceState masterServiceState = new MasterServiceState(this);

    ConnectionImplementation(Configuration conf, ExecutorService pool, User user) throws IOException {
        this(conf, pool, user, null, Collections.emptyMap());
    }

    ConnectionImplementation(Configuration conf, ExecutorService pool, User user, Map<String, byte[]> connectionAttributes) throws IOException {
        this(conf, pool, user, null, connectionAttributes);
    }

    ConnectionImplementation(Configuration conf, ExecutorService pool, User user, ConnectionRegistry registry) throws IOException {
        this(conf, pool, user, registry, Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionImplementation(Configuration conf, ExecutorService pool, User user, ConnectionRegistry registry, Map<String, byte[]> connectionAttributes) throws IOException {
        this.conf = conf;
        this.user = user;
        if (user != null && user.isLoginFromKeytab()) {
            this.spawnRenewalChore(user.getUGI());
        }
        this.batchPool = (ThreadPoolExecutor)pool;
        this.connectionConfig = new ConnectionConfiguration(conf);
        this.closed = false;
        this.metaReplicaCallTimeoutScanInMicroSecond = this.connectionConfig.getMetaReplicaCallTimeoutMicroSecondScan();
        this.numTries = ConnectionUtils.retries2Attempts(this.connectionConfig.getRetriesNumber());
        this.rpcTimeout = conf.getInt("hbase.rpc.timeout", 60000);
        if (conf.getBoolean("hbase.client.nonces.enabled", true)) {
            Object object = nonceGeneratorCreateLock;
            synchronized (object) {
                if (nonceGenerator == null) {
                    nonceGenerator = PerClientRandomNonceGenerator.get();
                }
            }
        } else {
            nonceGenerator = ConnectionUtils.NO_NONCE_GENERATOR;
        }
        this.stats = ServerStatisticTracker.create(conf);
        this.interceptor = new RetryingCallerInterceptorFactory(conf).build();
        this.backoffPolicy = ClientBackoffPolicyFactory.create(conf);
        boolean shouldListen = conf.getBoolean("hbase.status.published", false);
        Class<ClusterStatusListener.Listener> listenerClass = conf.getClass("hbase.status.listener.class", ClusterStatusListener.DEFAULT_STATUS_LISTENER_CLASS, ClusterStatusListener.Listener.class);
        this.alternateBufferedMutatorClassName = this.conf.get("hbase.client.bufferedmutator.classname");
        try {
            this.registry = registry == null ? ConnectionRegistryFactory.getRegistry(conf, user) : registry;
            this.retrieveClusterId();
            if (conf.getBoolean("hbase.client.metrics.enable", false)) {
                this.metricsScope = MetricsConnection.getScope(conf, this.clusterId, this);
                this.metrics = MetricsConnection.getMetricsConnection(conf, this.metricsScope, this::getBatchPool, this::getMetaLookupPool);
            } else {
                this.metrics = null;
            }
            this.metaCache = new MetaCache(this.metrics);
            this.rpcClient = RpcClientFactory.createClient(this.conf, this.clusterId, this.metrics, connectionAttributes);
            this.rpcControllerFactory = RpcControllerFactory.instantiate(conf);
            this.rpcCallerFactory = RpcRetryingCallerFactory.instantiate(conf, this.connectionConfig, this.interceptor, this.stats, this.metrics);
            this.asyncProcess = new AsyncProcess(this, conf, this.rpcCallerFactory, this.rpcControllerFactory);
            if (shouldListen) {
                if (listenerClass == null) {
                    LOG.warn("hbase.status.published is true, but hbase.status.listener.class is not set - not listening status");
                } else {
                    this.clusterStatusListener = new ClusterStatusListener(new ClusterStatusListener.DeadServerHandler(){

                        @Override
                        public void newDead(ServerName sn) {
                            ConnectionImplementation.this.clearCaches(sn);
                            ConnectionImplementation.this.rpcClient.cancelConnections(sn);
                        }
                    }, conf, listenerClass);
                }
            }
        }
        catch (Throwable e) {
            LOG.debug("connection construction failed", e);
            this.close();
            throw e;
        }
        this.metaReplicaMode = CatalogReplicaMode.fromString(conf.get("hbase.locator.meta.replicas.mode", CatalogReplicaMode.NONE.toString()));
        switch (this.metaReplicaMode) {
            case LOAD_BALANCE: {
                String replicaSelectorClass = conf.get("hbase.locator.meta.replicas.mode.loadbalance.selector", CatalogReplicaLoadBalanceSimpleSelector.class.getName());
                this.metaReplicaSelector = CatalogReplicaLoadBalanceSelectorFactory.createSelector(replicaSelectorClass, TableName.META_TABLE_NAME, this.getChoreService(), () -> {
                    int numOfReplicas = 1;
                    try {
                        RegionLocations metaLocations = this.registry.getMetaRegionLocations().get(this.connectionConfig.getReadRpcTimeout(), TimeUnit.MILLISECONDS);
                        numOfReplicas = metaLocations.size();
                    }
                    catch (Exception e) {
                        LOG.error("Failed to get table {}'s region replication, ", (Object)TableName.META_TABLE_NAME, (Object)e);
                    }
                    return numOfReplicas;
                });
                break;
            }
            case NONE: {
                boolean useMetaReplicas = conf.getBoolean("hbase.meta.replicas.use", false);
                if (!useMetaReplicas) break;
                this.metaReplicaMode = CatalogReplicaMode.HEDGED_READ;
                break;
            }
        }
        long masterStateCacheTimeout = conf.getLong(MASTER_STATE_CACHE_TIMEOUT_SEC, 0L);
        Supplier<Boolean> masterConnSupplier = this.masterConnectionStateSupplier();
        this.masterStateSupplier = masterStateCacheTimeout <= 0L ? masterConnSupplier : Suppliers.memoizeWithExpiration(masterConnSupplier::get, masterStateCacheTimeout, TimeUnit.SECONDS);
    }

    Supplier<Boolean> masterConnectionStateSupplier() {
        return () -> {
            if (this.masterServiceState.getStub() == null) {
                return false;
            }
            try {
                LOG.trace("Getting master state using rpc call");
                return this.masterServiceState.isMasterRunning();
            }
            catch (UndeclaredThrowableException e) {
                LOG.info("Master connection is not running anymore", e.getUndeclaredThrowable());
                return false;
            }
            catch (IOException se) {
                LOG.warn("Checking master connection", (Throwable)se);
                return false;
            }
        };
    }

    private void spawnRenewalChore(UserGroupInformation user) {
        ChoreService service = this.getChoreService();
        service.scheduleChore(AuthUtil.getAuthRenewalChore(user, this.conf));
    }

    static NonceGenerator injectNonceGeneratorForTesting(ClusterConnection conn, NonceGenerator cnm) {
        ConnectionImplementation connImpl = (ConnectionImplementation)conn;
        NonceGenerator ng = connImpl.getNonceGenerator();
        LOG.warn("Nonce generator is being replaced by test code for " + cnm.getClass().getName());
        nonceGenerator = cnm;
        return ng;
    }

    @Override
    public Table getTable(TableName tableName) throws IOException {
        return this.getTable(tableName, this.getBatchPool());
    }

    @Override
    public TableBuilder getTableBuilder(TableName tableName, final ExecutorService pool) {
        return new TableBuilderBase(tableName, this.connectionConfig){

            @Override
            public Table build() {
                return new HTable(ConnectionImplementation.this, this, ConnectionImplementation.this.rpcCallerFactory, ConnectionImplementation.this.rpcControllerFactory, pool, this.requestAttributes);
            }
        };
    }

    @Override
    public BufferedMutator getBufferedMutator(BufferedMutatorParams params) {
        String implementationClassName;
        if (params.getTableName() == null) {
            throw new IllegalArgumentException("TableName cannot be null.");
        }
        if (params.getWriteBufferSize() == -1L) {
            params.writeBufferSize(this.connectionConfig.getWriteBufferSize());
        }
        if (params.getWriteBufferPeriodicFlushTimeoutMs() == -1L) {
            params.setWriteBufferPeriodicFlushTimeoutMs(this.connectionConfig.getWriteBufferPeriodicFlushTimeoutMs());
        }
        if (params.getWriteBufferPeriodicFlushTimerTickMs() == -1L) {
            params.setWriteBufferPeriodicFlushTimerTickMs(this.connectionConfig.getWriteBufferPeriodicFlushTimerTickMs());
        }
        if (params.getMaxKeyValueSize() == -1) {
            params.maxKeyValueSize(this.connectionConfig.getMaxKeyValueSize());
        }
        if ((implementationClassName = params.getImplementationClassName()) == null) {
            implementationClassName = this.alternateBufferedMutatorClassName;
        }
        if (implementationClassName == null) {
            return new BufferedMutatorImpl(this, this.rpcCallerFactory, this.rpcControllerFactory, params);
        }
        try {
            return (BufferedMutator)ReflectionUtils.newInstance(Class.forName(implementationClassName), this, this.rpcCallerFactory, this.rpcControllerFactory, params);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BufferedMutator getBufferedMutator(TableName tableName) {
        return this.getBufferedMutator(new BufferedMutatorParams(tableName));
    }

    @Override
    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        return new HRegionLocator(tableName, this);
    }

    @Override
    public Admin getAdmin() throws IOException {
        return new HBaseAdmin(this);
    }

    @Override
    public Hbck getHbck() throws IOException {
        return TraceUtil.trace(() -> this.getHbck(ConnectionImplementation.get(this.registry.getActiveMaster())), () -> TraceUtil.createSpan(this.getClass().getSimpleName() + ".getHbck"));
    }

    @Override
    public Hbck getHbck(ServerName masterServer) throws IOException {
        return TraceUtil.trace(() -> {
            this.checkClosed();
            if (this.isDeadServer(masterServer)) {
                throw new RegionServerStoppedException(masterServer + " is dead.");
            }
            String key = ConnectionUtils.getStubKey(MasterProtos.HbckService.BlockingInterface.class.getName(), masterServer);
            return new HBaseHbck((MasterProtos.HbckService.BlockingInterface)ConcurrentMapUtils.computeIfAbsentEx(this.stubs, key, () -> {
                BlockingRpcChannel channel = this.rpcClient.createBlockingRpcChannel(masterServer, this.user, this.rpcTimeout);
                return MasterProtos.HbckService.newBlockingStub(channel);
            }), this.rpcControllerFactory);
        }, () -> TraceUtil.createSpan(this.getClass().getSimpleName() + ".getHbck").setAttribute(HBaseSemanticAttributes.SERVER_NAME_KEY, (Object)masterServer.getServerName()));
    }

    @Override
    public MetricsConnection getConnectionMetrics() {
        return this.metrics;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public ConnectionRegistry getConnectionRegistry() {
        return this.registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadPoolExecutor getBatchPool() {
        if (this.batchPool == null) {
            ConnectionImplementation connectionImplementation = this;
            synchronized (connectionImplementation) {
                if (this.batchPool == null) {
                    int threads = this.conf.getInt("hbase.hconnection.threads.max", 256);
                    this.batchPool = this.getThreadPool(threads, threads, "-shared", null);
                    this.cleanupPool = true;
                }
            }
        }
        return this.batchPool;
    }

    private ThreadPoolExecutor getThreadPool(int maxThreads, int coreThreads, String nameHint, BlockingQueue<Runnable> passedWorkQueue) {
        if (maxThreads == 0) {
            maxThreads = Runtime.getRuntime().availableProcessors() * 8;
        }
        if (coreThreads == 0) {
            coreThreads = Runtime.getRuntime().availableProcessors() * 8;
        }
        long keepAliveTime = this.conf.getLong("hbase.hconnection.threads.keepalivetime", 60L);
        BlockingQueue<Runnable> workQueue = passedWorkQueue;
        if (workQueue == null) {
            workQueue = new LinkedBlockingQueue<Runnable>(maxThreads * this.conf.getInt("hbase.client.max.total.tasks", 100));
            coreThreads = maxThreads;
        }
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveTime, TimeUnit.SECONDS, workQueue, new ThreadFactoryBuilder().setDaemon(true).setNameFormat(this.toString() + nameHint + "-pool-%d").setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build());
        tpe.allowCoreThreadTimeOut(true);
        return tpe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadPoolExecutor getMetaLookupPool() {
        if (this.metaLookupPool == null) {
            ConnectionImplementation connectionImplementation = this;
            synchronized (connectionImplementation) {
                if (this.metaLookupPool == null) {
                    int threads = this.conf.getInt("hbase.hconnection.meta.lookup.threads.max", 128);
                    this.metaLookupPool = this.getThreadPool(threads, threads, "-metaLookup-shared-", new LinkedBlockingQueue<Runnable>());
                }
            }
        }
        return this.metaLookupPool;
    }

    protected ExecutorService getCurrentMetaLookupPool() {
        return this.metaLookupPool;
    }

    protected ExecutorService getCurrentBatchPool() {
        return this.batchPool;
    }

    private void shutdownPools() {
        if (this.cleanupPool && this.batchPool != null && !this.batchPool.isShutdown()) {
            this.shutdownBatchPool(this.batchPool);
        }
        if (this.metaLookupPool != null && !this.metaLookupPool.isShutdown()) {
            this.shutdownBatchPool(this.metaLookupPool);
        }
    }

    private void shutdownBatchPool(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(10L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            pool.shutdownNow();
        }
    }

    RpcClient getRpcClient() {
        return this.rpcClient;
    }

    public String toString() {
        return "hconnection-0x" + Integer.toHexString(this.hashCode());
    }

    protected void retrieveClusterId() {
        if (this.clusterId != null) {
            return;
        }
        try {
            this.clusterId = this.registry.getClusterId().get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Retrieve cluster id failed", (Throwable)e);
        }
        if (this.clusterId == null) {
            this.clusterId = "default-cluster";
            LOG.debug("clusterid came back null, using default " + this.clusterId);
        }
    }

    synchronized ChoreService getChoreService() {
        if (this.choreService == null) {
            this.choreService = new ChoreService("AsyncConn Chore Service");
        }
        return this.choreService;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    private void checkClosed() throws LocalConnectionClosedException {
        if (this.closed) {
            throw new LocalConnectionClosedException(this.toString() + " closed");
        }
    }

    @Override
    @Deprecated
    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        MasterKeepAliveConnection m;
        try {
            m = this.getKeepAliveMasterService();
        }
        catch (IOException e) {
            throw new MasterNotRunningException(e);
        }
        m.close();
        return true;
    }

    @Override
    public HRegionLocation getRegionLocation(TableName tableName, byte[] row, boolean reload) throws IOException {
        return reload ? this.relocateRegion(tableName, row) : this.locateRegion(tableName, row);
    }

    @Override
    public boolean isTableEnabled(TableName tableName) throws IOException {
        return this.getTableState(tableName).inStates(TableState.State.ENABLED);
    }

    @Override
    public boolean isTableDisabled(TableName tableName) throws IOException {
        return this.getTableState(tableName).inStates(TableState.State.DISABLED);
    }

    @Override
    public boolean isTableAvailable(TableName tableName, @Nullable byte[][] splitKeys) throws IOException {
        this.checkClosed();
        try {
            if (!this.isTableEnabled(tableName)) {
                LOG.debug("Table {} not enabled", (Object)tableName);
                return false;
            }
            if (TableName.isMetaTableName(tableName)) {
                return true;
            }
            List<Pair<RegionInfo, ServerName>> locations = MetaTableAccessor.getTableRegionsAndLocations(this, tableName, true);
            int notDeployed = 0;
            int regionCount = 0;
            block2: for (Pair<RegionInfo, ServerName> pair : locations) {
                RegionInfo info = pair.getFirst();
                if (pair.getSecond() == null) {
                    LOG.debug("Table {} has not deployed region {}", (Object)tableName, (Object)pair.getFirst().getEncodedName());
                    ++notDeployed;
                    continue;
                }
                if (splitKeys != null && !Bytes.equals(info.getStartKey(), HConstants.EMPTY_BYTE_ARRAY)) {
                    for (byte[] splitKey : splitKeys) {
                        if (!Bytes.equals(info.getStartKey(), splitKey)) continue;
                        ++regionCount;
                        continue block2;
                    }
                    continue;
                }
                ++regionCount;
            }
            if (notDeployed > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Table {} has {} regions not deployed", (Object)tableName, (Object)notDeployed);
                }
                return false;
            }
            if (splitKeys != null && regionCount != splitKeys.length + 1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Table {} expected to have {} regions, but only {} available", new Object[]{tableName, splitKeys.length + 1, regionCount});
                }
                return false;
            }
            LOG.trace("Table {} should be available", (Object)tableName);
            return true;
        }
        catch (TableNotFoundException tnfe) {
            LOG.warn("Table {} does not exist", (Object)tableName);
            return false;
        }
    }

    @Override
    public HRegionLocation locateRegion(byte[] regionName) throws IOException {
        RegionLocations locations = this.locateRegion(RegionInfo.getTable(regionName), RegionInfo.getStartKey(regionName), false, true);
        return locations == null ? null : locations.getRegionLocation();
    }

    private boolean isDeadServer(ServerName sn) {
        if (this.clusterStatusListener == null) {
            return false;
        }
        return this.clusterStatusListener.isDeadServer(sn);
    }

    @Override
    public List<HRegionLocation> locateRegions(TableName tableName) throws IOException {
        return this.locateRegions(tableName, false, true);
    }

    @Override
    public List<HRegionLocation> locateRegions(TableName tableName, boolean useCache, boolean offlined) throws IOException {
        List<RegionInfo> regions = TableName.isMetaTableName(tableName) ? Collections.singletonList(RegionInfoBuilder.FIRST_META_REGIONINFO) : MetaTableAccessor.getTableRegions(this, tableName, !offlined);
        ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>();
        for (RegionInfo regionInfo : regions) {
            RegionLocations list;
            if (!RegionReplicaUtil.isDefaultReplica(regionInfo) || (list = this.locateRegion(tableName, regionInfo.getStartKey(), useCache, true)) == null) continue;
            for (HRegionLocation loc : list.getRegionLocations()) {
                if (loc == null) continue;
                locations.add(loc);
            }
        }
        return locations;
    }

    @Override
    public HRegionLocation locateRegion(TableName tableName, byte[] row) throws IOException {
        RegionLocations locations = this.locateRegion(tableName, row, true, true);
        return locations == null ? null : locations.getRegionLocation();
    }

    @Override
    public HRegionLocation relocateRegion(TableName tableName, byte[] row) throws IOException {
        RegionLocations locations = this.relocateRegion(tableName, row, 0);
        return locations == null ? null : locations.getRegionLocation(0);
    }

    @Override
    public RegionLocations relocateRegion(TableName tableName, byte[] row, int replicaId) throws IOException {
        if (!tableName.equals(TableName.META_TABLE_NAME) && this.isTableDisabled(tableName)) {
            throw new TableNotEnabledException(tableName.getNameAsString() + " is disabled.");
        }
        return this.locateRegion(tableName, row, false, true, replicaId);
    }

    @Override
    public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry) throws IOException {
        return this.locateRegion(tableName, row, useCache, retry, 0);
    }

    @Override
    public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry, int replicaId) throws IOException {
        this.checkClosed();
        if (tableName == null || tableName.getName().length == 0) {
            throw new IllegalArgumentException("table name cannot be null or zero length");
        }
        if (tableName.equals(TableName.META_TABLE_NAME)) {
            return this.locateMeta(tableName, useCache, replicaId);
        }
        return this.locateRegionInMeta(tableName, row, useCache, retry, replicaId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionLocations locateMeta(TableName tableName, boolean useCache, int replicaId) throws IOException {
        byte[] metaCacheKey = HConstants.EMPTY_START_ROW;
        RegionLocations locations = null;
        if (useCache && (locations = this.getCachedLocation(tableName, metaCacheKey)) != null && locations.getRegionLocation(replicaId) != null) {
            return locations;
        }
        Object object = this.metaRegionLock;
        synchronized (object) {
            if (useCache && (locations = this.getCachedLocation(tableName, metaCacheKey)) != null && locations.getRegionLocation(replicaId) != null) {
                return locations;
            }
            locations = ConnectionImplementation.get(this.registry.getMetaRegionLocations());
            if (locations != null) {
                this.cacheLocation(tableName, locations);
            }
        }
        return locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private RegionLocations locateRegionInMeta(TableName tableName, byte[] row, boolean useCache, boolean retry, int replicaId) throws IOException {
        RegionLocations locations;
        if (useCache && (locations = this.getCachedLocation(tableName, row)) != null && locations.getRegionLocation(replicaId) != null) {
            return locations;
        }
        byte[] metaStartKey = RegionInfo.createRegionName(tableName, row, "99999999999999", false);
        byte[] metaStopKey = RegionInfo.createRegionName(tableName, HConstants.EMPTY_START_ROW, "", false);
        Scan s = new Scan().withStartRow(metaStartKey).withStopRow(metaStopKey, true).addFamily(HConstants.CATALOG_FAMILY).setReversed(true).setCaching(1).setReadType(Scan.ReadType.PREAD);
        switch (this.metaReplicaMode) {
            case LOAD_BALANCE: {
                int metaReplicaId = this.metaReplicaSelector.select(tableName, row, RegionLocateType.CURRENT);
                if (metaReplicaId == 0) break;
                s.setConsistency(Consistency.TIMELINE);
                s.setReplicaId(metaReplicaId);
                break;
            }
            case HEDGED_READ: {
                s.setConsistency(Consistency.TIMELINE);
                break;
            }
        }
        int maxAttempts = retry ? this.numTries : 1;
        boolean relocateMeta = false;
        int tries = 0;
        while (true) {
            RegionLocations regionLocations;
            Throwable throwable;
            ReversedClientScanner rcs;
            Throwable throwable2;
            Scope ignored;
            boolean lockedUserRegion;
            long lockStartTime;
            long pauseBase;
            block67: {
                block68: {
                    block65: {
                        block66: {
                            RegionInfo regionInfo;
                            RegionLocations locations2;
                            block64: {
                                if (tries >= maxAttempts) {
                                    throw new NoServerForRegionException("Unable to find region for " + Bytes.toStringBinary(row) + " in " + tableName + " after " + tries + " tries.");
                                }
                                if (useCache) {
                                    RegionLocations locations3 = this.getCachedLocation(tableName, row);
                                    if (locations3 != null && locations3.getRegionLocation(replicaId) != null) {
                                        return locations3;
                                    }
                                } else {
                                    this.metaCache.clearCache(tableName, row, replicaId);
                                }
                                pauseBase = this.connectionConfig.getPauseMillis();
                                lockStartTime = 0L;
                                lockedUserRegion = false;
                                this.takeUserRegionLock();
                                lockStartTime = EnvironmentEdgeManager.currentTime();
                                lockedUserRegion = true;
                                locations2 = this.getCachedLocation(tableName, row);
                                if (locations2 == null || locations2.getRegionLocation(replicaId) == null) break block64;
                                RegionLocations regionLocations2 = locations2;
                                if (lockedUserRegion) {
                                    this.userRegionLock.unlock();
                                    if (this.metrics != null) {
                                        this.metrics.updateUserRegionLockHeld(EnvironmentEdgeManager.currentTime() - lockStartTime);
                                    }
                                }
                                return regionLocations2;
                            }
                            if (relocateMeta) {
                                this.relocateRegion(TableName.META_TABLE_NAME, HConstants.EMPTY_START_ROW, 0);
                            }
                            s.resetMvccReadPoint();
                            Span span = new TableOperationSpanBuilder(this).setTableName(TableName.META_TABLE_NAME).setOperation(s).build();
                            ignored = span.makeCurrent();
                            throwable2 = null;
                            rcs = new ReversedClientScanner(this.conf, s, s, TableName.META_TABLE_NAME, this, this.rpcCallerFactory, this.rpcControllerFactory, this.getMetaLookupPool(), this.connectionConfig.getMetaReadRpcTimeout(), this.connectionConfig.getMetaScanTimeout(), this.metaReplicaCallTimeoutScanInMicroSecond, this.connectionConfig, Collections.emptyMap());
                            throwable = null;
                            boolean tableNotFound = true;
                            do {
                                Result regionInfoRow;
                                if ((regionInfoRow = rcs.next()) == null) {
                                    if (tableNotFound) {
                                        throw new TableNotFoundException(tableName);
                                    }
                                    throw new IOException("Unable to find region for " + Bytes.toStringBinary(row) + " in " + tableName);
                                }
                                tableNotFound = false;
                                locations2 = MetaTableAccessor.getRegionLocations(regionInfoRow);
                                if (locations2 == null || locations2.getRegionLocation(replicaId) == null) {
                                    throw new IOException("RegionInfo null in " + tableName + ", row=" + regionInfoRow);
                                }
                                regionInfo = locations2.getRegionLocation(replicaId).getRegion();
                                if (regionInfo != null) continue;
                                throw new IOException("RegionInfo null or empty in " + TableName.META_TABLE_NAME + ", row=" + regionInfoRow);
                            } while (regionInfo.isSplitParent());
                            if (regionInfo.isOffline()) {
                                throw new RegionOfflineException("Region offline; disable table call? " + regionInfo.getRegionNameAsString());
                            }
                            if (!regionInfo.containsRow(row)) {
                                throw new IOException("Unable to find region for " + Bytes.toStringBinary(row) + " in " + tableName);
                            }
                            ServerName serverName = locations2.getRegionLocation(replicaId).getServerName();
                            if (serverName == null) {
                                throw new NoServerForRegionException("No server address listed in " + TableName.META_TABLE_NAME + " for region " + regionInfo.getRegionNameAsString() + " containing row " + Bytes.toStringBinary(row));
                            }
                            if (this.isDeadServer(serverName)) {
                                throw new RegionServerStoppedException("hbase:meta says the region " + regionInfo.getRegionNameAsString() + " is managed by the server " + serverName + ", but it is dead.");
                            }
                            this.cacheLocation(tableName, locations2);
                            regionLocations = locations2;
                            if (rcs == null) break block65;
                            if (throwable == null) break block66;
                            try {
                                rcs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            break block65;
                        }
                        rcs.close();
                    }
                    if (ignored == null) break block67;
                    if (throwable2 == null) break block68;
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    break block67;
                }
                ignored.close();
            }
            if (lockedUserRegion) {
                this.userRegionLock.unlock();
                if (this.metrics != null) {
                    this.metrics.updateUserRegionLockHeld(EnvironmentEdgeManager.currentTime() - lockStartTime);
                }
            }
            return regionLocations;
            {
                catch (Throwable throwable5) {
                    try {
                        try {
                            try {
                                try {
                                    try {
                                        throwable = throwable5;
                                        throw throwable5;
                                    }
                                    catch (Throwable throwable6) {
                                        if (rcs != null) {
                                            if (throwable != null) {
                                                try {
                                                    rcs.close();
                                                }
                                                catch (Throwable throwable7) {
                                                    throwable.addSuppressed(throwable7);
                                                }
                                            } else {
                                                rcs.close();
                                            }
                                        }
                                        throw throwable6;
                                    }
                                }
                                catch (Throwable throwable8) {
                                    throwable2 = throwable8;
                                    throw throwable8;
                                }
                            }
                            catch (Throwable throwable9) {
                                if (ignored != null) {
                                    if (throwable2 != null) {
                                        try {
                                            ignored.close();
                                        }
                                        catch (Throwable throwable10) {
                                            throwable2.addSuppressed(throwable10);
                                        }
                                    } else {
                                        ignored.close();
                                    }
                                }
                                throw throwable9;
                            }
                        }
                        catch (TableNotFoundException e) {
                            throw e;
                        }
                        catch (LocalConnectionClosedException cce) {
                            throw cce;
                        }
                        catch (IOException e) {
                            ExceptionUtil.rethrowIfInterrupt(e);
                            if (e instanceof RemoteException) {
                                e = ((RemoteException)e).unwrapRemoteException();
                            }
                            if (HBaseServerException.isServerOverloaded(e)) {
                                pauseBase = this.connectionConfig.getPauseMillisForServerOverloaded();
                            }
                            if (tries >= maxAttempts - 1) {
                                throw e;
                            }
                            LOG.debug("locateRegionInMeta parentTable='{}', attempt={} of {} failed; retrying after sleep of {}", new Object[]{TableName.META_TABLE_NAME, tries, maxAttempts, maxAttempts, e});
                            boolean bl = relocateMeta = !(e instanceof RegionOfflineException) && !(e instanceof NoServerForRegionException);
                            if (this.metrics != null && HBaseServerException.isServerOverloaded(e)) {
                                this.metrics.incrementServerOverloadedBackoffTime(ConnectionUtils.getPauseTime(pauseBase, tries), TimeUnit.MILLISECONDS);
                            }
                            if (lockedUserRegion) {
                                this.userRegionLock.unlock();
                                if (this.metrics != null) {
                                    this.metrics.updateUserRegionLockHeld(EnvironmentEdgeManager.currentTime() - lockStartTime);
                                }
                            }
                        }
                    }
                    catch (Throwable throwable11) {
                        if (lockedUserRegion) {
                            this.userRegionLock.unlock();
                            if (this.metrics != null) {
                                this.metrics.updateUserRegionLockHeld(EnvironmentEdgeManager.currentTime() - lockStartTime);
                            }
                        }
                        throw throwable11;
                    }
                }
            }
            try {
                Thread.sleep(ConnectionUtils.getPauseTime(pauseBase, tries));
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Giving up trying to location region in meta: thread is interrupted.");
            }
            ++tries;
        }
    }

    void takeUserRegionLock() throws IOException {
        try {
            long waitTime = this.connectionConfig.getMetaOperationTimeout();
            if (this.metrics != null) {
                this.metrics.updateUserRegionLockQueue(this.userRegionLock.getQueueLength());
            }
            long waitStartTime = EnvironmentEdgeManager.currentTime();
            if (!this.userRegionLock.tryLock(waitTime, TimeUnit.MILLISECONDS)) {
                if (this.metrics != null) {
                    this.metrics.incrUserRegionLockTimeout();
                }
                throw new LockTimeoutException("Failed to get user region lock in" + waitTime + " ms.  for accessing meta region server.");
            }
            if (this.metrics != null) {
                this.metrics.updateUserRegionLockWaiting(EnvironmentEdgeManager.currentTime() - waitStartTime);
            }
        }
        catch (InterruptedException ie) {
            LOG.error("Interrupted while waiting for a lock", (Throwable)ie);
            throw ExceptionUtil.asInterrupt(ie);
        }
    }

    @Override
    public void cacheLocation(TableName tableName, RegionLocations location) {
        this.metaCache.cacheLocation(tableName, location);
    }

    RegionLocations getCachedLocation(TableName tableName, byte[] row) {
        return this.metaCache.getCachedLocation(tableName, row);
    }

    public void clearRegionCache(TableName tableName, byte[] row) {
        this.metaCache.clearCache(tableName, row);
    }

    @Override
    public void clearCaches(ServerName serverName) {
        this.metaCache.clearCache(serverName);
    }

    @Override
    public void clearRegionLocationCache() {
        this.metaCache.clearCache();
    }

    @Override
    public void clearRegionCache(TableName tableName) {
        this.metaCache.clearCache(tableName);
    }

    private void cacheLocation(TableName tableName, ServerName source, HRegionLocation location) {
        this.metaCache.cacheLocation(tableName, source, location);
    }

    @Override
    public AdminProtos.AdminService.BlockingInterface getAdminForMaster() throws IOException {
        return this.getAdmin(ConnectionImplementation.get(this.registry.getActiveMaster()));
    }

    @Override
    public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName) throws IOException {
        this.checkClosed();
        if (this.isDeadServer(serverName)) {
            throw new RegionServerStoppedException(serverName + " is dead.");
        }
        String key = ConnectionUtils.getStubKey(AdminProtos.AdminService.BlockingInterface.class.getName(), serverName);
        return (AdminProtos.AdminService.BlockingInterface)ConcurrentMapUtils.computeIfAbsentEx(this.stubs, key, () -> {
            BlockingRpcChannel channel = this.rpcClient.createBlockingRpcChannel(serverName, this.user, this.rpcTimeout);
            return AdminProtos.AdminService.newBlockingStub(channel);
        });
    }

    @Override
    public ClientProtos.ClientService.BlockingInterface getClient(ServerName serverName) throws IOException {
        this.checkClosed();
        if (this.isDeadServer(serverName)) {
            throw new RegionServerStoppedException(serverName + " is dead.");
        }
        String key = ConnectionUtils.getStubKey(ClientProtos.ClientService.BlockingInterface.class.getName(), serverName);
        return (ClientProtos.ClientService.BlockingInterface)ConcurrentMapUtils.computeIfAbsentEx(this.stubs, key, () -> {
            BlockingRpcChannel channel = this.rpcClient.createBlockingRpcChannel(serverName, this.user, this.rpcTimeout);
            return ClientProtos.ClientService.newBlockingStub(channel);
        });
    }

    MasterServiceState getMasterServiceState() {
        return this.masterServiceState;
    }

    @Override
    public MasterKeepAliveConnection getMaster() throws IOException {
        return this.getKeepAliveMasterService();
    }

    private void resetMasterServiceState(MasterServiceState mss) {
        ++mss.userCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MasterKeepAliveConnection getKeepAliveMasterService() throws IOException {
        if (!this.isKeepAliveMasterConnectedAndRunning()) {
            Object object = this.masterLock;
            synchronized (object) {
                if (!this.isKeepAliveMasterConnectedAndRunning()) {
                    MasterServiceStubMaker stubMaker = new MasterServiceStubMaker();
                    this.masterServiceState.stub = stubMaker.makeStub();
                }
                this.resetMasterServiceState(this.masterServiceState);
            }
        }
        final MasterProtos.MasterService.BlockingInterface stub = this.masterServiceState.stub;
        return new MasterKeepAliveConnection(){
            MasterServiceState mss;
            {
                this.mss = ConnectionImplementation.this.masterServiceState;
            }

            @Override
            public MasterProtos.AbortProcedureResponse abortProcedure(RpcController controller, MasterProtos.AbortProcedureRequest request) throws ServiceException {
                return stub.abortProcedure(controller, request);
            }

            @Override
            public MasterProtos.GetProceduresResponse getProcedures(RpcController controller, MasterProtos.GetProceduresRequest request) throws ServiceException {
                return stub.getProcedures(controller, request);
            }

            @Override
            public MasterProtos.GetLocksResponse getLocks(RpcController controller, MasterProtos.GetLocksRequest request) throws ServiceException {
                return stub.getLocks(controller, request);
            }

            @Override
            public MasterProtos.AddColumnResponse addColumn(RpcController controller, MasterProtos.AddColumnRequest request) throws ServiceException {
                return stub.addColumn(controller, request);
            }

            @Override
            public MasterProtos.DeleteColumnResponse deleteColumn(RpcController controller, MasterProtos.DeleteColumnRequest request) throws ServiceException {
                return stub.deleteColumn(controller, request);
            }

            @Override
            public MasterProtos.ModifyColumnResponse modifyColumn(RpcController controller, MasterProtos.ModifyColumnRequest request) throws ServiceException {
                return stub.modifyColumn(controller, request);
            }

            @Override
            public MasterProtos.MoveRegionResponse moveRegion(RpcController controller, MasterProtos.MoveRegionRequest request) throws ServiceException {
                return stub.moveRegion(controller, request);
            }

            @Override
            public MasterProtos.MergeTableRegionsResponse mergeTableRegions(RpcController controller, MasterProtos.MergeTableRegionsRequest request) throws ServiceException {
                return stub.mergeTableRegions(controller, request);
            }

            @Override
            public MasterProtos.AssignRegionResponse assignRegion(RpcController controller, MasterProtos.AssignRegionRequest request) throws ServiceException {
                return stub.assignRegion(controller, request);
            }

            @Override
            public MasterProtos.UnassignRegionResponse unassignRegion(RpcController controller, MasterProtos.UnassignRegionRequest request) throws ServiceException {
                return stub.unassignRegion(controller, request);
            }

            @Override
            public MasterProtos.OfflineRegionResponse offlineRegion(RpcController controller, MasterProtos.OfflineRegionRequest request) throws ServiceException {
                return stub.offlineRegion(controller, request);
            }

            @Override
            public MasterProtos.SplitTableRegionResponse splitRegion(RpcController controller, MasterProtos.SplitTableRegionRequest request) throws ServiceException {
                return stub.splitRegion(controller, request);
            }

            @Override
            public MasterProtos.TruncateRegionResponse truncateRegion(RpcController controller, MasterProtos.TruncateRegionRequest request) throws ServiceException {
                return stub.truncateRegion(controller, request);
            }

            @Override
            public MasterProtos.DeleteTableResponse deleteTable(RpcController controller, MasterProtos.DeleteTableRequest request) throws ServiceException {
                return stub.deleteTable(controller, request);
            }

            @Override
            public MasterProtos.TruncateTableResponse truncateTable(RpcController controller, MasterProtos.TruncateTableRequest request) throws ServiceException {
                return stub.truncateTable(controller, request);
            }

            @Override
            public MasterProtos.EnableTableResponse enableTable(RpcController controller, MasterProtos.EnableTableRequest request) throws ServiceException {
                return stub.enableTable(controller, request);
            }

            @Override
            public MasterProtos.DisableTableResponse disableTable(RpcController controller, MasterProtos.DisableTableRequest request) throws ServiceException {
                return stub.disableTable(controller, request);
            }

            @Override
            public MasterProtos.ModifyTableResponse modifyTable(RpcController controller, MasterProtos.ModifyTableRequest request) throws ServiceException {
                return stub.modifyTable(controller, request);
            }

            @Override
            public MasterProtos.CreateTableResponse createTable(RpcController controller, MasterProtos.CreateTableRequest request) throws ServiceException {
                return stub.createTable(controller, request);
            }

            @Override
            public MasterProtos.ShutdownResponse shutdown(RpcController controller, MasterProtos.ShutdownRequest request) throws ServiceException {
                return stub.shutdown(controller, request);
            }

            @Override
            public MasterProtos.StopMasterResponse stopMaster(RpcController controller, MasterProtos.StopMasterRequest request) throws ServiceException {
                return stub.stopMaster(controller, request);
            }

            @Override
            public MasterProtos.IsInMaintenanceModeResponse isMasterInMaintenanceMode(RpcController controller, MasterProtos.IsInMaintenanceModeRequest request) throws ServiceException {
                return stub.isMasterInMaintenanceMode(controller, request);
            }

            @Override
            public MasterProtos.BalanceResponse balance(RpcController controller, MasterProtos.BalanceRequest request) throws ServiceException {
                return stub.balance(controller, request);
            }

            @Override
            public MasterProtos.SetBalancerRunningResponse setBalancerRunning(RpcController controller, MasterProtos.SetBalancerRunningRequest request) throws ServiceException {
                return stub.setBalancerRunning(controller, request);
            }

            @Override
            public MasterProtos.NormalizeResponse normalize(RpcController controller, MasterProtos.NormalizeRequest request) throws ServiceException {
                return stub.normalize(controller, request);
            }

            @Override
            public MasterProtos.SetNormalizerRunningResponse setNormalizerRunning(RpcController controller, MasterProtos.SetNormalizerRunningRequest request) throws ServiceException {
                return stub.setNormalizerRunning(controller, request);
            }

            @Override
            public MasterProtos.RunCatalogScanResponse runCatalogScan(RpcController controller, MasterProtos.RunCatalogScanRequest request) throws ServiceException {
                return stub.runCatalogScan(controller, request);
            }

            @Override
            public MasterProtos.EnableCatalogJanitorResponse enableCatalogJanitor(RpcController controller, MasterProtos.EnableCatalogJanitorRequest request) throws ServiceException {
                return stub.enableCatalogJanitor(controller, request);
            }

            @Override
            public MasterProtos.IsCatalogJanitorEnabledResponse isCatalogJanitorEnabled(RpcController controller, MasterProtos.IsCatalogJanitorEnabledRequest request) throws ServiceException {
                return stub.isCatalogJanitorEnabled(controller, request);
            }

            @Override
            public MasterProtos.RunCleanerChoreResponse runCleanerChore(RpcController controller, MasterProtos.RunCleanerChoreRequest request) throws ServiceException {
                return stub.runCleanerChore(controller, request);
            }

            @Override
            public MasterProtos.SetCleanerChoreRunningResponse setCleanerChoreRunning(RpcController controller, MasterProtos.SetCleanerChoreRunningRequest request) throws ServiceException {
                return stub.setCleanerChoreRunning(controller, request);
            }

            @Override
            public MasterProtos.IsCleanerChoreEnabledResponse isCleanerChoreEnabled(RpcController controller, MasterProtos.IsCleanerChoreEnabledRequest request) throws ServiceException {
                return stub.isCleanerChoreEnabled(controller, request);
            }

            @Override
            public ClientProtos.CoprocessorServiceResponse execMasterService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
                return stub.execMasterService(controller, request);
            }

            @Override
            public MasterProtos.SnapshotResponse snapshot(RpcController controller, MasterProtos.SnapshotRequest request) throws ServiceException {
                return stub.snapshot(controller, request);
            }

            @Override
            public MasterProtos.GetCompletedSnapshotsResponse getCompletedSnapshots(RpcController controller, MasterProtos.GetCompletedSnapshotsRequest request) throws ServiceException {
                return stub.getCompletedSnapshots(controller, request);
            }

            @Override
            public MasterProtos.DeleteSnapshotResponse deleteSnapshot(RpcController controller, MasterProtos.DeleteSnapshotRequest request) throws ServiceException {
                return stub.deleteSnapshot(controller, request);
            }

            @Override
            public MasterProtos.IsSnapshotDoneResponse isSnapshotDone(RpcController controller, MasterProtos.IsSnapshotDoneRequest request) throws ServiceException {
                return stub.isSnapshotDone(controller, request);
            }

            @Override
            public MasterProtos.RestoreSnapshotResponse restoreSnapshot(RpcController controller, MasterProtos.RestoreSnapshotRequest request) throws ServiceException {
                return stub.restoreSnapshot(controller, request);
            }

            @Override
            public MasterProtos.SetSnapshotCleanupResponse switchSnapshotCleanup(RpcController controller, MasterProtos.SetSnapshotCleanupRequest request) throws ServiceException {
                return stub.switchSnapshotCleanup(controller, request);
            }

            @Override
            public MasterProtos.IsSnapshotCleanupEnabledResponse isSnapshotCleanupEnabled(RpcController controller, MasterProtos.IsSnapshotCleanupEnabledRequest request) throws ServiceException {
                return stub.isSnapshotCleanupEnabled(controller, request);
            }

            @Override
            public MasterProtos.ExecProcedureResponse execProcedure(RpcController controller, MasterProtos.ExecProcedureRequest request) throws ServiceException {
                return stub.execProcedure(controller, request);
            }

            @Override
            public MasterProtos.ExecProcedureResponse execProcedureWithRet(RpcController controller, MasterProtos.ExecProcedureRequest request) throws ServiceException {
                return stub.execProcedureWithRet(controller, request);
            }

            @Override
            public MasterProtos.IsProcedureDoneResponse isProcedureDone(RpcController controller, MasterProtos.IsProcedureDoneRequest request) throws ServiceException {
                return stub.isProcedureDone(controller, request);
            }

            @Override
            public MasterProtos.GetProcedureResultResponse getProcedureResult(RpcController controller, MasterProtos.GetProcedureResultRequest request) throws ServiceException {
                return stub.getProcedureResult(controller, request);
            }

            @Override
            public MasterProtos.IsMasterRunningResponse isMasterRunning(RpcController controller, MasterProtos.IsMasterRunningRequest request) throws ServiceException {
                return stub.isMasterRunning(controller, request);
            }

            @Override
            public MasterProtos.ModifyNamespaceResponse modifyNamespace(RpcController controller, MasterProtos.ModifyNamespaceRequest request) throws ServiceException {
                return stub.modifyNamespace(controller, request);
            }

            @Override
            public MasterProtos.CreateNamespaceResponse createNamespace(RpcController controller, MasterProtos.CreateNamespaceRequest request) throws ServiceException {
                return stub.createNamespace(controller, request);
            }

            @Override
            public MasterProtos.DeleteNamespaceResponse deleteNamespace(RpcController controller, MasterProtos.DeleteNamespaceRequest request) throws ServiceException {
                return stub.deleteNamespace(controller, request);
            }

            @Override
            public MasterProtos.ListNamespacesResponse listNamespaces(RpcController controller, MasterProtos.ListNamespacesRequest request) throws ServiceException {
                return stub.listNamespaces(controller, request);
            }

            @Override
            public MasterProtos.GetNamespaceDescriptorResponse getNamespaceDescriptor(RpcController controller, MasterProtos.GetNamespaceDescriptorRequest request) throws ServiceException {
                return stub.getNamespaceDescriptor(controller, request);
            }

            @Override
            public MasterProtos.ListNamespaceDescriptorsResponse listNamespaceDescriptors(RpcController controller, MasterProtos.ListNamespaceDescriptorsRequest request) throws ServiceException {
                return stub.listNamespaceDescriptors(controller, request);
            }

            @Override
            public MasterProtos.ListTableDescriptorsByNamespaceResponse listTableDescriptorsByNamespace(RpcController controller, MasterProtos.ListTableDescriptorsByNamespaceRequest request) throws ServiceException {
                return stub.listTableDescriptorsByNamespace(controller, request);
            }

            @Override
            public MasterProtos.ListTableNamesByNamespaceResponse listTableNamesByNamespace(RpcController controller, MasterProtos.ListTableNamesByNamespaceRequest request) throws ServiceException {
                return stub.listTableNamesByNamespace(controller, request);
            }

            @Override
            public MasterProtos.GetTableStateResponse getTableState(RpcController controller, MasterProtos.GetTableStateRequest request) throws ServiceException {
                return stub.getTableState(controller, request);
            }

            @Override
            public void close() {
                ConnectionImplementation.release(this.mss);
            }

            @Override
            public MasterProtos.GetSchemaAlterStatusResponse getSchemaAlterStatus(RpcController controller, MasterProtos.GetSchemaAlterStatusRequest request) throws ServiceException {
                return stub.getSchemaAlterStatus(controller, request);
            }

            @Override
            public MasterProtos.GetTableDescriptorsResponse getTableDescriptors(RpcController controller, MasterProtos.GetTableDescriptorsRequest request) throws ServiceException {
                return stub.getTableDescriptors(controller, request);
            }

            @Override
            public MasterProtos.ListTableDescriptorsByStateResponse listTableDescriptorsByState(RpcController controller, MasterProtos.ListTableDescriptorsByStateRequest request) throws ServiceException {
                return stub.listTableDescriptorsByState(controller, request);
            }

            @Override
            public MasterProtos.GetTableNamesResponse getTableNames(RpcController controller, MasterProtos.GetTableNamesRequest request) throws ServiceException {
                return stub.getTableNames(controller, request);
            }

            @Override
            public MasterProtos.FlushTableResponse flushTable(RpcController controller, MasterProtos.FlushTableRequest request) throws ServiceException {
                return stub.flushTable(controller, request);
            }

            @Override
            public MasterProtos.ListTableNamesByStateResponse listTableNamesByState(RpcController controller, MasterProtos.ListTableNamesByStateRequest request) throws ServiceException {
                return stub.listTableNamesByState(controller, request);
            }

            @Override
            public MasterProtos.GetClusterStatusResponse getClusterStatus(RpcController controller, MasterProtos.GetClusterStatusRequest request) throws ServiceException {
                return stub.getClusterStatus(controller, request);
            }

            @Override
            public MasterProtos.SetQuotaResponse setQuota(RpcController controller, MasterProtos.SetQuotaRequest request) throws ServiceException {
                return stub.setQuota(controller, request);
            }

            @Override
            public MasterProtos.MajorCompactionTimestampResponse getLastMajorCompactionTimestamp(RpcController controller, MasterProtos.MajorCompactionTimestampRequest request) throws ServiceException {
                return stub.getLastMajorCompactionTimestamp(controller, request);
            }

            @Override
            public MasterProtos.MajorCompactionTimestampResponse getLastMajorCompactionTimestampForRegion(RpcController controller, MasterProtos.MajorCompactionTimestampForRegionRequest request) throws ServiceException {
                return stub.getLastMajorCompactionTimestampForRegion(controller, request);
            }

            @Override
            public MasterProtos.IsBalancerEnabledResponse isBalancerEnabled(RpcController controller, MasterProtos.IsBalancerEnabledRequest request) throws ServiceException {
                return stub.isBalancerEnabled(controller, request);
            }

            @Override
            public MasterProtos.SetSplitOrMergeEnabledResponse setSplitOrMergeEnabled(RpcController controller, MasterProtos.SetSplitOrMergeEnabledRequest request) throws ServiceException {
                return stub.setSplitOrMergeEnabled(controller, request);
            }

            @Override
            public MasterProtos.IsSplitOrMergeEnabledResponse isSplitOrMergeEnabled(RpcController controller, MasterProtos.IsSplitOrMergeEnabledRequest request) throws ServiceException {
                return stub.isSplitOrMergeEnabled(controller, request);
            }

            @Override
            public MasterProtos.IsNormalizerEnabledResponse isNormalizerEnabled(RpcController controller, MasterProtos.IsNormalizerEnabledRequest request) throws ServiceException {
                return stub.isNormalizerEnabled(controller, request);
            }

            @Override
            public MasterProtos.SecurityCapabilitiesResponse getSecurityCapabilities(RpcController controller, MasterProtos.SecurityCapabilitiesRequest request) throws ServiceException {
                return stub.getSecurityCapabilities(controller, request);
            }

            @Override
            public ReplicationProtos.AddReplicationPeerResponse addReplicationPeer(RpcController controller, ReplicationProtos.AddReplicationPeerRequest request) throws ServiceException {
                return stub.addReplicationPeer(controller, request);
            }

            @Override
            public ReplicationProtos.RemoveReplicationPeerResponse removeReplicationPeer(RpcController controller, ReplicationProtos.RemoveReplicationPeerRequest request) throws ServiceException {
                return stub.removeReplicationPeer(controller, request);
            }

            @Override
            public ReplicationProtos.EnableReplicationPeerResponse enableReplicationPeer(RpcController controller, ReplicationProtos.EnableReplicationPeerRequest request) throws ServiceException {
                return stub.enableReplicationPeer(controller, request);
            }

            @Override
            public ReplicationProtos.DisableReplicationPeerResponse disableReplicationPeer(RpcController controller, ReplicationProtos.DisableReplicationPeerRequest request) throws ServiceException {
                return stub.disableReplicationPeer(controller, request);
            }

            @Override
            public MasterProtos.ListDecommissionedRegionServersResponse listDecommissionedRegionServers(RpcController controller, MasterProtos.ListDecommissionedRegionServersRequest request) throws ServiceException {
                return stub.listDecommissionedRegionServers(controller, request);
            }

            @Override
            public MasterProtos.DecommissionRegionServersResponse decommissionRegionServers(RpcController controller, MasterProtos.DecommissionRegionServersRequest request) throws ServiceException {
                return stub.decommissionRegionServers(controller, request);
            }

            @Override
            public MasterProtos.RecommissionRegionServerResponse recommissionRegionServer(RpcController controller, MasterProtos.RecommissionRegionServerRequest request) throws ServiceException {
                return stub.recommissionRegionServer(controller, request);
            }

            @Override
            public ReplicationProtos.GetReplicationPeerConfigResponse getReplicationPeerConfig(RpcController controller, ReplicationProtos.GetReplicationPeerConfigRequest request) throws ServiceException {
                return stub.getReplicationPeerConfig(controller, request);
            }

            @Override
            public ReplicationProtos.UpdateReplicationPeerConfigResponse updateReplicationPeerConfig(RpcController controller, ReplicationProtos.UpdateReplicationPeerConfigRequest request) throws ServiceException {
                return stub.updateReplicationPeerConfig(controller, request);
            }

            @Override
            public ReplicationProtos.ListReplicationPeersResponse listReplicationPeers(RpcController controller, ReplicationProtos.ListReplicationPeersRequest request) throws ServiceException {
                return stub.listReplicationPeers(controller, request);
            }

            @Override
            public ReplicationProtos.GetReplicationPeerStateResponse isReplicationPeerEnabled(RpcController controller, ReplicationProtos.GetReplicationPeerStateRequest request) throws ServiceException {
                return stub.isReplicationPeerEnabled(controller, request);
            }

            @Override
            public QuotaProtos.GetSpaceQuotaRegionSizesResponse getSpaceQuotaRegionSizes(RpcController controller, QuotaProtos.GetSpaceQuotaRegionSizesRequest request) throws ServiceException {
                return stub.getSpaceQuotaRegionSizes(controller, request);
            }

            @Override
            public QuotaProtos.GetQuotaStatesResponse getQuotaStates(RpcController controller, QuotaProtos.GetQuotaStatesRequest request) throws ServiceException {
                return stub.getQuotaStates(controller, request);
            }

            @Override
            public MasterProtos.ClearDeadServersResponse clearDeadServers(RpcController controller, MasterProtos.ClearDeadServersRequest request) throws ServiceException {
                return stub.clearDeadServers(controller, request);
            }

            @Override
            public MasterProtos.SwitchRpcThrottleResponse switchRpcThrottle(RpcController controller, MasterProtos.SwitchRpcThrottleRequest request) throws ServiceException {
                return stub.switchRpcThrottle(controller, request);
            }

            @Override
            public MasterProtos.IsRpcThrottleEnabledResponse isRpcThrottleEnabled(RpcController controller, MasterProtos.IsRpcThrottleEnabledRequest request) throws ServiceException {
                return stub.isRpcThrottleEnabled(controller, request);
            }

            @Override
            public MasterProtos.SwitchExceedThrottleQuotaResponse switchExceedThrottleQuota(RpcController controller, MasterProtos.SwitchExceedThrottleQuotaRequest request) throws ServiceException {
                return stub.switchExceedThrottleQuota(controller, request);
            }

            @Override
            public AccessControlProtos.GrantResponse grant(RpcController controller, AccessControlProtos.GrantRequest request) throws ServiceException {
                return stub.grant(controller, request);
            }

            @Override
            public AccessControlProtos.RevokeResponse revoke(RpcController controller, AccessControlProtos.RevokeRequest request) throws ServiceException {
                return stub.revoke(controller, request);
            }

            @Override
            public AccessControlProtos.GetUserPermissionsResponse getUserPermissions(RpcController controller, AccessControlProtos.GetUserPermissionsRequest request) throws ServiceException {
                return stub.getUserPermissions(controller, request);
            }

            @Override
            public AccessControlProtos.HasUserPermissionsResponse hasUserPermissions(RpcController controller, AccessControlProtos.HasUserPermissionsRequest request) throws ServiceException {
                return stub.hasUserPermissions(controller, request);
            }

            @Override
            public HBaseProtos.LogEntry getLogEntries(RpcController controller, HBaseProtos.LogRequest request) throws ServiceException {
                return stub.getLogEntries(controller, request);
            }

            @Override
            public MasterProtos.ModifyTableStoreFileTrackerResponse modifyTableStoreFileTracker(RpcController controller, MasterProtos.ModifyTableStoreFileTrackerRequest request) throws ServiceException {
                return stub.modifyTableStoreFileTracker(controller, request);
            }

            @Override
            public MasterProtos.ModifyColumnStoreFileTrackerResponse modifyColumnStoreFileTracker(RpcController controller, MasterProtos.ModifyColumnStoreFileTrackerRequest request) throws ServiceException {
                return stub.modifyColumnStoreFileTracker(controller, request);
            }

            @Override
            public MasterProtos.FlushMasterStoreResponse flushMasterStore(RpcController controller, MasterProtos.FlushMasterStoreRequest request) throws ServiceException {
                return stub.flushMasterStore(controller, request);
            }

            @Override
            public ReplicationProtos.ReplicationPeerModificationSwitchResponse replicationPeerModificationSwitch(RpcController controller, ReplicationProtos.ReplicationPeerModificationSwitchRequest request) throws ServiceException {
                return stub.replicationPeerModificationSwitch(controller, request);
            }

            @Override
            public ReplicationProtos.GetReplicationPeerModificationProceduresResponse getReplicationPeerModificationProcedures(RpcController controller, ReplicationProtos.GetReplicationPeerModificationProceduresRequest request) throws ServiceException {
                return stub.getReplicationPeerModificationProcedures(controller, request);
            }

            @Override
            public ReplicationProtos.IsReplicationPeerModificationEnabledResponse isReplicationPeerModificationEnabled(RpcController controller, ReplicationProtos.IsReplicationPeerModificationEnabledRequest request) throws ServiceException {
                return stub.isReplicationPeerModificationEnabled(controller, request);
            }
        };
    }

    private static void release(MasterServiceState mss) {
        if (mss != null && mss.connection != null) {
            ((ConnectionImplementation)mss.connection).releaseMaster(mss);
        }
    }

    private boolean isKeepAliveMasterConnectedAndRunning() {
        LOG.trace("Getting master connection state from TTL Cache");
        return this.masterStateSupplier.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseMaster(MasterServiceState mss) {
        if (mss.getStub() == null) {
            return;
        }
        Object object = this.masterLock;
        synchronized (object) {
            --mss.userCount;
        }
    }

    private void closeMasterService(MasterServiceState mss) {
        if (mss.getStub() != null) {
            LOG.info("Closing master protocol: " + mss);
            mss.clearStub();
        }
        mss.userCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeMaster() {
        Object object = this.masterLock;
        synchronized (object) {
            this.closeMasterService(this.masterServiceState);
        }
    }

    void updateCachedLocation(RegionInfo hri, ServerName source, ServerName serverName, long seqNum) {
        HRegionLocation newHrl = new HRegionLocation(hri, serverName, seqNum);
        this.cacheLocation(hri.getTable(), source, newHrl);
    }

    @Override
    public void updateCachedLocations(TableName tableName, byte[] regionName, byte[] rowkey, Object exception, ServerName source) {
        if (rowkey == null || tableName == null) {
            LOG.warn("Coding error, see method javadoc. row=" + (rowkey == null ? "null" : (Object)rowkey) + ", tableName=" + (tableName == null ? "null" : tableName));
            return;
        }
        if (source == null) {
            return;
        }
        if (regionName == null) {
            if (this.metrics != null) {
                this.metrics.incrCacheDroppingExceptions(exception);
            }
            this.metaCache.clearCache(tableName, rowkey, source);
            return;
        }
        RegionLocations oldLocations = this.getCachedLocation(tableName, rowkey);
        HRegionLocation oldLocation = null;
        if (oldLocations != null) {
            oldLocation = oldLocations.getRegionLocationByRegionName(regionName);
        }
        if (oldLocation == null || !source.equals(oldLocation.getServerName())) {
            return;
        }
        RegionInfo regionInfo = oldLocation.getRegion();
        Throwable cause = ClientExceptionsUtil.findException(exception);
        if (cause != null) {
            if (!ClientExceptionsUtil.isMetaClearingException(cause)) {
                return;
            }
            if (cause instanceof RegionMovedException) {
                RegionMovedException rme = (RegionMovedException)cause;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Region " + regionInfo.getRegionNameAsString() + " moved to " + rme.getHostname() + ":" + rme.getPort() + " according to " + source.getAddress());
                }
                this.updateCachedLocation(regionInfo, source, rme.getServerName(), rme.getLocationSeqNum());
                return;
            }
        }
        if (this.metrics != null) {
            this.metrics.incrCacheDroppingExceptions(exception);
        }
        if (this.metaReplicaMode == CatalogReplicaMode.LOAD_BALANCE) {
            this.metaReplicaSelector.onError(oldLocation);
        }
        this.metaCache.clearCache(regionInfo);
    }

    @Override
    public AsyncProcess getAsyncProcess() {
        return this.asyncProcess;
    }

    @Override
    public ServerStatisticTracker getStatisticsTracker() {
        return this.stats;
    }

    @Override
    public ClientBackoffPolicy getBackoffPolicy() {
        return this.backoffPolicy;
    }

    int getNumberOfCachedRegionLocations(TableName tableName) {
        return this.metaCache.getNumberOfCachedRegionLocations(tableName);
    }

    @Override
    public void abort(String msg, Throwable t) {
        if (t != null) {
            LOG.error(HBaseMarkers.FATAL, msg, t);
        } else {
            LOG.error(HBaseMarkers.FATAL, msg);
        }
        this.aborted = true;
        this.close();
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public void close() {
        TraceUtil.trace(() -> {
            if (this.closed) {
                return;
            }
            this.closeMaster();
            this.shutdownPools();
            if (this.metrics != null) {
                MetricsConnection.deleteMetricsConnection(this.metricsScope);
            }
            this.closed = true;
            if (this.registry != null) {
                this.registry.close();
            }
            this.stubs.clear();
            if (this.clusterStatusListener != null) {
                this.clusterStatusListener.close();
            }
            if (this.rpcClient != null) {
                this.rpcClient.close();
            }
            ConnectionImplementation connectionImplementation = this;
            synchronized (connectionImplementation) {
                if (this.choreService != null) {
                    this.choreService.shutdown();
                }
            }
        }, this.getClass().getSimpleName() + ".close");
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    public NonceGenerator getNonceGenerator() {
        return nonceGenerator;
    }

    @Override
    public TableState getTableState(TableName tableName) throws IOException {
        this.checkClosed();
        TableState tableState = MetaTableAccessor.getTableState(this, tableName);
        if (tableState == null) {
            throw new TableNotFoundException(tableName);
        }
        return tableState;
    }

    @Override
    public RpcRetryingCallerFactory getNewRpcRetryingCallerFactory(Configuration conf) {
        return RpcRetryingCallerFactory.instantiate(conf, this.connectionConfig, this.interceptor, this.getStatisticsTracker(), this.metrics);
    }

    @Override
    public boolean hasCellBlockSupport() {
        return this.rpcClient.hasCellBlockSupport();
    }

    @Override
    public ConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfig;
    }

    @Override
    public RpcRetryingCallerFactory getRpcRetryingCallerFactory() {
        return this.rpcCallerFactory;
    }

    @Override
    public RpcControllerFactory getRpcControllerFactory() {
        return this.rpcControllerFactory;
    }

    private static <T> T get(CompletableFuture<T> future) throws IOException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Throwables.propagateIfPossible(cause, IOException.class);
            throw new IOException(cause);
        }
    }

    @Override
    public List<ServerName> getLiveRegionServers(Supplier<ServerName> masterAddrTracker, int count) throws IOException {
        RegionServerStatusProtos.GetLiveRegionServersResponse resp;
        RegionServerStatusProtos.RegionServerStatusService.BlockingInterface stub = RegionServerStatusProtos.RegionServerStatusService.newBlockingStub(this.rpcClient.createBlockingRpcChannel(masterAddrTracker.get(), this.user, this.rpcTimeout));
        try {
            resp = stub.getLiveRegionServers(null, RegionServerStatusProtos.GetLiveRegionServersRequest.newBuilder().setCount(count).build());
        }
        catch (ServiceException e) {
            Throwable t = ConnectionUtils.translateException(e);
            Throwables.propagateIfPossible(t, IOException.class);
            throw new IOException(t);
        }
        return resp.getServerList().stream().map(ProtobufUtil::toServerName).collect(Collectors.toList());
    }

    @Override
    public List<ServerName> getAllBootstrapNodes(ServerName regionServer) throws IOException {
        BootstrapNodeProtos.GetAllBootstrapNodesResponse resp;
        BootstrapNodeProtos.BootstrapNodeService.BlockingInterface stub = BootstrapNodeProtos.BootstrapNodeService.newBlockingStub(this.rpcClient.createBlockingRpcChannel(regionServer, this.user, this.rpcTimeout));
        try {
            resp = stub.getAllBootstrapNodes(null, BootstrapNodeProtos.GetAllBootstrapNodesRequest.getDefaultInstance());
        }
        catch (ServiceException e) {
            Throwable t = ConnectionUtils.translateException(e);
            Throwables.propagateIfPossible(t, IOException.class);
            throw new IOException(t);
        }
        return resp.getNodeList().stream().map(ProtobufUtil::toServerName).collect(Collectors.toList());
    }

    @Override
    public String getClusterId() {
        try {
            return this.registry.getClusterId().get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Error fetching cluster ID: ", (Throwable)e);
            return null;
        }
    }

    private final class MasterServiceStubMaker {
        private MasterServiceStubMaker() {
        }

        private void isMasterRunning(MasterProtos.MasterService.BlockingInterface stub) throws IOException {
            try {
                stub.isMasterRunning(null, RequestConverter.buildIsMasterRunningRequest());
            }
            catch (ServiceException e) {
                throw ProtobufUtil.handleRemoteException(e);
            }
        }

        private MasterProtos.MasterService.BlockingInterface makeStubNoRetries() throws IOException, KeeperException {
            ServerName sn = (ServerName)ConnectionImplementation.get(ConnectionImplementation.this.registry.getActiveMaster());
            if (sn == null) {
                String msg = "ZooKeeper available but no active master location found";
                LOG.info(msg);
                throw new MasterNotRunningException(msg);
            }
            if (ConnectionImplementation.this.isDeadServer(sn)) {
                throw new MasterNotRunningException(sn + " is dead.");
            }
            String key = ConnectionUtils.getStubKey(MasterProtos.MasterService.getDescriptor().getName(), sn);
            MasterProtos.MasterService.BlockingInterface stub = (MasterProtos.MasterService.BlockingInterface)ConcurrentMapUtils.computeIfAbsentEx(ConnectionImplementation.this.stubs, key, () -> {
                BlockingRpcChannel channel = ConnectionImplementation.this.rpcClient.createBlockingRpcChannel(sn, ConnectionImplementation.this.user, ConnectionImplementation.this.rpcTimeout);
                return MasterProtos.MasterService.newBlockingStub(channel);
            });
            this.isMasterRunning(stub);
            return stub;
        }

        MasterProtos.MasterService.BlockingInterface makeStub() throws IOException {
            Object object = ConnectionImplementation.this.masterLock;
            synchronized (object) {
                Exception exceptionCaught = null;
                if (!ConnectionImplementation.this.closed) {
                    try {
                        return this.makeStubNoRetries();
                    }
                    catch (IOException e) {
                        exceptionCaught = e;
                    }
                    catch (KeeperException e) {
                        exceptionCaught = e;
                    }
                    throw new MasterNotRunningException(exceptionCaught);
                }
                throw new DoNotRetryIOException("Connection was closed while trying to get master");
            }
        }
    }

    static class ServerErrorTracker {
        private final ConcurrentMap<ServerName, ServerErrors> errorsByServer = new ConcurrentHashMap<ServerName, ServerErrors>();
        private final long canRetryUntil;
        private final int maxTries;
        private final long startTrackingTime;

        public ServerErrorTracker(long timeout, int maxTries) {
            this.maxTries = maxTries;
            this.canRetryUntil = EnvironmentEdgeManager.currentTime() + timeout;
            this.startTrackingTime = new Date().getTime();
        }

        boolean canTryMore(int numAttempt) {
            return numAttempt < this.maxTries || this.maxTries > 1 && EnvironmentEdgeManager.currentTime() < this.canRetryUntil;
        }

        long calculateBackoffTime(ServerName server, long basePause) {
            ServerErrors errorStats = (ServerErrors)this.errorsByServer.get(server);
            long result = errorStats != null ? ConnectionUtils.getPauseTime(basePause, Math.max(0, errorStats.getCount() - 1)) : 0L;
            return result;
        }

        void reportServerError(ServerName server) {
            ConcurrentMapUtils.computeIfAbsent(this.errorsByServer, server, () -> new ServerErrors()).addError();
        }

        long getStartTrackingTime() {
            return this.startTrackingTime;
        }

        private static class ServerErrors {
            private final AtomicInteger retries = new AtomicInteger(0);

            private ServerErrors() {
            }

            public int getCount() {
                return this.retries.get();
            }

            public void addError() {
                this.retries.incrementAndGet();
            }
        }
    }

    static class MasterServiceState {
        Connection connection;
        MasterProtos.MasterService.BlockingInterface stub;
        int userCount;

        MasterServiceState(Connection connection) {
            this.connection = connection;
        }

        public String toString() {
            return "MasterService";
        }

        Object getStub() {
            return this.stub;
        }

        void clearStub() {
            this.stub = null;
        }

        boolean isMasterRunning() throws IOException {
            MasterProtos.IsMasterRunningResponse response = null;
            try {
                response = this.stub.isMasterRunning(null, RequestConverter.buildIsMasterRunningRequest());
            }
            catch (Exception e) {
                throw ProtobufUtil.handleRemoteException(e);
            }
            return response != null ? response.getIsMasterRunning() : false;
        }
    }

    private static class LocalConnectionClosedException
    extends DoNotRetryIOException {
        LocalConnectionClosedException(String message) {
            super(message);
        }
    }
}

