/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler.builder.helper;

import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.helper.TransformerHelper;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;

public class TransformerReflectionHelper {
    private final TransformerHelper transformerHelper = new TransformerHelper();
    private final Helper helper;

    public TransformerReflectionHelper(Helper helper) {
        this.helper = helper;
    }

    public JavaClass getReturnTypeForWriteTransformationMethodTransformer(JavaClass writerClass) throws JAXBException {
        return this.getReturnTypeForWriteTransformationMethod(this.getTransformerHelper().getTransformerMethodName(), writerClass, true);
    }

    public JavaClass getReturnTypeForWriteTransformationMethod(String methodName, JavaClass writerClass) throws JAXBException {
        return this.getReturnTypeForWriteTransformationMethod(methodName, writerClass, false);
    }

    private JavaClass getReturnTypeForWriteTransformationMethod(String methodName, JavaClass writerClass, boolean isSetTransformerClass) throws JAXBException {
        JavaMethod javaMethod = null;
        for (Class[] methodParameters : this.getTransformerHelper().getTransformerMethodParameters(isSetTransformerClass)) {
            javaMethod = writerClass.getDeclaredMethod(methodName, this.helper.getJavaClassArray(methodParameters));
            if (javaMethod == null) continue;
            return javaMethod.getReturnType();
        }
        throw JAXBException.noSuchWriteTransformationMethod(methodName);
    }

    protected TransformerHelper getTransformerHelper() {
        return this.transformerHelper;
    }
}

