/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.eventhub.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.eventhub.AccessRights;
import com.microsoft.azure.management.eventhub.ErrorResponseException;
import com.microsoft.azure.management.eventhub.implementation.AccessKeysInner;
import com.microsoft.azure.management.eventhub.implementation.AuthorizationRuleInner;
import com.microsoft.azure.management.eventhub.implementation.EventHubManagementClientImpl;
import com.microsoft.azure.management.eventhub.implementation.EventhubInner;
import com.microsoft.azure.management.eventhub.implementation.PageImpl;
import com.microsoft.azure.management.eventhub.implementation.RegenerateAccessKeyParametersInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class EventHubsInner {
    private EventHubsService service;
    private EventHubManagementClientImpl client;

    public EventHubsInner(Retrofit retrofit, EventHubManagementClientImpl client) {
        this.service = (EventHubsService)retrofit.create(EventHubsService.class);
        this.client = client;
    }

    public PagedList<EventhubInner> listByNamespace(String resourceGroupName, String namespaceName) {
        ServiceResponse response = (ServiceResponse)this.listByNamespaceSinglePageAsync(resourceGroupName, namespaceName).toBlocking().single();
        return new PagedList<EventhubInner>((Page)response.body()){

            public Page<EventhubInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)EventHubsInner.this.listByNamespaceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<EventhubInner>> listByNamespaceAsync(String resourceGroupName, String namespaceName, ListOperationCallback<EventhubInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByNamespaceSinglePageAsync(resourceGroupName, namespaceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<EventhubInner>>>>(){

            public Observable<ServiceResponse<Page<EventhubInner>>> call(String nextPageLink) {
                return EventHubsInner.this.listByNamespaceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<EventhubInner>> listByNamespaceAsync(String resourceGroupName, String namespaceName) {
        return this.listByNamespaceWithServiceResponseAsync(resourceGroupName, namespaceName).map((Func1)new Func1<ServiceResponse<Page<EventhubInner>>, Page<EventhubInner>>(){

            public Page<EventhubInner> call(ServiceResponse<Page<EventhubInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<EventhubInner>>> listByNamespaceWithServiceResponseAsync(String resourceGroupName, String namespaceName) {
        return this.listByNamespaceSinglePageAsync(resourceGroupName, namespaceName).concatMap((Func1)new Func1<ServiceResponse<Page<EventhubInner>>, Observable<ServiceResponse<Page<EventhubInner>>>>(){

            public Observable<ServiceResponse<Page<EventhubInner>>> call(ServiceResponse<Page<EventhubInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(EventHubsInner.this.listByNamespaceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<EventhubInner>>> listByNamespaceSinglePageAsync(String resourceGroupName, String namespaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByNamespace(resourceGroupName, namespaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EventhubInner>>>>(){

            public Observable<ServiceResponse<Page<EventhubInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = EventHubsInner.this.listByNamespaceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<EventhubInner>> listByNamespaceDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<EventhubInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public EventhubInner createOrUpdate(String resourceGroupName, String namespaceName, String eventHubName, EventhubInner parameters) {
        return (EventhubInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<EventhubInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String eventHubName, EventhubInner parameters, ServiceCallback<EventhubInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, parameters), serviceCallback);
    }

    public Observable<EventhubInner> createOrUpdateAsync(String resourceGroupName, String namespaceName, String eventHubName, EventhubInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, parameters).map((Func1)new Func1<ServiceResponse<EventhubInner>, EventhubInner>(){

            public EventhubInner call(ServiceResponse<EventhubInner> response) {
                return (EventhubInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<EventhubInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, EventhubInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.createOrUpdate(resourceGroupName, namespaceName, eventHubName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<EventhubInner>>>(){

            public Observable<ServiceResponse<EventhubInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EventHubsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<EventhubInner> createOrUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<EventhubInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String namespaceName, String eventHubName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String namespaceName, String eventHubName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String namespaceName, String eventHubName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String namespaceName, String eventHubName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, namespaceName, eventHubName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EventHubsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public EventhubInner get(String resourceGroupName, String namespaceName, String eventHubName) {
        return (EventhubInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName).toBlocking().single()).body();
    }

    public ServiceFuture<EventhubInner> getAsync(String resourceGroupName, String namespaceName, String eventHubName, ServiceCallback<EventhubInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName), serviceCallback);
    }

    public Observable<EventhubInner> getAsync(String resourceGroupName, String namespaceName, String eventHubName) {
        return this.getWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName).map((Func1)new Func1<ServiceResponse<EventhubInner>, EventhubInner>(){

            public EventhubInner call(ServiceResponse<EventhubInner> response) {
                return (EventhubInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<EventhubInner>> getWithServiceResponseAsync(String resourceGroupName, String namespaceName, String eventHubName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, namespaceName, eventHubName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<EventhubInner>>>(){

            public Observable<ServiceResponse<EventhubInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EventHubsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<EventhubInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<EventhubInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<AuthorizationRuleInner> listAuthorizationRules(String resourceGroupName, String namespaceName, String eventHubName) {
        ServiceResponse response = (ServiceResponse)this.listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName, eventHubName).toBlocking().single();
        return new PagedList<AuthorizationRuleInner>((Page)response.body()){

            public Page<AuthorizationRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)EventHubsInner.this.listAuthorizationRulesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AuthorizationRuleInner>> listAuthorizationRulesAsync(String resourceGroupName, String namespaceName, String eventHubName, ListOperationCallback<AuthorizationRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName, eventHubName), (Func1)new Func1<String, Observable<ServiceResponse<Page<AuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> call(String nextPageLink) {
                return EventHubsInner.this.listAuthorizationRulesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AuthorizationRuleInner>> listAuthorizationRulesAsync(String resourceGroupName, String namespaceName, String eventHubName) {
        return this.listAuthorizationRulesWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName).map((Func1)new Func1<ServiceResponse<Page<AuthorizationRuleInner>>, Page<AuthorizationRuleInner>>(){

            public Page<AuthorizationRuleInner> call(ServiceResponse<Page<AuthorizationRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> listAuthorizationRulesWithServiceResponseAsync(String resourceGroupName, String namespaceName, String eventHubName) {
        return this.listAuthorizationRulesSinglePageAsync(resourceGroupName, namespaceName, eventHubName).concatMap((Func1)new Func1<ServiceResponse<Page<AuthorizationRuleInner>>, Observable<ServiceResponse<Page<AuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> call(ServiceResponse<Page<AuthorizationRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(EventHubsInner.this.listAuthorizationRulesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> listAuthorizationRulesSinglePageAsync(String resourceGroupName, String namespaceName, String eventHubName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listAuthorizationRules(resourceGroupName, namespaceName, eventHubName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = EventHubsInner.this.listAuthorizationRulesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AuthorizationRuleInner>> listAuthorizationRulesDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AuthorizationRuleInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public AuthorizationRuleInner createOrUpdateAuthorizationRule(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName, List<AccessRights> rights) {
        return (AuthorizationRuleInner)((ServiceResponse)this.createOrUpdateAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, authorizationRuleName, rights).toBlocking().single()).body();
    }

    public ServiceFuture<AuthorizationRuleInner> createOrUpdateAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName, List<AccessRights> rights, ServiceCallback<AuthorizationRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, authorizationRuleName, rights), serviceCallback);
    }

    public Observable<AuthorizationRuleInner> createOrUpdateAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName, List<AccessRights> rights) {
        return this.createOrUpdateAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, authorizationRuleName, rights).map((Func1)new Func1<ServiceResponse<AuthorizationRuleInner>, AuthorizationRuleInner>(){

            public AuthorizationRuleInner call(ServiceResponse<AuthorizationRuleInner> response) {
                return (AuthorizationRuleInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AuthorizationRuleInner>> createOrUpdateAuthorizationRuleWithServiceResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName, List<AccessRights> rights) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (rights == null) {
            throw new IllegalArgumentException("Parameter rights is required and cannot be null.");
        }
        Validator.validate(rights);
        AuthorizationRuleInner parameters = new AuthorizationRuleInner();
        parameters.withRights(rights);
        return this.service.createOrUpdateAuthorizationRule(resourceGroupName, namespaceName, eventHubName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AuthorizationRuleInner>>>(){

            public Observable<ServiceResponse<AuthorizationRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EventHubsInner.this.createOrUpdateAuthorizationRuleDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AuthorizationRuleInner> createOrUpdateAuthorizationRuleDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AuthorizationRuleInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public AuthorizationRuleInner getAuthorizationRule(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName) {
        return (AuthorizationRuleInner)((ServiceResponse)this.getAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, authorizationRuleName).toBlocking().single()).body();
    }

    public ServiceFuture<AuthorizationRuleInner> getAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName, ServiceCallback<AuthorizationRuleInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, authorizationRuleName), serviceCallback);
    }

    public Observable<AuthorizationRuleInner> getAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName) {
        return this.getAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, authorizationRuleName).map((Func1)new Func1<ServiceResponse<AuthorizationRuleInner>, AuthorizationRuleInner>(){

            public AuthorizationRuleInner call(ServiceResponse<AuthorizationRuleInner> response) {
                return (AuthorizationRuleInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AuthorizationRuleInner>> getAuthorizationRuleWithServiceResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getAuthorizationRule(resourceGroupName, namespaceName, eventHubName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AuthorizationRuleInner>>>(){

            public Observable<ServiceResponse<AuthorizationRuleInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EventHubsInner.this.getAuthorizationRuleDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AuthorizationRuleInner> getAuthorizationRuleDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AuthorizationRuleInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void deleteAuthorizationRule(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName) {
        ((ServiceResponse)this.deleteAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, authorizationRuleName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, authorizationRuleName), serviceCallback);
    }

    public Observable<Void> deleteAuthorizationRuleAsync(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName) {
        return this.deleteAuthorizationRuleWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, authorizationRuleName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteAuthorizationRuleWithServiceResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.deleteAuthorizationRule(resourceGroupName, namespaceName, eventHubName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EventHubsInner.this.deleteAuthorizationRuleDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteAuthorizationRuleDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public AccessKeysInner listKeys(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName) {
        return (AccessKeysInner)((ServiceResponse)this.listKeysWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, authorizationRuleName).toBlocking().single()).body();
    }

    public ServiceFuture<AccessKeysInner> listKeysAsync(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName, ServiceCallback<AccessKeysInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listKeysWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, authorizationRuleName), serviceCallback);
    }

    public Observable<AccessKeysInner> listKeysAsync(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName) {
        return this.listKeysWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, authorizationRuleName).map((Func1)new Func1<ServiceResponse<AccessKeysInner>, AccessKeysInner>(){

            public AccessKeysInner call(ServiceResponse<AccessKeysInner> response) {
                return (AccessKeysInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AccessKeysInner>> listKeysWithServiceResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listKeys(resourceGroupName, namespaceName, eventHubName, authorizationRuleName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AccessKeysInner>>>(){

            public Observable<ServiceResponse<AccessKeysInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EventHubsInner.this.listKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AccessKeysInner> listKeysDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AccessKeysInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public AccessKeysInner regenerateKeys(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName, RegenerateAccessKeyParametersInner parameters) {
        return (AccessKeysInner)((ServiceResponse)this.regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, authorizationRuleName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<AccessKeysInner> regenerateKeysAsync(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName, RegenerateAccessKeyParametersInner parameters, ServiceCallback<AccessKeysInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, authorizationRuleName, parameters), serviceCallback);
    }

    public Observable<AccessKeysInner> regenerateKeysAsync(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName, RegenerateAccessKeyParametersInner parameters) {
        return this.regenerateKeysWithServiceResponseAsync(resourceGroupName, namespaceName, eventHubName, authorizationRuleName, parameters).map((Func1)new Func1<ServiceResponse<AccessKeysInner>, AccessKeysInner>(){

            public AccessKeysInner call(ServiceResponse<AccessKeysInner> response) {
                return (AccessKeysInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AccessKeysInner>> regenerateKeysWithServiceResponseAsync(String resourceGroupName, String namespaceName, String eventHubName, String authorizationRuleName, RegenerateAccessKeyParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (namespaceName == null) {
            throw new IllegalArgumentException("Parameter namespaceName is required and cannot be null.");
        }
        if (eventHubName == null) {
            throw new IllegalArgumentException("Parameter eventHubName is required and cannot be null.");
        }
        if (authorizationRuleName == null) {
            throw new IllegalArgumentException("Parameter authorizationRuleName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.regenerateKeys(resourceGroupName, namespaceName, eventHubName, authorizationRuleName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AccessKeysInner>>>(){

            public Observable<ServiceResponse<AccessKeysInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EventHubsInner.this.regenerateKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AccessKeysInner> regenerateKeysDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AccessKeysInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<EventhubInner> listByNamespaceNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByNamespaceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<EventhubInner>((Page)response.body()){

            public Page<EventhubInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)EventHubsInner.this.listByNamespaceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<EventhubInner>> listByNamespaceNextAsync(String nextPageLink, ServiceFuture<List<EventhubInner>> serviceFuture, ListOperationCallback<EventhubInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByNamespaceNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<EventhubInner>>>>(){

            public Observable<ServiceResponse<Page<EventhubInner>>> call(String nextPageLink) {
                return EventHubsInner.this.listByNamespaceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<EventhubInner>> listByNamespaceNextAsync(String nextPageLink) {
        return this.listByNamespaceNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<EventhubInner>>, Page<EventhubInner>>(){

            public Page<EventhubInner> call(ServiceResponse<Page<EventhubInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<EventhubInner>>> listByNamespaceNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByNamespaceNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<EventhubInner>>, Observable<ServiceResponse<Page<EventhubInner>>>>(){

            public Observable<ServiceResponse<Page<EventhubInner>>> call(ServiceResponse<Page<EventhubInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(EventHubsInner.this.listByNamespaceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<EventhubInner>>> listByNamespaceNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByNamespaceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EventhubInner>>>>(){

            public Observable<ServiceResponse<Page<EventhubInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = EventHubsInner.this.listByNamespaceNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<EventhubInner>> listByNamespaceNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<EventhubInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<AuthorizationRuleInner> listAuthorizationRulesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAuthorizationRulesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AuthorizationRuleInner>((Page)response.body()){

            public Page<AuthorizationRuleInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)EventHubsInner.this.listAuthorizationRulesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AuthorizationRuleInner>> listAuthorizationRulesNextAsync(String nextPageLink, ServiceFuture<List<AuthorizationRuleInner>> serviceFuture, ListOperationCallback<AuthorizationRuleInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAuthorizationRulesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> call(String nextPageLink) {
                return EventHubsInner.this.listAuthorizationRulesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AuthorizationRuleInner>> listAuthorizationRulesNextAsync(String nextPageLink) {
        return this.listAuthorizationRulesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AuthorizationRuleInner>>, Page<AuthorizationRuleInner>>(){

            public Page<AuthorizationRuleInner> call(ServiceResponse<Page<AuthorizationRuleInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> listAuthorizationRulesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAuthorizationRulesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AuthorizationRuleInner>>, Observable<ServiceResponse<Page<AuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> call(ServiceResponse<Page<AuthorizationRuleInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(EventHubsInner.this.listAuthorizationRulesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> listAuthorizationRulesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAuthorizationRulesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AuthorizationRuleInner>>>>(){

            public Observable<ServiceResponse<Page<AuthorizationRuleInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = EventHubsInner.this.listAuthorizationRulesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AuthorizationRuleInner>> listAuthorizationRulesNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AuthorizationRuleInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface EventHubsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.EventHubs listByNamespace"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs")
        public Observable<Response<ResponseBody>> listByNamespace(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.EventHubs createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="eventHubName") String var3, @Path(value="subscriptionId") String var4, @Body EventhubInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.EventHubs delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="eventHubName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.EventHubs get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="eventHubName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.EventHubs listAuthorizationRules"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules")
        public Observable<Response<ResponseBody>> listAuthorizationRules(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="eventHubName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.EventHubs createOrUpdateAuthorizationRule"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules/{authorizationRuleName}")
        public Observable<Response<ResponseBody>> createOrUpdateAuthorizationRule(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="eventHubName") String var3, @Path(value="authorizationRuleName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body AuthorizationRuleInner var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.EventHubs getAuthorizationRule"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules/{authorizationRuleName}")
        public Observable<Response<ResponseBody>> getAuthorizationRule(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="eventHubName") String var3, @Path(value="authorizationRuleName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.EventHubs deleteAuthorizationRule"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules/{authorizationRuleName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteAuthorizationRule(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="eventHubName") String var3, @Path(value="authorizationRuleName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.EventHubs listKeys"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules/{authorizationRuleName}/ListKeys")
        public Observable<Response<ResponseBody>> listKeys(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="eventHubName") String var3, @Path(value="authorizationRuleName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.EventHubs regenerateKeys"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules/{authorizationRuleName}/regenerateKeys")
        public Observable<Response<ResponseBody>> regenerateKeys(@Path(value="resourceGroupName") String var1, @Path(value="namespaceName") String var2, @Path(value="eventHubName") String var3, @Path(value="authorizationRuleName") String var4, @Path(value="subscriptionId") String var5, @Body RegenerateAccessKeyParametersInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.EventHubs listByNamespaceNext"})
        @GET
        public Observable<Response<ResponseBody>> listByNamespaceNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.eventhub.EventHubs listAuthorizationRulesNext"})
        @GET
        public Observable<Response<ResponseBody>> listAuthorizationRulesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

