/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.IndependentChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.servicebus.EntityStatus;
import com.microsoft.azure.management.servicebus.Queue;
import com.microsoft.azure.management.servicebus.QueueAuthorizationRule;
import com.microsoft.azure.management.servicebus.implementation.AuthorizationRuleBaseImpl;
import com.microsoft.azure.management.servicebus.implementation.QueueAuthorizationRulesImpl;
import com.microsoft.azure.management.servicebus.implementation.QueueInner;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManagementClientImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManager;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusNamespaceImpl;
import com.microsoft.azure.management.servicebus.implementation.TimeSpan;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Period;
import rx.Completable;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Func1;

@LangDefinition
class QueueImpl
extends IndependentChildResourceImpl<Queue, ServiceBusNamespaceImpl, QueueInner, QueueImpl, ServiceBusManager>
implements Queue,
Queue.Definition,
Queue.Update {
    private List<Creatable<QueueAuthorizationRule>> rulesToCreate;
    private List<String> rulesToDelete;

    QueueImpl(String resourceGroupName, String namespaceName, String name, Region region, QueueInner inner, ServiceBusManager manager) {
        super(name, (Resource)inner, (Object)manager);
        this.withExistingParentResource(resourceGroupName, namespaceName);
        this.initChildrenOperationsCache();
        if (inner.location() == null) {
            inner.withLocation(region.toString());
        }
    }

    @Override
    public DateTime createdAt() {
        return ((QueueInner)((Object)this.inner())).createdAt();
    }

    @Override
    public DateTime accessedAt() {
        return ((QueueInner)((Object)this.inner())).accessedAt();
    }

    @Override
    public DateTime updatedAt() {
        return ((QueueInner)((Object)this.inner())).updatedAt();
    }

    @Override
    public long maxSizeInMB() {
        return Utils.toPrimitiveLong((Long)((QueueInner)((Object)this.inner())).maxSizeInMegabytes());
    }

    @Override
    public long currentSizeInBytes() {
        return Utils.toPrimitiveLong((Long)((QueueInner)((Object)this.inner())).sizeInBytes());
    }

    @Override
    public boolean isBatchedOperationsEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((QueueInner)((Object)this.inner())).enableBatchedOperations());
    }

    @Override
    public boolean isDeadLetteringEnabledForExpiredMessages() {
        return Utils.toPrimitiveBoolean((Boolean)((QueueInner)((Object)this.inner())).deadLetteringOnMessageExpiration());
    }

    @Override
    public boolean isExpressEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((QueueInner)((Object)this.inner())).enableExpress());
    }

    @Override
    public boolean isPartitioningEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((QueueInner)((Object)this.inner())).enablePartitioning());
    }

    @Override
    public boolean isSessionEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((QueueInner)((Object)this.inner())).requiresSession());
    }

    @Override
    public boolean isDuplicateDetectionEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((QueueInner)((Object)this.inner())).requiresDuplicateDetection());
    }

    @Override
    public long lockDurationInSeconds() {
        if (((QueueInner)((Object)this.inner())).lockDuration() == null) {
            return 0L;
        }
        TimeSpan timeSpan = TimeSpan.parse(((QueueInner)((Object)this.inner())).lockDuration());
        return (long)timeSpan.totalSeconds();
    }

    @Override
    public long deleteOnIdleDurationInMinutes() {
        if (((QueueInner)((Object)this.inner())).autoDeleteOnIdle() == null) {
            return 0L;
        }
        TimeSpan timeSpan = TimeSpan.parse(((QueueInner)((Object)this.inner())).autoDeleteOnIdle());
        return (long)timeSpan.totalMinutes();
    }

    @Override
    public Period defaultMessageTtlDuration() {
        if (((QueueInner)((Object)this.inner())).defaultMessageTimeToLive() == null) {
            return null;
        }
        TimeSpan timeSpan = TimeSpan.parse(((QueueInner)((Object)this.inner())).defaultMessageTimeToLive());
        return new Period().withDays(timeSpan.days()).withHours(timeSpan.hours()).withSeconds(timeSpan.seconds()).withMinutes(timeSpan.minutes()).withMillis(timeSpan.milliseconds());
    }

    @Override
    public Period duplicateMessageDetectionHistoryDuration() {
        if (((QueueInner)((Object)this.inner())).duplicateDetectionHistoryTimeWindow() == null) {
            return null;
        }
        TimeSpan timeSpan = TimeSpan.parse(((QueueInner)((Object)this.inner())).duplicateDetectionHistoryTimeWindow());
        return new Period().withDays(timeSpan.days()).withHours(timeSpan.hours()).withMinutes(timeSpan.minutes()).withSeconds(timeSpan.seconds()).withMillis(timeSpan.milliseconds());
    }

    @Override
    public int maxDeliveryCountBeforeDeadLetteringMessage() {
        return Utils.toPrimitiveInt((Integer)((QueueInner)((Object)this.inner())).maxDeliveryCount());
    }

    @Override
    public long messageCount() {
        return Utils.toPrimitiveLong((Long)((QueueInner)((Object)this.inner())).messageCount());
    }

    @Override
    public long activeMessageCount() {
        if (((QueueInner)((Object)this.inner())).countDetails() == null || ((QueueInner)((Object)this.inner())).countDetails().activeMessageCount() == null) {
            return 0L;
        }
        return Utils.toPrimitiveLong((Long)((QueueInner)((Object)this.inner())).countDetails().activeMessageCount());
    }

    @Override
    public long deadLetterMessageCount() {
        if (((QueueInner)((Object)this.inner())).countDetails() == null || ((QueueInner)((Object)this.inner())).countDetails().deadLetterMessageCount() == null) {
            return 0L;
        }
        return Utils.toPrimitiveLong((Long)((QueueInner)((Object)this.inner())).countDetails().deadLetterMessageCount());
    }

    @Override
    public long scheduledMessageCount() {
        if (((QueueInner)((Object)this.inner())).countDetails() == null || ((QueueInner)((Object)this.inner())).countDetails().scheduledMessageCount() == null) {
            return 0L;
        }
        return Utils.toPrimitiveLong((Long)((QueueInner)((Object)this.inner())).countDetails().scheduledMessageCount());
    }

    @Override
    public long transferDeadLetterMessageCount() {
        if (((QueueInner)((Object)this.inner())).countDetails() == null || ((QueueInner)((Object)this.inner())).countDetails().transferDeadLetterMessageCount() == null) {
            return 0L;
        }
        return Utils.toPrimitiveLong((Long)((QueueInner)((Object)this.inner())).countDetails().transferDeadLetterMessageCount());
    }

    @Override
    public long transferMessageCount() {
        if (((QueueInner)((Object)this.inner())).countDetails() == null || ((QueueInner)((Object)this.inner())).countDetails().transferMessageCount() == null) {
            return 0L;
        }
        return Utils.toPrimitiveLong((Long)((QueueInner)((Object)this.inner())).countDetails().transferMessageCount());
    }

    @Override
    public EntityStatus status() {
        return ((QueueInner)((Object)this.inner())).status();
    }

    @Override
    public QueueAuthorizationRulesImpl authorizationRules() {
        return new QueueAuthorizationRulesImpl(this.resourceGroupName(), this.parentName, this.name(), this.region(), (ServiceBusManager)((Object)this.manager()));
    }

    @Override
    public QueueImpl withSizeInMB(long sizeInMB) {
        ((QueueInner)((Object)this.inner())).withMaxSizeInMegabytes(sizeInMB);
        return this;
    }

    @Override
    public QueueImpl withPartitioning() {
        ((QueueInner)((Object)this.inner())).withEnablePartitioning(true);
        return this;
    }

    @Override
    public QueueImpl withoutPartitioning() {
        ((QueueInner)((Object)this.inner())).withEnablePartitioning(false);
        return this;
    }

    @Override
    public QueueImpl withDeleteOnIdleDurationInMinutes(int durationInMinutes) {
        TimeSpan timeSpan = new TimeSpan().withMinutes(durationInMinutes);
        ((QueueInner)((Object)this.inner())).withAutoDeleteOnIdle(timeSpan.toString());
        return this;
    }

    @Override
    public QueueImpl withMessageLockDurationInSeconds(int durationInSeconds) {
        TimeSpan timeSpan = new TimeSpan().withSeconds(durationInSeconds);
        ((QueueInner)((Object)this.inner())).withLockDuration(timeSpan.toString());
        return this;
    }

    @Override
    public QueueImpl withDefaultMessageTTL(Period ttl) {
        ((QueueInner)((Object)this.inner())).withDefaultMessageTimeToLive(TimeSpan.fromPeriod(ttl).toString());
        return this;
    }

    @Override
    public QueueImpl withSession() {
        ((QueueInner)((Object)this.inner())).withRequiresSession(true);
        return this;
    }

    @Override
    public QueueImpl withoutSession() {
        ((QueueInner)((Object)this.inner())).withRequiresSession(false);
        return this;
    }

    @Override
    public QueueImpl withExpressMessage() {
        ((QueueInner)((Object)this.inner())).withEnableExpress(true);
        return this;
    }

    @Override
    public QueueImpl withoutExpressMessage() {
        ((QueueInner)((Object)this.inner())).withEnableExpress(false);
        return this;
    }

    @Override
    public QueueImpl withMessageBatching() {
        ((QueueInner)((Object)this.inner())).withEnableBatchedOperations(true);
        return this;
    }

    @Override
    public QueueImpl withoutMessageBatching() {
        ((QueueInner)((Object)this.inner())).withEnableBatchedOperations(false);
        return this;
    }

    @Override
    public QueueImpl withExpiredMessageMovedToDeadLetterQueue() {
        ((QueueInner)((Object)this.inner())).withDeadLetteringOnMessageExpiration(true);
        return this;
    }

    @Override
    public QueueImpl withoutExpiredMessageMovedToDeadLetterQueue() {
        ((QueueInner)((Object)this.inner())).withDeadLetteringOnMessageExpiration(false);
        return this;
    }

    @Override
    public QueueImpl withMessageMovedToDeadLetterQueueOnMaxDeliveryCount(int deliveryCount) {
        ((QueueInner)((Object)this.inner())).withMaxDeliveryCount(deliveryCount);
        return this;
    }

    @Override
    public QueueImpl withDuplicateMessageDetection(Period duplicateDetectionHistoryDuration) {
        ((QueueInner)((Object)this.inner())).withRequiresDuplicateDetection(true);
        ((QueueInner)((Object)this.inner())).withDuplicateDetectionHistoryTimeWindow(TimeSpan.fromPeriod(duplicateDetectionHistoryDuration).toString());
        return this;
    }

    @Override
    public QueueImpl withDuplicateMessageDetectionHistoryDuration(Period duration) {
        return this.withDuplicateMessageDetection(duration);
    }

    @Override
    public QueueImpl withoutDuplicateMessageDetection() {
        ((QueueInner)((Object)this.inner())).withRequiresDuplicateDetection(false);
        return this;
    }

    @Override
    public QueueImpl withNewSendRule(String name) {
        this.rulesToCreate.add((Creatable<QueueAuthorizationRule>)((AuthorizationRuleBaseImpl)this.authorizationRules().define(name)).withSendingEnabled());
        return this;
    }

    @Override
    public QueueImpl withNewListenRule(String name) {
        this.rulesToCreate.add((Creatable<QueueAuthorizationRule>)((AuthorizationRuleBaseImpl)this.authorizationRules().define(name)).withListeningEnabled());
        return this;
    }

    @Override
    public QueueImpl withNewManageRule(String name) {
        this.rulesToCreate.add((Creatable<QueueAuthorizationRule>)((AuthorizationRuleBaseImpl)this.authorizationRules().define(name)).withManagementEnabled());
        return this;
    }

    @Override
    public QueueImpl withoutAuthorizationRule(String name) {
        this.rulesToDelete.add(name);
        return this;
    }

    protected Observable<QueueInner> getInnerAsync() {
        return ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)((Object)this.manager())).inner())).queues().getAsync(this.resourceGroupName(), this.parentName, this.name());
    }

    protected Observable<Queue> createChildResourceAsync() {
        Completable createQueueCompletable = ((ServiceBusManagementClientImpl)((Object)((ServiceBusManager)((Object)this.manager())).inner())).queues().createOrUpdateAsync(this.resourceGroupName(), this.parentName, this.name(), (QueueInner)((Object)this.inner())).map((Func1)new Func1<QueueInner, QueueInner>(){

            public QueueInner call(QueueInner inner) {
                QueueImpl.this.setInner((Object)inner);
                return inner;
            }
        }).toCompletable();
        Completable childrenOperationsCompletable = this.submitChildrenOperationsAsync();
        QueueImpl self = this;
        return Completable.concat((Completable[])new Completable[]{createQueueCompletable, childrenOperationsCompletable}).doOnTerminate(new Action0(){

            public void call() {
                QueueImpl.this.initChildrenOperationsCache();
            }
        }).andThen(Observable.just((Object)self));
    }

    private void initChildrenOperationsCache() {
        this.rulesToCreate = new ArrayList<Creatable<QueueAuthorizationRule>>();
        this.rulesToDelete = new ArrayList<String>();
    }

    private Completable submitChildrenOperationsAsync() {
        Observable rulesCreateStream = Observable.empty();
        if (this.rulesToCreate.size() > 0) {
            rulesCreateStream = this.authorizationRules().createAsync(this.rulesToCreate);
        }
        Observable<String> rulesDeleteStream = Observable.empty();
        if (this.rulesToDelete.size() > 0) {
            rulesDeleteStream = this.authorizationRules().deleteByNameAsync(this.rulesToDelete);
        }
        return Completable.mergeDelayError((Completable[])new Completable[]{rulesCreateStream.toCompletable(), rulesDeleteStream.toCompletable()});
    }
}

