/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.trafficmanager.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesCachedImpl;
import com.microsoft.azure.management.trafficmanager.EndpointType;
import com.microsoft.azure.management.trafficmanager.TrafficManagerAzureEndpoint;
import com.microsoft.azure.management.trafficmanager.TrafficManagerEndpoint;
import com.microsoft.azure.management.trafficmanager.TrafficManagerExternalEndpoint;
import com.microsoft.azure.management.trafficmanager.TrafficManagerNestedProfileEndpoint;
import com.microsoft.azure.management.trafficmanager.TrafficManagerProfile;
import com.microsoft.azure.management.trafficmanager.implementation.EndpointInner;
import com.microsoft.azure.management.trafficmanager.implementation.EndpointsInner;
import com.microsoft.azure.management.trafficmanager.implementation.ProfileInner;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerAzureEndpointImpl;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerEndpointImpl;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerExternalEndpointImpl;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerNestedProfileEndpointImpl;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerProfileImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@LangDefinition
class TrafficManagerEndpointsImpl
extends ExternalChildResourcesCachedImpl<TrafficManagerEndpointImpl, TrafficManagerEndpoint, EndpointInner, TrafficManagerProfileImpl, TrafficManagerProfile> {
    private final EndpointsInner client;

    TrafficManagerEndpointsImpl(EndpointsInner client, TrafficManagerProfileImpl parent) {
        super((Object)parent, parent.taskGroup(), "Endpoint");
        this.client = client;
        this.cacheCollection();
    }

    List<EndpointInner> allEndpointsInners() {
        ArrayList<EndpointInner> allEndpoints = new ArrayList<EndpointInner>();
        for (TrafficManagerEndpointImpl epImpl : this.collection().values()) {
            allEndpoints.add((EndpointInner)epImpl.inner());
        }
        return allEndpoints;
    }

    Map<String, TrafficManagerAzureEndpoint> azureEndpointsAsMap() {
        HashMap result = new HashMap();
        for (Map.Entry entry : this.collection().entrySet()) {
            TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)entry.getValue();
            if (endpoint.endpointType() != EndpointType.AZURE) continue;
            TrafficManagerAzureEndpointImpl azureEndpoint = new TrafficManagerAzureEndpointImpl((String)entry.getKey(), (TrafficManagerProfileImpl)this.parent(), (EndpointInner)endpoint.inner(), this.client);
            result.put(entry.getKey(), azureEndpoint);
        }
        return Collections.unmodifiableMap(result);
    }

    Map<String, TrafficManagerExternalEndpoint> externalEndpointsAsMap() {
        HashMap result = new HashMap();
        for (Map.Entry entry : this.collection().entrySet()) {
            TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)entry.getValue();
            if (endpoint.endpointType() != EndpointType.EXTERNAL) continue;
            TrafficManagerExternalEndpointImpl externalEndpoint = new TrafficManagerExternalEndpointImpl((String)entry.getKey(), (TrafficManagerProfileImpl)this.parent(), (EndpointInner)endpoint.inner(), this.client);
            result.put(entry.getKey(), externalEndpoint);
        }
        return Collections.unmodifiableMap(result);
    }

    Map<String, TrafficManagerNestedProfileEndpoint> nestedProfileEndpointsAsMap() {
        HashMap result = new HashMap();
        for (Map.Entry entry : this.collection().entrySet()) {
            TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)entry.getValue();
            if (endpoint.endpointType() != EndpointType.NESTED_PROFILE) continue;
            TrafficManagerNestedProfileEndpointImpl nestedProfileEndpoint = new TrafficManagerNestedProfileEndpointImpl((String)entry.getKey(), (TrafficManagerProfileImpl)this.parent(), (EndpointInner)endpoint.inner(), this.client);
            result.put(entry.getKey(), nestedProfileEndpoint);
        }
        return Collections.unmodifiableMap(result);
    }

    public TrafficManagerEndpointImpl defineAzureTargetEndpoint(String name) {
        TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)this.prepareInlineDefine(name);
        endpoint.withEndpointType(EndpointType.AZURE);
        return endpoint;
    }

    public TrafficManagerEndpointImpl defineExteralTargetEndpoint(String name) {
        TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)this.prepareInlineDefine(name);
        endpoint.withEndpointType(EndpointType.EXTERNAL);
        return endpoint;
    }

    public TrafficManagerEndpointImpl defineNestedProfileTargetEndpoint(String name) {
        TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)this.prepareInlineDefine(name);
        endpoint.withEndpointType(EndpointType.NESTED_PROFILE);
        return endpoint;
    }

    public TrafficManagerEndpointImpl updateAzureEndpoint(String name) {
        TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)this.prepareInlineUpdate(name);
        if (endpoint.endpointType() != EndpointType.AZURE) {
            throw new IllegalArgumentException("An azure endpoint with name " + name + " not found in the profile");
        }
        return endpoint;
    }

    public TrafficManagerEndpointImpl updateExternalEndpoint(String name) {
        TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)this.prepareInlineUpdate(name);
        if (endpoint.endpointType() != EndpointType.EXTERNAL) {
            throw new IllegalArgumentException("An external endpoint with name " + name + " not found in the profile");
        }
        return endpoint;
    }

    public TrafficManagerEndpointImpl updateNestedProfileEndpoint(String name) {
        TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)this.prepareInlineUpdate(name);
        if (endpoint.endpointType() != EndpointType.NESTED_PROFILE) {
            throw new IllegalArgumentException("A nested profile endpoint with name " + name + " not found in the profile");
        }
        return endpoint;
    }

    public void remove(String name) {
        this.prepareInlineRemove(name);
    }

    public void addEndpoint(TrafficManagerEndpointImpl endpoint) {
        this.addChildResource(endpoint);
    }

    protected List<TrafficManagerEndpointImpl> listChildResources() {
        ArrayList<TrafficManagerEndpointImpl> childResources = new ArrayList<TrafficManagerEndpointImpl>();
        if (((ProfileInner)((Object)((TrafficManagerProfileImpl)this.parent()).inner())).endpoints() != null) {
            for (EndpointInner inner : ((ProfileInner)((Object)((TrafficManagerProfileImpl)this.parent()).inner())).endpoints()) {
                childResources.add(new TrafficManagerEndpointImpl(inner.name(), (TrafficManagerProfileImpl)this.parent(), inner, this.client));
            }
        }
        return childResources;
    }

    protected TrafficManagerEndpointImpl newChildResource(String name) {
        TrafficManagerEndpointImpl endpoint = new TrafficManagerEndpointImpl(name, (TrafficManagerProfileImpl)this.parent(), new EndpointInner(), this.client);
        return endpoint.withRoutingWeight(1).withTrafficEnabled();
    }
}

