/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.SnapshotSku;
import com.microsoft.azure.management.compute.SnapshotStorageAccountTypes;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@Beta(value=Beta.SinceVersion.V1_8_0)
@LangDefinition
public final class SnapshotSkuType {
    private static final Map<String, SnapshotSkuType> VALUES_BY_NAME = new HashMap<String, SnapshotSkuType>();
    public static final SnapshotSkuType STANDARD_LRS = new SnapshotSkuType(SnapshotStorageAccountTypes.STANDARD_LRS);
    public static final SnapshotSkuType PREMIUM_LRS = new SnapshotSkuType(SnapshotStorageAccountTypes.PREMIUM_LRS);
    public static final SnapshotSkuType STANDARD_ZRS = new SnapshotSkuType(SnapshotStorageAccountTypes.STANDARD_ZRS);
    private SnapshotStorageAccountTypes value;

    public static SnapshotSkuType[] values() {
        Collection<SnapshotSkuType> valuesCollection = VALUES_BY_NAME.values();
        return valuesCollection.toArray(new SnapshotSkuType[valuesCollection.size()]);
    }

    private SnapshotSkuType(SnapshotStorageAccountTypes value) {
        this.value = value;
        if (value != null) {
            VALUES_BY_NAME.put(value.toString().toLowerCase(), this);
        }
    }

    public static SnapshotSkuType fromStorageAccountType(SnapshotStorageAccountTypes value) {
        if (value == null) {
            return null;
        }
        SnapshotSkuType result = VALUES_BY_NAME.get(value.toString().toLowerCase());
        if (result != null) {
            return result;
        }
        return new SnapshotSkuType(value);
    }

    public static SnapshotSkuType fromSnapshotSku(SnapshotSku snapshotSku) {
        if (snapshotSku == null || snapshotSku.name() == null) {
            return null;
        }
        return SnapshotSkuType.fromStorageAccountType(snapshotSku.name());
    }

    public SnapshotStorageAccountTypes accountType() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SnapshotSkuType)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.value == null) {
            return ((SnapshotSkuType)obj).value == null;
        }
        return this.value.equals((Object)((SnapshotSkuType)obj).value);
    }

    public String toString() {
        return this.value.toString();
    }
}

