/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.ResourceIdentityType;
import com.microsoft.azure.management.compute.VirtualMachineIdentity;
import com.microsoft.azure.management.compute.VirtualMachineIdentityUserAssignedIdentitiesValue;
import com.microsoft.azure.management.compute.VirtualMachineUpdate;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineInner;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.RoleAssignmentHelper;
import com.microsoft.azure.management.msi.Identity;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskGroup;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@LangDefinition
class VirtualMachineMsiHandler
extends RoleAssignmentHelper {
    private final VirtualMachineImpl virtualMachine;
    private List<String> creatableIdentityKeys;
    private Map<String, VirtualMachineIdentityUserAssignedIdentitiesValue> userAssignedIdentities;

    VirtualMachineMsiHandler(GraphRbacManager rbacManager, VirtualMachineImpl virtualMachine) {
        super(rbacManager, virtualMachine.taskGroup(), virtualMachine.idProvider());
        this.virtualMachine = virtualMachine;
        this.creatableIdentityKeys = new ArrayList<String>();
        this.userAssignedIdentities = new HashMap<String, VirtualMachineIdentityUserAssignedIdentitiesValue>();
    }

    VirtualMachineMsiHandler withLocalManagedServiceIdentity() {
        this.initVMIdentity(ResourceIdentityType.SYSTEM_ASSIGNED);
        return this;
    }

    VirtualMachineMsiHandler withoutLocalManagedServiceIdentity() {
        if (((VirtualMachineInner)((Object)this.virtualMachine.inner())).identity() == null || ((VirtualMachineInner)((Object)this.virtualMachine.inner())).identity().type() == null || ((VirtualMachineInner)((Object)this.virtualMachine.inner())).identity().type().equals((Object)ResourceIdentityType.NONE) || ((VirtualMachineInner)((Object)this.virtualMachine.inner())).identity().type().equals((Object)ResourceIdentityType.USER_ASSIGNED)) {
            return this;
        }
        if (((VirtualMachineInner)((Object)this.virtualMachine.inner())).identity().type().equals((Object)ResourceIdentityType.SYSTEM_ASSIGNED)) {
            ((VirtualMachineInner)((Object)this.virtualMachine.inner())).identity().withType(ResourceIdentityType.NONE);
        } else if (((VirtualMachineInner)((Object)this.virtualMachine.inner())).identity().type().equals((Object)ResourceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED)) {
            ((VirtualMachineInner)((Object)this.virtualMachine.inner())).identity().withType(ResourceIdentityType.USER_ASSIGNED);
        }
        return this;
    }

    VirtualMachineMsiHandler withNewExternalManagedServiceIdentity(Creatable<Identity> creatableIdentity) {
        this.initVMIdentity(ResourceIdentityType.USER_ASSIGNED);
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)creatableIdentity;
        Objects.requireNonNull(dependency);
        this.virtualMachine.taskGroup().addDependency(dependency);
        this.creatableIdentityKeys.add(creatableIdentity.key());
        return this;
    }

    VirtualMachineMsiHandler withExistingExternalManagedServiceIdentity(Identity identity) {
        this.initVMIdentity(ResourceIdentityType.USER_ASSIGNED);
        this.userAssignedIdentities.put(identity.id(), new VirtualMachineIdentityUserAssignedIdentitiesValue());
        return this;
    }

    VirtualMachineMsiHandler withoutExternalManagedServiceIdentity(String identityId) {
        this.userAssignedIdentities.put(identityId, null);
        return this;
    }

    void processCreatedExternalIdentities() {
        for (String key : this.creatableIdentityKeys) {
            Identity identity = (Identity)this.virtualMachine.taskGroup().taskResult(key);
            Objects.requireNonNull(identity);
            this.userAssignedIdentities.put(identity.id(), new VirtualMachineIdentityUserAssignedIdentitiesValue());
        }
        this.creatableIdentityKeys.clear();
    }

    void handleExternalIdentities() {
        if (!this.userAssignedIdentities.isEmpty()) {
            ((VirtualMachineInner)((Object)this.virtualMachine.inner())).identity().withUserAssignedIdentities(this.userAssignedIdentities);
        }
    }

    void handleExternalIdentities(VirtualMachineUpdate vmUpdate) {
        if (this.handleRemoveAllExternalIdentitiesCase(vmUpdate)) {
            return;
        }
        VirtualMachineIdentity currentIdentity = ((VirtualMachineInner)((Object)this.virtualMachine.inner())).identity();
        vmUpdate.withIdentity(currentIdentity);
        if (!this.userAssignedIdentities.isEmpty()) {
            vmUpdate.identity().withUserAssignedIdentities(this.userAssignedIdentities);
        } else if (currentIdentity != null) {
            currentIdentity.withUserAssignedIdentities(null);
        }
    }

    void clear() {
        this.userAssignedIdentities = new HashMap<String, VirtualMachineIdentityUserAssignedIdentitiesValue>();
    }

    private boolean handleRemoveAllExternalIdentitiesCase(VirtualMachineUpdate vmUpdate) {
        if (!this.userAssignedIdentities.isEmpty()) {
            boolean containsRemoveOnly;
            int rmCount = 0;
            for (VirtualMachineIdentityUserAssignedIdentitiesValue v : this.userAssignedIdentities.values()) {
                if (v != null) break;
                ++rmCount;
            }
            boolean bl = containsRemoveOnly = rmCount > 0 && rmCount == this.userAssignedIdentities.size();
            if (containsRemoveOnly) {
                boolean bl2;
                HashSet<String> currentIds = new HashSet<String>();
                VirtualMachineIdentity currentIdentity = ((VirtualMachineInner)((Object)this.virtualMachine.inner())).identity();
                if (currentIdentity != null && currentIdentity.userAssignedIdentities() != null) {
                    for (String string : currentIdentity.userAssignedIdentities().keySet()) {
                        currentIds.add(string.toLowerCase());
                    }
                }
                HashSet<String> removeIds = new HashSet<String>();
                for (Map.Entry<String, VirtualMachineIdentityUserAssignedIdentitiesValue> entrySet : this.userAssignedIdentities.entrySet()) {
                    if (entrySet.getValue() != null) continue;
                    removeIds.add(entrySet.getKey().toLowerCase());
                }
                boolean bl3 = bl2 = currentIds.size() == removeIds.size() && currentIds.containsAll(removeIds);
                if (bl2) {
                    if (currentIdentity == null || currentIdentity.type() == null) {
                        vmUpdate.withIdentity(new VirtualMachineIdentity().withType(ResourceIdentityType.NONE));
                    } else if (currentIdentity.type().equals((Object)ResourceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED)) {
                        vmUpdate.withIdentity(currentIdentity);
                        vmUpdate.identity().withType(ResourceIdentityType.SYSTEM_ASSIGNED);
                    } else if (currentIdentity.type().equals((Object)ResourceIdentityType.USER_ASSIGNED)) {
                        vmUpdate.withIdentity(currentIdentity);
                        vmUpdate.identity().withType(ResourceIdentityType.NONE);
                    }
                    vmUpdate.identity().withUserAssignedIdentities(null);
                    return true;
                }
                if (currentIds.size() == 0 && removeIds.size() != 0 && currentIdentity == null) {
                    vmUpdate.withIdentity(new VirtualMachineIdentity().withType(ResourceIdentityType.NONE));
                    vmUpdate.identity().withUserAssignedIdentities(null);
                    return true;
                }
            }
        }
        return false;
    }

    private void initVMIdentity(ResourceIdentityType identityType) {
        if (!identityType.equals((Object)ResourceIdentityType.USER_ASSIGNED) && !identityType.equals((Object)ResourceIdentityType.SYSTEM_ASSIGNED)) {
            throw new IllegalArgumentException("Invalid argument: " + (Object)((Object)identityType));
        }
        VirtualMachineInner virtualMachineInner = (VirtualMachineInner)((Object)this.virtualMachine.inner());
        if (virtualMachineInner.identity() == null) {
            virtualMachineInner.withIdentity(new VirtualMachineIdentity());
        }
        if (virtualMachineInner.identity().type() == null || virtualMachineInner.identity().type().equals((Object)ResourceIdentityType.NONE) || virtualMachineInner.identity().type().equals((Object)identityType)) {
            virtualMachineInner.identity().withType(identityType);
        } else {
            virtualMachineInner.identity().withType(ResourceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED);
        }
    }
}

