/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import javax.script.ScriptEngine;
import jdk.nashorn.api.scripting.ClassFilter;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.apache.ranger.plugin.util.ScriptEngineCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NashornScriptEngineCreator
implements ScriptEngineCreator {
    private static final Logger LOG = LoggerFactory.getLogger(NashornScriptEngineCreator.class);
    private static final String[] SCRIPT_ENGINE_ARGS = new String[]{"--no-java", "--no-syntax-extensions"};
    private static final String ENGINE_NAME = "NashornScriptEngine";

    @Override
    public ScriptEngine getScriptEngine(ClassLoader clsLoader) {
        ScriptEngine ret = null;
        if (clsLoader == null) {
            clsLoader = this.getDefaultClassLoader();
        }
        try {
            NashornScriptEngineFactory factory = new NashornScriptEngineFactory();
            ret = factory.getScriptEngine(SCRIPT_ENGINE_ARGS, clsLoader, (ClassFilter)RangerClassFilter.INSTANCE);
        }
        catch (Throwable t) {
            LOG.debug("NashornScriptEngineCreator.getScriptEngine(): failed to create engine type {}", (Object)ENGINE_NAME, (Object)t);
        }
        return ret;
    }

    private static class RangerClassFilter
    implements ClassFilter {
        static final RangerClassFilter INSTANCE = new RangerClassFilter();

        private RangerClassFilter() {
        }

        public boolean exposeToScripts(String className) {
            LOG.warn("script blocked: attempt to use Java class {}", (Object)className);
            return false;
        }
    }
}

