/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh.snapshot;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.shell.cli.RaftUtils;
import org.apache.ratis.shell.cli.sh.command.AbstractRatisCommand;
import org.apache.ratis.shell.cli.sh.command.Context;

public class TakeSnapshotCommand
extends AbstractRatisCommand {
    public static final String TAKE_SNAPSHOT_TIMEOUT_OPTION_NAME = "snapshotTimeout";
    public static final String PEER_ID_OPTION_NAME = "peerId";

    public TakeSnapshotCommand(Context context) {
        super(context);
    }

    @Override
    public String getCommandName() {
        return "create";
    }

    @Override
    public int run(CommandLine cl) throws IOException {
        super.run(cl);
        long timeout = cl.hasOption(TAKE_SNAPSHOT_TIMEOUT_OPTION_NAME) ? Long.parseLong(cl.getOptionValue(TAKE_SNAPSHOT_TIMEOUT_OPTION_NAME)) : 3000L;
        try (RaftClient raftClient = RaftUtils.createClient(this.getRaftGroup());){
            RaftPeerId peerId = cl.hasOption(PEER_ID_OPTION_NAME) ? RaftPeerId.getRaftPeerId((String)cl.getOptionValue(PEER_ID_OPTION_NAME)) : null;
            RaftClientReply reply = raftClient.getSnapshotManagementApi(peerId).create(timeout);
            this.processReply(reply, () -> String.format("Failed to take snapshot of peerId %s", peerId));
            this.printf(String.format("Successful take snapshot on peerId %s, the latest snapshot index is %d", peerId, reply.getLogIndex()), new Object[0]);
        }
        return 0;
    }

    @Override
    public String getUsage() {
        return String.format("%s -%s <PEER0_HOST:PEER0_PORT,PEER1_HOST:PEER1_PORT,PEER2_HOST:PEER2_PORT> [-%s <RAFT_GROUP_ID>] [-%s <timeoutInMs>] [-%s <raftPeerId>]", this.getCommandName(), "peers", "groupid", TAKE_SNAPSHOT_TIMEOUT_OPTION_NAME, PEER_ID_OPTION_NAME);
    }

    @Override
    public String getDescription() {
        return TakeSnapshotCommand.description();
    }

    @Override
    public Options getOptions() {
        return super.getOptions().addOption(Option.builder().option(TAKE_SNAPSHOT_TIMEOUT_OPTION_NAME).hasArg().desc("timeout to wait taking snapshot in ms").build()).addOption(Option.builder().option(PEER_ID_OPTION_NAME).hasArg().desc("the id of server takeing snapshot").build());
    }

    public static String description() {
        return "Make a ratis server take snapshot";
    }
}

