/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.leader;

import java.io.IOException;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.leader.FollowerInfo;
import org.apache.ratis.server.leader.LeaderState;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.util.AwaitForSignal;
import org.apache.ratis.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LogAppender {
    public static final Logger LOG = LoggerFactory.getLogger(LogAppender.class);
    public static final Class<? extends LogAppender> DEFAULT_CLASS = ReflectionUtils.getClass(LogAppender.class.getName() + "Default", LogAppender.class);

    public static LogAppender newLogAppenderDefault(RaftServer.Division server, LeaderState leaderState, FollowerInfo f) {
        Class[] argClasses = new Class[]{RaftServer.Division.class, LeaderState.class, FollowerInfo.class};
        return ReflectionUtils.newInstance(DEFAULT_CLASS, argClasses, server, leaderState, f);
    }

    public RaftServer.Division getServer();

    default public RaftServerRpc getServerRpc() {
        return this.getServer().getRaftServer().getServerRpc();
    }

    default public RaftLog getRaftLog() {
        return this.getServer().getRaftLog();
    }

    public void start();

    public boolean isRunning();

    @Deprecated
    default public void stop() {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<?> stopAsync() {
        this.stop();
        return CompletableFuture.supplyAsync(() -> {
            while (this.isRunning()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new CompletionException("stopAsync interrupted", e);
                }
            }
            return null;
        });
    }

    public LeaderState getLeaderState();

    public FollowerInfo getFollower();

    default public RaftPeerId getFollowerId() {
        return this.getFollower().getId();
    }

    public long getCallId();

    public Comparator<Long> getCallIdComparator();

    public RaftProtos.AppendEntriesRequestProto newAppendEntriesRequest(long var1, boolean var3) throws RaftLogIOException;

    public RaftProtos.InstallSnapshotRequestProto newInstallSnapshotNotificationRequest(TermIndex var1);

    public Iterable<RaftProtos.InstallSnapshotRequestProto> newInstallSnapshotRequests(String var1, SnapshotInfo var2);

    default public SnapshotInfo shouldInstallSnapshot() {
        long logStartIndex;
        long followerNextIndex;
        FollowerInfo follower = this.getFollower();
        boolean isFollowerBootstrapping = this.getLeaderState().isFollowerBootstrapping(follower);
        SnapshotInfo snapshot = this.getServer().getStateMachine().getLatestSnapshot();
        if (isFollowerBootstrapping && !follower.hasAttemptedToInstallSnapshot()) {
            if (snapshot == null) {
                follower.setAttemptedToInstallSnapshot();
            } else {
                return snapshot;
            }
        }
        if ((followerNextIndex = this.getFollower().getNextIndex()) < this.getRaftLog().getNextIndex() && (followerNextIndex < (logStartIndex = this.getRaftLog().getStartIndex()) || logStartIndex == -1L && snapshot != null)) {
            return snapshot;
        }
        return null;
    }

    public void run() throws InterruptedException, IOException;

    public AwaitForSignal getEventAwaitForSignal();

    default public void notifyLogAppender() {
        this.getEventAwaitForSignal().signal();
    }

    default public boolean shouldSendAppendEntries() {
        return this.hasAppendEntries() || this.getHeartbeatWaitTimeMs() <= 0L;
    }

    default public boolean hasAppendEntries() {
        return this.getFollower().getNextIndex() < this.getRaftLog().getNextIndex();
    }

    public void triggerHeartbeat();

    default public long getHeartbeatWaitTimeMs() {
        int min2 = this.getServer().properties().minRpcTimeoutMs();
        long heartbeatRemainingTimeMs = (long)(min2 / 2) - this.getFollower().getLastRpcResponseTime().elapsedTimeMs();
        long noHeartbeatTimeMs = (long)(min2 / 4) - this.getFollower().getLastHeartbeatSendTime().elapsedTimeMs();
        return Math.max(heartbeatRemainingTimeMs, noHeartbeatTimeMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean onFollowerTerm(long followerTerm) {
        RaftServer.Division division = this.getServer();
        synchronized (division) {
            return this.isRunning() && this.getLeaderState().onFollowerTerm(this.getFollower(), followerTerm);
        }
    }
}

