/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.arithmetic;

import java.nio.charset.Charset;
import java.util.Map;
import org.apache.ratis.examples.arithmetic.Evaluable;
import org.apache.ratis.examples.arithmetic.expression.Expression;
import org.apache.ratis.examples.arithmetic.expression.Variable;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.ProtoUtils;

public class AssignmentMessage
implements Message,
Evaluable {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private final Variable variable;
    private final Expression expression;

    public AssignmentMessage(Variable variable, Expression expression) {
        this.variable = variable;
        this.expression = expression;
    }

    public AssignmentMessage(byte[] buf, int offset) {
        this.variable = new Variable(buf, offset);
        this.expression = Expression.Utils.bytes2Expression(buf, offset + this.variable.length());
    }

    public AssignmentMessage(ByteString bytes) {
        this(bytes.toByteArray(), 0);
    }

    public Variable getVariable() {
        return this.variable;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public ByteString getContent() {
        int length = this.variable.length() + this.expression.length();
        byte[] bytes = new byte[length];
        int offset = this.variable.toBytes(bytes, 0);
        this.expression.toBytes(bytes, offset);
        return ProtoUtils.toByteString(bytes);
    }

    public String toString() {
        return this.variable + " = " + this.expression;
    }

    @Override
    public Double evaluate(Map<String, Double> variableMap) {
        Double value = this.expression.evaluate(variableMap);
        String name = this.variable.getName();
        if (value == null) {
            variableMap.remove(name);
        } else {
            variableMap.put(name, value);
        }
        return value;
    }
}

