/*
 * Decompiled with CFR 0.152.
 */
package io.github.aliyunmq.shaded.slf4j.api.bridge;

import io.github.aliyunmq.shaded.slf4j.api.bridge.ILoggerFactoryAdapter;
import io.github.aliyunmq.shaded.slf4j.api.bridge.IMarkerFactoryAdapter;
import io.github.aliyunmq.shaded.slf4j.api.bridge.MDCAdapterAdapter;
import java.lang.reflect.Method;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.logging.org.slf4j.spi.SLF4JServiceProvider;
import org.slf4j.ILoggerFactory;
import org.slf4j.IMarkerFactory;
import org.slf4j.spi.MDCAdapter;

public class BridgeServiceProvider
implements org.slf4j.spi.SLF4JServiceProvider {
    private static final Logger logger = LoggerFactory.getLogger(BridgeServiceProvider.class);
    private final SLF4JServiceProvider delegate;

    public BridgeServiceProvider() {
        logger.debug("Try to find shaded SLF4j service provider.");
        try {
            Method method = LoggerFactory.class.getDeclaredMethod("getProvider", new Class[0]);
            method.setAccessible(true);
            this.delegate = (SLF4JServiceProvider)method.invoke(null, new Object[0]);
            logger.debug("Found shaded SLF4j service provider.");
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to find shaded SLF4j service provider.", t);
        }
    }

    public ILoggerFactory getLoggerFactory() {
        return new ILoggerFactoryAdapter(this.delegate.getLoggerFactory());
    }

    public IMarkerFactory getMarkerFactory() {
        return new IMarkerFactoryAdapter(this.delegate.getMarkerFactory());
    }

    public MDCAdapter getMDCAdapter() {
        return new MDCAdapterAdapter(this.delegate.getMDCAdapter());
    }

    public String getRequestedApiVersion() {
        return this.delegate.getRequestedApiVersion();
    }

    public void initialize() {
    }
}

