---
version: '0.14'
order: 14
layout: page
menu_title: 0.14
title: Apache Samza 0.14 <a href="/learn/documentation/0.14/">      [Docs] </a> 
---
<!--
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->

We are very excited to announce the release of **Apache Samza 0.14.0**. It is a major release with highly anticipated features viz Samza SQL, Azure EventHubs support and AWS Kinesis consumer.

####Enhancements and Bug Fixes
Overall, [65 JIRAs](https://issues.apache.org/jira/browse/SAMZA-1109?jql=project%20%3D%20SAMZA%20AND%20status%20%3D%20Resolved%20AND%20fixVersion%20%3D%200.14.0%20ORDER%20BY%20priority%20DESC%2C%20key%20ASC) were resolved in this release. Here are few highlights

- [SAMZA-1510](https://issues.apache.org/jira/browse/SAMZA-1510)  Introduce SQL semantics to Samza
- [SAMZA-1438](https://issues.apache.org/jira/browse/SAMZA-1438)  Implement Producer and consumer for Azure EventHubs
- [SAMZA-1515](https://issues.apache.org/jira/browse/SAMZA-1515)  Implement Kinesis consumer
- [SAMZA-1486](https://issues.apache.org/jira/browse/SAMZA-1486)  Checkpoint provider for Azure tables
- [SAMZA-1421](https://issues.apache.org/jira/browse/SAMZA-1421)  Support for durable state in high-level API
- [SAMZA-1392](https://issues.apache.org/jira/browse/SAMZA-1392)  Fix performance and correctness issues with concurrent sends and flushes in kafka system producer
- [SAMZA-1406](https://issues.apache.org/jira/browse/SAMZA-1406)  Enhancements to the Zookeeper based deployment model
- [SAMZA-1321](https://issues.apache.org/jira/browse/SAMZA-1321)  Support for multi-stage batch processing

####Upgrade Notes
- Introduced a new mandatory configuration - `job.coordination.utils.factory`. It impacts applications using non-YARN deployment models. Read more about it [here](/learn/documentation/{{site.version}}/jobs/configuration-table.html).
- The following APIs in SystemAdmin have been deprecated in the previous versions and hence, replaced with newer APIs. If you have a custom System implementation, then you have to update to the newer APIs.
    - `void createChangelogStream(String streamName, int numOfPartitions); -> boolean createStream(StreamSpec streamSpec);`
    - `void createCoordinatorStream(String streamName); -> boolean createStream(StreamSpec streamSpec);`
    - `void validateChangelogStream(String streamName, int numOfPartitions); -> void validateStream(StreamSpec streamSpec) throws StreamValidationException;`
- New API has been added to SystemAdmin that clear a stream.
    - `boolean clearStream(StreamSpec streamSpec);` Read more about it in the [API docs](/learn/documentation/{{site.version}}/api/javadocs/org/apache/samza/system/SystemAdmin.html).

####Sources and Artifacts
[Samza-sources-0.14.tgz](http://www.apache.org/dyn/closer.cgi/samza/0.14.0)

For more details about this release, please check out the [release blog post](https://blogs.apache.org/samza/).
