/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.seatunnel.common.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum DeployMode {
    CLIENT("client"),
    CLUSTER("cluster"),
    ;

    private static final Map<String, DeployMode> NAME_MAP = Arrays.stream(DeployMode.values())
        .collect(HashMap::new, (map, deployMode) -> map.put(deployMode.getName(), deployMode), Map::putAll);

    private final String name;

    DeployMode(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public static Optional<DeployMode> from(String name) {
        return Optional.ofNullable(NAME_MAP.get(name));
    }

}
