/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.record;

import com.hazelcast.cache.impl.record.CacheDataRecord;
import com.hazelcast.cache.impl.record.CacheObjectRecord;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;

public enum CacheRecordReaderWriter {
    DATA(1){

        @Override
        public CacheRecord read(ObjectDataInput in) throws IOException {
            CacheDataRecord record = new CacheDataRecord();
            record.setCreationTime(in.readLong());
            record.setExpirationTime(in.readLong());
            record.setLastAccessTime(in.readLong());
            record.setHits(in.readInt());
            record.setValue(IOUtil.readData(in));
            record.setExpiryPolicy(IOUtil.readData(in));
            return record;
        }

        @Override
        public void write(CacheRecord record, ObjectDataOutput out) throws IOException {
            out.writeLong(record.getCreationTime());
            out.writeLong(record.getExpirationTime());
            out.writeLong(record.getLastAccessTime());
            out.writeInt((int)record.getHits());
            IOUtil.writeData(out, (Data)record.getValue());
            IOUtil.writeData(out, (Data)record.getExpiryPolicy());
        }
    }
    ,
    OBJECT(2){

        @Override
        public CacheRecord read(ObjectDataInput in) throws IOException {
            CacheObjectRecord record = new CacheObjectRecord();
            record.setCreationTime(in.readLong());
            record.setExpirationTime(in.readLong());
            record.setLastAccessTime(in.readLong());
            record.setHits(in.readInt());
            record.setValue(in.readObject());
            record.setExpiryPolicy(in.readObject());
            return record;
        }

        @Override
        public void write(CacheRecord record, ObjectDataOutput out) throws IOException {
            out.writeLong(record.getCreationTime());
            out.writeLong(record.getExpirationTime());
            out.writeLong(record.getLastAccessTime());
            out.writeInt((int)record.getHits());
            out.writeObject(record.getValue());
            out.writeObject(record.getExpiryPolicy());
        }
    };

    private byte recordTypeId;

    private CacheRecordReaderWriter(byte recordTypeId) {
        this.recordTypeId = recordTypeId;
    }

    public static void writeCacheRecord(CacheRecord cacheRecord, ObjectDataOutput out) throws IOException {
        CacheRecordReaderWriter readerWriter = CacheRecordReaderWriter.getByRecord(cacheRecord);
        out.writeByte(readerWriter.recordTypeId);
        readerWriter.write(cacheRecord, out);
    }

    public static CacheRecord readCacheRecord(ObjectDataInput in) throws IOException {
        byte recordTypeId = in.readByte();
        CacheRecordReaderWriter readerWriter = CacheRecordReaderWriter.getByRecordTypeId(recordTypeId);
        return readerWriter.read(in);
    }

    public static CacheRecordReaderWriter getByRecordTypeId(int id) {
        switch (id) {
            case 1: {
                return DATA;
            }
            case 2: {
                return OBJECT;
            }
        }
        throw new IllegalArgumentException("Not known CacheRecordReaderWriter type-id: " + id);
    }

    private static CacheRecordReaderWriter getByRecord(CacheRecord cacheRecord) {
        if (cacheRecord instanceof CacheObjectRecord) {
            return OBJECT;
        }
        return DATA;
    }

    abstract void write(CacheRecord var1, ObjectDataOutput var2) throws IOException;

    abstract CacheRecord read(ObjectDataInput var1) throws IOException;

    private static class RecordTypeId {
        private static final byte DATA = 1;
        private static final byte OBJECT = 2;

        private RecordTypeId() {
        }
    }
}

