/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class EventListenerCounter {
    private final ConcurrentMap<String, AtomicInteger> counterPerMap = new ConcurrentHashMap<String, AtomicInteger>();

    public AtomicInteger getOrCreateCounter(String mapName) {
        return this.counterPerMap.computeIfAbsent(mapName, s2 -> new AtomicInteger());
    }

    public void removeCounter(String mapName, AtomicInteger counter) {
        this.counterPerMap.remove(mapName, counter);
    }

    public void incCounter(String mapName) {
        this.getOrCreateCounter(mapName).incrementAndGet();
    }

    public void decCounter(String mapName) {
        AtomicInteger counter = (AtomicInteger)this.counterPerMap.get(mapName);
        if (counter != null) {
            int count2 = counter.decrementAndGet();
            assert (count2 >= 0);
        }
    }
}

