/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.resourcemanager.worker;

import com.hazelcast.cluster.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Arrays;
import org.apache.seatunnel.engine.server.resourcemanager.resource.ResourceProfile;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotProfile;
import org.apache.seatunnel.engine.server.serializable.ResourceDataSerializerHook;

public class WorkerProfile
implements IdentifiedDataSerializable {
    private Address address;
    private ResourceProfile profile;
    private ResourceProfile unassignedResource;
    private SlotProfile[] assignedSlots;
    private SlotProfile[] unassignedSlots;

    public WorkerProfile(Address address) {
        this.address = address;
        this.unassignedResource = new ResourceProfile();
    }

    public WorkerProfile() {
        this.address = new Address();
    }

    @Override
    public int getFactoryId() {
        return ResourceDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.address);
        out.writeObject(this.profile);
        out.writeObject(this.unassignedResource);
        out.writeInt(this.assignedSlots.length);
        for (SlotProfile assignedSlot : this.assignedSlots) {
            out.writeObject(assignedSlot);
        }
        out.writeInt(this.unassignedSlots.length);
        for (SlotProfile unassignedSlot : this.unassignedSlots) {
            out.writeObject(unassignedSlot);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.address = (Address)in.readObject();
        this.profile = (ResourceProfile)in.readObject();
        this.unassignedResource = (ResourceProfile)in.readObject();
        int assignedSlotsLength = in.readInt();
        this.assignedSlots = new SlotProfile[assignedSlotsLength];
        for (int i = 0; i < this.assignedSlots.length; ++i) {
            this.assignedSlots[i] = (SlotProfile)in.readObject();
        }
        int unassignedSlotsLength = in.readInt();
        this.unassignedSlots = new SlotProfile[unassignedSlotsLength];
        for (int i = 0; i < this.unassignedSlots.length; ++i) {
            this.unassignedSlots[i] = (SlotProfile)in.readObject();
        }
    }

    public Address getAddress() {
        return this.address;
    }

    public ResourceProfile getProfile() {
        return this.profile;
    }

    public ResourceProfile getUnassignedResource() {
        return this.unassignedResource;
    }

    public SlotProfile[] getAssignedSlots() {
        return this.assignedSlots;
    }

    public SlotProfile[] getUnassignedSlots() {
        return this.unassignedSlots;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setProfile(ResourceProfile profile) {
        this.profile = profile;
    }

    public void setUnassignedResource(ResourceProfile unassignedResource) {
        this.unassignedResource = unassignedResource;
    }

    public void setAssignedSlots(SlotProfile[] assignedSlots) {
        this.assignedSlots = assignedSlots;
    }

    public void setUnassignedSlots(SlotProfile[] unassignedSlots) {
        this.unassignedSlots = unassignedSlots;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkerProfile)) {
            return false;
        }
        WorkerProfile other = (WorkerProfile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        ResourceProfile this$profile = this.getProfile();
        ResourceProfile other$profile = other.getProfile();
        if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) {
            return false;
        }
        ResourceProfile this$unassignedResource = this.getUnassignedResource();
        ResourceProfile other$unassignedResource = other.getUnassignedResource();
        if (this$unassignedResource == null ? other$unassignedResource != null : !this$unassignedResource.equals(other$unassignedResource)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAssignedSlots(), other.getAssignedSlots())) {
            return false;
        }
        return Arrays.deepEquals(this.getUnassignedSlots(), other.getUnassignedSlots());
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkerProfile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Address $address = this.getAddress();
        result2 = result2 * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        ResourceProfile $profile = this.getProfile();
        result2 = result2 * 59 + ($profile == null ? 43 : $profile.hashCode());
        ResourceProfile $unassignedResource = this.getUnassignedResource();
        result2 = result2 * 59 + ($unassignedResource == null ? 43 : $unassignedResource.hashCode());
        result2 = result2 * 59 + Arrays.deepHashCode(this.getAssignedSlots());
        result2 = result2 * 59 + Arrays.deepHashCode(this.getUnassignedSlots());
        return result2;
    }

    public String toString() {
        return "WorkerProfile(address=" + this.getAddress() + ", profile=" + this.getProfile() + ", unassignedResource=" + this.getUnassignedResource() + ", assignedSlots=" + Arrays.deepToString(this.getAssignedSlots()) + ", unassignedSlots=" + Arrays.deepToString(this.getUnassignedSlots()) + ")";
    }
}

