/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.group;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.engine.server.execution.Task;
import org.apache.seatunnel.engine.server.execution.TaskGroupDefaultImpl;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.task.SeaTunnelTask;

public class TaskGroupWithIntermediateQueue
extends TaskGroupDefaultImpl {
    public static final int QUEUE_SIZE = 1000;
    private Map<Long, BlockingQueue<Record<?>>> blockingQueueCache = null;

    public TaskGroupWithIntermediateQueue(TaskGroupLocation taskGroupLocation, String taskGroupName, Collection<Task> tasks) {
        super(taskGroupLocation, taskGroupName, tasks);
    }

    @Override
    public void init() {
        this.blockingQueueCache = new ConcurrentHashMap();
        this.getTasks().stream().filter(SeaTunnelTask.class::isInstance).map(s2 -> (SeaTunnelTask)s2).forEach(s2 -> s2.setTaskGroup(this));
    }

    public BlockingQueue<Record<?>> getBlockingQueueCache(long id) {
        this.blockingQueueCache.computeIfAbsent(id, i -> new ArrayBlockingQueue(1000));
        return this.blockingQueueCache.get(id);
    }
}

