/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.spark;

import java.net.URL;
import java.util.List;
import org.apache.seatunnel.apis.base.env.RuntimeEnv;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.config.ConfigRuntimeException;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.apache.seatunnel.spark.BaseSparkSink;
import org.apache.seatunnel.spark.BaseSparkSource;
import org.apache.seatunnel.spark.BaseSparkTransform;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.streaming.Seconds;
import org.apache.spark.streaming.StreamingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkEnvironment
implements RuntimeEnv {
    private static final Logger log = LoggerFactory.getLogger(SparkEnvironment.class);
    private static final long DEFAULT_SPARK_STREAMING_DURATION = 5L;
    private SparkConf sparkConf;
    private SparkSession sparkSession;
    private StreamingContext streamingContext;
    private Config config = ConfigFactory.empty();
    private boolean enableHive = false;
    private JobMode jobMode;

    public SparkEnvironment setEnableHive(boolean enableHive) {
        this.enableHive = enableHive;
        return this;
    }

    @Override
    public SparkEnvironment setConfig(Config config) {
        this.config = config;
        return this;
    }

    @Override
    public RuntimeEnv setJobMode(JobMode mode) {
        this.jobMode = mode;
        return this;
    }

    @Override
    public JobMode getJobMode() {
        return this.jobMode;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public CheckResult checkConfig() {
        return CheckResult.success();
    }

    @Override
    public void registerPlugin(List<URL> pluginPaths) {
        log.info("register plugins :" + pluginPaths);
    }

    @Override
    public SparkEnvironment prepare() {
        this.sparkConf = this.createSparkConf();
        SparkSession.Builder builder = SparkSession.builder().config(this.sparkConf);
        if (this.enableHive) {
            builder.enableHiveSupport();
        }
        this.sparkSession = builder.getOrCreate();
        this.createStreamingContext();
        return this;
    }

    public SparkSession getSparkSession() {
        return this.sparkSession;
    }

    public StreamingContext getStreamingContext() {
        return this.streamingContext;
    }

    public SparkConf getSparkConf() {
        return this.sparkConf;
    }

    private SparkConf createSparkConf() {
        SparkConf sparkConf = new SparkConf();
        this.config.entrySet().forEach(entry -> sparkConf.set((String)entry.getKey(), String.valueOf(((ConfigValue)entry.getValue()).unwrapped())));
        if (this.config.hasPath("job.name")) {
            sparkConf.setAppName(this.config.getString("job.name"));
        }
        return sparkConf;
    }

    private void createStreamingContext() {
        SparkConf conf = this.sparkSession.sparkContext().getConf();
        long duration = conf.getLong("spark.stream.batchDuration", 5L);
        if (this.streamingContext == null) {
            this.streamingContext = new StreamingContext(this.sparkSession.sparkContext(), Seconds.apply((long)duration));
        }
    }

    public static void registerTempView(String tableName, Dataset<Row> ds) {
        ds.createOrReplaceTempView(tableName);
    }

    public static Dataset<Row> registerInputTempView(BaseSparkSource<Dataset<Row>> source, SparkEnvironment environment) {
        Config config = source.getConfig();
        if (config.hasPath("result_table_name")) {
            String tableName = config.getString("result_table_name");
            Dataset<Row> data = source.getData(environment);
            SparkEnvironment.registerTempView(tableName, data);
            return data;
        }
        throw new ConfigRuntimeException("Plugin[" + source.getClass().getName() + "] must be registered as dataset/table, please set \"" + "result_table_name" + "\" config");
    }

    public static Dataset<Row> transformProcess(SparkEnvironment environment, BaseSparkTransform transform2, Dataset<Row> ds) {
        Dataset fromDs;
        Config config = transform2.getConfig();
        if (config.hasPath("source_table_name")) {
            String sourceTableName = config.getString("source_table_name");
            fromDs = environment.getSparkSession().read().table(sourceTableName);
        } else {
            fromDs = ds;
        }
        return transform2.process(fromDs, environment);
    }

    public static void registerTransformTempView(BaseSparkTransform transform2, Dataset<Row> ds) {
        Config config = transform2.getConfig();
        if (config.hasPath("result_table_name")) {
            String resultTableName = config.getString("result_table_name");
            SparkEnvironment.registerTempView(resultTableName, ds);
        }
    }

    public static <T> T sinkProcess(SparkEnvironment environment, BaseSparkSink<T> sink, Dataset<Row> ds) {
        Dataset fromDs;
        Config config = sink.getConfig();
        if (config.hasPath("source_table_name")) {
            String sourceTableName = config.getString("source_table_name");
            fromDs = environment.getSparkSession().read().table(sourceTableName);
        } else {
            fromDs = ds;
        }
        return sink.output(fromDs, environment);
    }
}

