/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.rename;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.schema.event.AlterTableAddColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableChangeColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableColumnsEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableDropColumnEvent;
import org.apache.seatunnel.api.table.schema.event.AlterTableModifyColumnEvent;
import org.apache.seatunnel.api.table.schema.event.SchemaChangeEvent;
import org.apache.seatunnel.api.table.schema.handler.TableSchemaChangeEventDispatcher;
import org.apache.seatunnel.api.table.schema.handler.TableSchemaChangeEventHandler;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.seatunnel.transform.common.AbstractCatalogSupportMapTransform;
import org.apache.seatunnel.transform.rename.FieldRenameConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldRenameTransform
extends AbstractCatalogSupportMapTransform {
    private static final Logger log = LoggerFactory.getLogger(FieldRenameTransform.class);
    public static String PLUGIN_NAME = "FieldRename";
    private CatalogTable inputTable;
    private final FieldRenameConfig config;
    private TableSchemaChangeEventHandler tableSchemaChangeEventHandler;

    public FieldRenameTransform(FieldRenameConfig config, CatalogTable table) {
        super(table);
        this.config = config;
        this.inputTable = table;
        this.tableSchemaChangeEventHandler = new TableSchemaChangeEventDispatcher();
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    protected SeaTunnelRow transformRow(SeaTunnelRow inputRow) {
        return inputRow;
    }

    public SchemaChangeEvent mapSchemaChangeEvent(SchemaChangeEvent event) {
        TableSchema newTableSchema = this.tableSchemaChangeEventHandler.reset(this.inputTable.getTableSchema()).apply(event);
        this.inputTable = CatalogTable.of((TableIdentifier)this.inputTable.getTableId(), (TableSchema)newTableSchema, (Map)this.inputTable.getOptions(), (List)this.inputTable.getPartitionKeys(), (String)this.inputTable.getComment());
        if (event instanceof AlterTableColumnsEvent) {
            AlterTableColumnsEvent alterTableColumnsEvent = (AlterTableColumnsEvent)event;
            AlterTableColumnsEvent newEvent = new AlterTableColumnsEvent(event.tableIdentifier(), alterTableColumnsEvent.getEvents().stream().map(this::convertName).collect(Collectors.toList()));
            newEvent.setJobId(event.getJobId());
            newEvent.setStatement(((AlterTableColumnsEvent)event).getStatement());
            newEvent.setSourceDialectName(((AlterTableColumnsEvent)event).getSourceDialectName());
            if (event.getChangeAfter() != null) {
                newEvent.setChangeAfter(CatalogTable.of((TableIdentifier)event.getChangeAfter().getTableId(), (CatalogTable)event.getChangeAfter()));
            }
            return newEvent;
        }
        if (event instanceof AlterTableColumnEvent) {
            return this.convertName((AlterTableColumnEvent)event);
        }
        return event;
    }

    @Override
    protected TableSchema transformTableSchema() {
        return this.convertTableSchema(this.inputTable.getTableSchema());
    }

    @Override
    protected TableIdentifier transformTableIdentifier() {
        return this.inputTable.getTableId();
    }

    @VisibleForTesting
    public String convertName(String name) {
        if (name == null) {
            return null;
        }
        Optional<FieldRenameConfig.SpecificModify> specificValue = this.getSpecificModify(name);
        if (specificValue.isPresent()) {
            return specificValue.get().getTargetName();
        }
        String replaceTo = null;
        LinkedHashMap replaceIndex = new LinkedHashMap();
        if (CollectionUtils.isNotEmpty(this.config.getReplacementsWithRegex())) {
            for (FieldRenameConfig.ReplacementsWithRegex replacementsWithRegex : this.config.getReplacementsWithRegex()) {
                Boolean isRegex = replacementsWithRegex.getIsRegex();
                String replacement = replacementsWithRegex.getReplaceFrom();
                if (!StringUtils.isNotEmpty((CharSequence)replacement)) continue;
                LinkedHashMap<Integer, Integer> matched = new LinkedHashMap<Integer, Integer>();
                if (BooleanUtils.isNotTrue((Boolean)isRegex)) {
                    if (StringUtils.equals((CharSequence)replacement, (CharSequence)name)) {
                        matched.put(0, name.length());
                    }
                } else {
                    Matcher matcher = Pattern.compile(replacement).matcher(name);
                    while (matcher.find()) {
                        matched.put(matcher.start(), matcher.end());
                    }
                }
                if (matched.isEmpty()) continue;
                replaceTo = replacementsWithRegex.getReplaceTo();
                replaceIndex = matched;
            }
        }
        if (this.config.getConvertCase() != null) {
            switch (this.config.getConvertCase()) {
                case UPPER: {
                    name = name.toUpperCase();
                    break;
                }
                case LOWER: {
                    name = name.toLowerCase();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported convert case: " + (Object)((Object)this.config.getConvertCase()));
                }
            }
        }
        int offset = 0;
        for (Map.Entry index : replaceIndex.entrySet()) {
            int indexStart = (Integer)index.getKey();
            int indexEnd = (Integer)index.getValue();
            name = name.substring(0, indexStart + offset) + replaceTo.trim() + name.substring(indexEnd + offset);
            offset += replaceTo.trim().length() - (indexEnd - indexStart);
        }
        if (StringUtils.isNotBlank((CharSequence)this.config.getPrefix())) {
            name = this.config.getPrefix().trim() + name;
        }
        if (StringUtils.isNotBlank((CharSequence)this.config.getSuffix())) {
            name = name + this.config.getSuffix().trim();
        }
        return name;
    }

    private Optional<FieldRenameConfig.SpecificModify> getSpecificModify(String oldColumnName) {
        if (this.config.getSpecific() == null) {
            return Optional.empty();
        }
        return this.config.getSpecific().stream().filter(specific -> specific.getFieldName().equals(oldColumnName)).findFirst();
    }

    @VisibleForTesting
    public AlterTableColumnEvent convertName(AlterTableColumnEvent event) {
        AlterTableColumnEvent newEvent = event;
        switch (event.getEventType()) {
            case SCHEMA_CHANGE_ADD_COLUMN: {
                AlterTableAddColumnEvent addColumnEvent = (AlterTableAddColumnEvent)event;
                newEvent = new AlterTableAddColumnEvent(event.tableIdentifier(), this.convertName(addColumnEvent.getColumn()), addColumnEvent.isFirst(), this.convertName(addColumnEvent.getAfterColumn()));
                break;
            }
            case SCHEMA_CHANGE_DROP_COLUMN: {
                AlterTableDropColumnEvent dropColumnEvent = (AlterTableDropColumnEvent)event;
                newEvent = new AlterTableDropColumnEvent(event.tableIdentifier(), this.convertName(dropColumnEvent.getColumn()));
                break;
            }
            case SCHEMA_CHANGE_MODIFY_COLUMN: {
                AlterTableModifyColumnEvent modifyColumnEvent = (AlterTableModifyColumnEvent)event;
                newEvent = new AlterTableModifyColumnEvent(event.tableIdentifier(), this.convertName(modifyColumnEvent.getColumn()), modifyColumnEvent.isFirst(), this.convertName(modifyColumnEvent.getAfterColumn()));
                break;
            }
            case SCHEMA_CHANGE_CHANGE_COLUMN: {
                boolean nameChanged;
                AlterTableChangeColumnEvent changeColumnEvent = (AlterTableChangeColumnEvent)event;
                boolean bl = nameChanged = !changeColumnEvent.getOldColumn().equals(changeColumnEvent.getColumn().getName());
                if (nameChanged) {
                    log.warn("FieldRenameTransform does not support changing column name, old column name: {}, new column name: {}", (Object)changeColumnEvent.getOldColumn(), (Object)changeColumnEvent.getColumn().getName());
                    return changeColumnEvent;
                }
                newEvent = new AlterTableChangeColumnEvent(event.tableIdentifier(), this.convertName(changeColumnEvent.getOldColumn()), this.convertName(changeColumnEvent.getColumn()), changeColumnEvent.isFirst(), this.convertName(changeColumnEvent.getAfterColumn()));
                break;
            }
            default: {
                log.warn("Unsupported event: {}", (Object)event);
                return event;
            }
        }
        newEvent.setJobId(event.getJobId());
        newEvent.setStatement(event.getStatement());
        newEvent.setSourceDialectName(event.getSourceDialectName());
        if (event.getChangeAfter() != null) {
            CatalogTable newChangeAfter = CatalogTable.of((TableIdentifier)event.getChangeAfter().getTableId(), (TableSchema)this.convertTableSchema(event.getChangeAfter().getTableSchema()), (Map)event.getChangeAfter().getOptions(), (List)event.getChangeAfter().getPartitionKeys(), (String)event.getChangeAfter().getComment());
            newEvent.setChangeAfter(newChangeAfter);
        }
        return newEvent;
    }

    private Column convertName(Column column) {
        return column.rename(this.convertName(column.getName()));
    }

    private TableSchema convertTableSchema(TableSchema tableSchema) {
        List columns = tableSchema.getColumns().stream().map((? super T column) -> {
            String newColumnName = this.convertName(column.getName());
            return column.rename(newColumnName);
        }).collect(Collectors.toList());
        PrimaryKey primaryKey = Optional.ofNullable(tableSchema.getPrimaryKey()).map((? super T pk) -> PrimaryKey.of((String)pk.getPrimaryKey(), pk.getColumnNames().stream().map(this::convertName).collect(Collectors.toList()), (Boolean)pk.getEnableAutoId())).orElse(null);
        List constraintKeys = Optional.ofNullable(tableSchema.getConstraintKeys()).map((? super T keyList) -> keyList.stream().map((? super T key) -> ConstraintKey.of((ConstraintKey.ConstraintType)key.getConstraintType(), (String)key.getConstraintName(), key.getColumnNames().stream().map((? super T column) -> ConstraintKey.ConstraintKeyColumn.of((String)this.convertName(column.getColumnName()), (ConstraintKey.ColumnSortType)column.getSortType())).collect(Collectors.toList()))).collect(Collectors.toList())).orElse(null);
        return TableSchema.builder().columns(columns).primaryKey(primaryKey).constraintKey(constraintKeys).build();
    }
}

