/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.replace;

import java.io.Serializable;
import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.shade.com.fasterxml.jackson.annotation.JsonAlias;

public class ReplaceTransformConfig
implements Serializable {
    public static final Option<String> KEY_REPLACE_FIELD = Options.key((String)"replace_field").stringType().noDefaultValue().withDescription("The field you want to replace");
    public static final Option<String> KEY_PATTERN = Options.key((String)"pattern").stringType().noDefaultValue().withDescription("The old string that will be replaced");
    public static final Option<String> KEY_REPLACEMENT = Options.key((String)"replacement").stringType().noDefaultValue().withDescription("The new string for replace");
    public static final Option<Boolean> KEY_IS_REGEX = Options.key((String)"is_regex").booleanType().defaultValue((Object)false).withDescription("Use regex for string match");
    public static final Option<Boolean> KEY_REPLACE_FIRST = Options.key((String)"replace_first").booleanType().noDefaultValue().withDescription("Replace the first match string");
    public static final Option<List<TableTransforms>> MULTI_TABLES = Options.key((String)"table_transform").listType(TableTransforms.class).noDefaultValue().withDescription("");
    private String replaceField;
    private String pattern;
    private String replacement;
    private Boolean isRegex;
    private Boolean replaceFirst;

    public static ReplaceTransformConfig of(ReadonlyConfig config) {
        ReplaceTransformConfig replaceTransformConfig = new ReplaceTransformConfig();
        replaceTransformConfig.setReplaceField((String)config.get(KEY_REPLACE_FIELD));
        replaceTransformConfig.setPattern((String)config.get(KEY_PATTERN));
        replaceTransformConfig.setReplacement((String)config.get(KEY_REPLACEMENT));
        replaceTransformConfig.setIsRegex((Boolean)config.get(KEY_IS_REGEX));
        replaceTransformConfig.setReplaceFirst((Boolean)config.get(KEY_REPLACE_FIRST));
        return replaceTransformConfig;
    }

    public String getReplaceField() {
        return this.replaceField;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public Boolean getIsRegex() {
        return this.isRegex;
    }

    public Boolean getReplaceFirst() {
        return this.replaceFirst;
    }

    public void setReplaceField(String replaceField) {
        this.replaceField = replaceField;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public void setIsRegex(Boolean isRegex) {
        this.isRegex = isRegex;
    }

    public void setReplaceFirst(Boolean replaceFirst) {
        this.replaceFirst = replaceFirst;
    }

    public static class TableTransforms
    implements Serializable {
        @JsonAlias(value={"table_path"})
        private String tablePath;
        @JsonAlias(value={"replace_field"})
        private String replaceField;
        @JsonAlias(value={"pattern"})
        private String pattern;
        @JsonAlias(value={"replacement"})
        private String replacement;
        @JsonAlias(value={"is_regex"})
        private Boolean isRegex;
        @JsonAlias(value={"replace_first"})
        private Boolean replaceFirst;

        public String getTablePath() {
            return this.tablePath;
        }

        public String getReplaceField() {
            return this.replaceField;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public Boolean getIsRegex() {
            return this.isRegex;
        }

        public Boolean getReplaceFirst() {
            return this.replaceFirst;
        }

        public void setTablePath(String tablePath) {
            this.tablePath = tablePath;
        }

        public void setReplaceField(String replaceField) {
            this.replaceField = replaceField;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public void setReplacement(String replacement) {
            this.replacement = replacement;
        }

        public void setIsRegex(Boolean isRegex) {
            this.isRegex = isRegex;
        }

        public void setReplaceFirst(Boolean replaceFirst) {
            this.replaceFirst = replaceFirst;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableTransforms)) {
                return false;
            }
            TableTransforms other = (TableTransforms)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$isRegex = this.getIsRegex();
            Boolean other$isRegex = other.getIsRegex();
            if (this$isRegex == null ? other$isRegex != null : !((Object)this$isRegex).equals(other$isRegex)) {
                return false;
            }
            Boolean this$replaceFirst = this.getReplaceFirst();
            Boolean other$replaceFirst = other.getReplaceFirst();
            if (this$replaceFirst == null ? other$replaceFirst != null : !((Object)this$replaceFirst).equals(other$replaceFirst)) {
                return false;
            }
            String this$tablePath = this.getTablePath();
            String other$tablePath = other.getTablePath();
            if (this$tablePath == null ? other$tablePath != null : !this$tablePath.equals(other$tablePath)) {
                return false;
            }
            String this$replaceField = this.getReplaceField();
            String other$replaceField = other.getReplaceField();
            if (this$replaceField == null ? other$replaceField != null : !this$replaceField.equals(other$replaceField)) {
                return false;
            }
            String this$pattern = this.getPattern();
            String other$pattern = other.getPattern();
            if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
                return false;
            }
            String this$replacement = this.getReplacement();
            String other$replacement = other.getReplacement();
            return !(this$replacement == null ? other$replacement != null : !this$replacement.equals(other$replacement));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TableTransforms;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isRegex = this.getIsRegex();
            result = result * 59 + ($isRegex == null ? 43 : ((Object)$isRegex).hashCode());
            Boolean $replaceFirst = this.getReplaceFirst();
            result = result * 59 + ($replaceFirst == null ? 43 : ((Object)$replaceFirst).hashCode());
            String $tablePath = this.getTablePath();
            result = result * 59 + ($tablePath == null ? 43 : $tablePath.hashCode());
            String $replaceField = this.getReplaceField();
            result = result * 59 + ($replaceField == null ? 43 : $replaceField.hashCode());
            String $pattern = this.getPattern();
            result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
            String $replacement = this.getReplacement();
            result = result * 59 + ($replacement == null ? 43 : $replacement.hashCode());
            return result;
        }

        public String toString() {
            return "ReplaceTransformConfig.TableTransforms(tablePath=" + this.getTablePath() + ", replaceField=" + this.getReplaceField() + ", pattern=" + this.getPattern() + ", replacement=" + this.getReplacement() + ", isRegex=" + this.getIsRegex() + ", replaceFirst=" + this.getReplaceFirst() + ")";
        }
    }
}

