/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.options.ConnectorCommonOptions;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.transform.common.AbstractCatalogSupportFlatMapTransform;
import org.apache.seatunnel.transform.sql.SQLEngine;
import org.apache.seatunnel.transform.sql.SQLEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLTransform
extends AbstractCatalogSupportFlatMapTransform {
    private static final Logger log = LoggerFactory.getLogger(SQLTransform.class);
    public static final String PLUGIN_NAME = "Sql";
    public static final Option<String> KEY_QUERY = Options.key((String)"query").stringType().noDefaultValue().withDescription("The query SQL");
    public static final Option<String> KEY_ENGINE = Options.key((String)"engine").stringType().defaultValue((Object)SQLEngineFactory.EngineType.ZETA.name()).withDescription("The SQL engine type");
    private final String query;
    private final SQLEngineFactory.EngineType engineType;
    private SeaTunnelRowType outRowType;
    private transient SQLEngine sqlEngine;
    private final String inputTableName;

    public SQLTransform(@NonNull ReadonlyConfig config, @NonNull CatalogTable catalogTable) {
        super(catalogTable);
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (catalogTable == null) {
            throw new NullPointerException("catalogTable is marked non-null but is null");
        }
        this.query = (String)config.get(KEY_QUERY);
        this.engineType = config.getOptional(KEY_ENGINE).isPresent() ? SQLEngineFactory.EngineType.valueOf(((String)config.get(KEY_ENGINE)).toUpperCase()) : SQLEngineFactory.EngineType.ZETA;
        List pluginInputIdentifiers = (List)config.get(ConnectorCommonOptions.PLUGIN_INPUT);
        this.inputTableName = pluginInputIdentifiers != null && !pluginInputIdentifiers.isEmpty() ? (String)pluginInputIdentifiers.get(0) : catalogTable.getTableId().getTableName();
    }

    public String getPluginName() {
        return PLUGIN_NAME;
    }

    public void open() {
        this.sqlEngine = SQLEngineFactory.getSQLEngine(this.engineType);
        this.sqlEngine.init(this.inputTableName, this.inputCatalogTable.getTableId().getTableName(), this.inputCatalogTable.getSeaTunnelRowType(), this.query);
    }

    private void tryOpen() {
        if (this.sqlEngine == null) {
            this.open();
        }
    }

    @Override
    protected List<SeaTunnelRow> transformRow(SeaTunnelRow inputRow) {
        this.tryOpen();
        return this.sqlEngine.transformBySQL(inputRow, this.outRowType);
    }

    @Override
    protected TableSchema transformTableSchema() {
        this.tryOpen();
        ArrayList<String> inputColumnsMapping = new ArrayList<String>();
        this.outRowType = this.sqlEngine.typeMapping(inputColumnsMapping);
        List<String> outputColumns = Arrays.asList(this.outRowType.getFieldNames());
        TableSchema.Builder builder = TableSchema.builder();
        if (this.inputCatalogTable.getTableSchema().getPrimaryKey() != null && outputColumns.containsAll(this.inputCatalogTable.getTableSchema().getPrimaryKey().getColumnNames())) {
            builder.primaryKey(this.inputCatalogTable.getTableSchema().getPrimaryKey().copy());
        }
        List outputConstraintKeys = this.inputCatalogTable.getTableSchema().getConstraintKeys().stream().filter(key -> {
            List constraintColumnNames = key.getColumnNames().stream().map(ConstraintKey.ConstraintKeyColumn::getColumnName).collect(Collectors.toList());
            return outputColumns.containsAll(constraintColumnNames);
        }).map(ConstraintKey::copy).collect(Collectors.toList());
        builder.constraintKey(outputConstraintKeys);
        String[] fieldNames = this.outRowType.getFieldNames();
        SeaTunnelDataType[] fieldTypes = this.outRowType.getFieldTypes();
        ArrayList<PhysicalColumn> columns = new ArrayList<PhysicalColumn>(fieldNames.length);
        for (int i = 0; i < fieldNames.length; ++i) {
            Column simpleColumn = null;
            String inputColumnName = (String)inputColumnsMapping.get(i);
            if (inputColumnName != null) {
                for (Column inputColumn : this.inputCatalogTable.getTableSchema().getColumns()) {
                    if (!inputColumnName.equals(inputColumn.getName())) continue;
                    simpleColumn = inputColumn;
                    break;
                }
            }
            PhysicalColumn column = simpleColumn != null ? new PhysicalColumn(fieldNames[i], fieldTypes[i], simpleColumn.getColumnLength(), simpleColumn.getScale(), simpleColumn.isNullable(), simpleColumn.getDefaultValue(), simpleColumn.getComment(), simpleColumn.getSourceType(), simpleColumn.getOptions()) : PhysicalColumn.of((String)fieldNames[i], (SeaTunnelDataType)fieldTypes[i], (Integer)0, (boolean)true, null, null);
            columns.add(column);
        }
        return builder.columns(columns).build();
    }

    @Override
    protected TableIdentifier transformTableIdentifier() {
        return this.inputCatalogTable.getTableId().copy();
    }

    public void close() {
        this.sqlEngine.close();
    }
}

